/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import org.apache.cassandra.utils.NativeLibraryWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLibraryLinux
implements NativeLibraryWrapper {
    private static boolean available;
    private static final Logger logger;

    private static native int mlockall(int var0) throws LastErrorException;

    private static native int munlockall() throws LastErrorException;

    private static native int fcntl(int var0, int var1, long var2) throws LastErrorException;

    private static native int posix_fadvise(int var0, long var1, int var3, int var4) throws LastErrorException;

    private static native int open(String var0, int var1) throws LastErrorException;

    private static native int fsync(int var0) throws LastErrorException;

    private static native int close(int var0) throws LastErrorException;

    private static native Pointer strerror(int var0) throws LastErrorException;

    private static native long getpid() throws LastErrorException;

    @Override
    public int callMlockall(int flags) throws UnsatisfiedLinkError, RuntimeException {
        return NativeLibraryLinux.mlockall(flags);
    }

    @Override
    public int callMunlockall() throws UnsatisfiedLinkError, RuntimeException {
        return NativeLibraryLinux.munlockall();
    }

    @Override
    public int callFcntl(int fd, int command, long flags) throws UnsatisfiedLinkError, RuntimeException {
        return NativeLibraryLinux.fcntl(fd, command, flags);
    }

    @Override
    public int callPosixFadvise(int fd, long offset, int len, int flag) throws UnsatisfiedLinkError, RuntimeException {
        return NativeLibraryLinux.posix_fadvise(fd, offset, len, flag);
    }

    @Override
    public int callOpen(String path, int flags) throws UnsatisfiedLinkError, RuntimeException {
        return NativeLibraryLinux.open(path, flags);
    }

    @Override
    public int callFsync(int fd) throws UnsatisfiedLinkError, RuntimeException {
        return NativeLibraryLinux.fsync(fd);
    }

    @Override
    public int callClose(int fd) throws UnsatisfiedLinkError, RuntimeException {
        return NativeLibraryLinux.close(fd);
    }

    @Override
    public Pointer callStrerror(int errnum) throws UnsatisfiedLinkError, RuntimeException {
        return NativeLibraryLinux.strerror(errnum);
    }

    @Override
    public long callGetpid() throws UnsatisfiedLinkError, RuntimeException {
        return NativeLibraryLinux.getpid();
    }

    @Override
    public boolean isAvailable() {
        return available;
    }

    static {
        logger = LoggerFactory.getLogger(NativeLibraryLinux.class);
        try {
            Native.register("c");
            available = true;
        }
        catch (NoClassDefFoundError e) {
            logger.warn("JNA not found. Native methods will be disabled.");
        }
        catch (UnsatisfiedLinkError e) {
            logger.error("Failed to link the C library against JNA. Native methods will be unavailable.", e);
        }
        catch (NoSuchMethodError e) {
            logger.warn("Obsolete version of JNA present; unable to register C library. Upgrade to JNA 3.2.7 or later");
        }
    }
}

