/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.jobs;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.datetime.DateTimeService;
import org.hawkular.metrics.scheduler.api.JobDetails;
import org.hawkular.metrics.scheduler.api.Trigger;
import org.hawkular.metrics.sysconfig.Configuration;
import org.hawkular.metrics.sysconfig.ConfigurationService;
import org.jboss.logging.Logger;
import rx.Completable;
import rx.functions.Func1;

public class TempTableCreator
implements Func1<JobDetails, Completable> {
    private MetricsService service;
    private static Logger logger = Logger.getLogger(TempTableCreator.class);
    public static final String JOB_NAME = "TEMP_TABLE_CREATOR";
    public static final String CONFIG_ID = "org.hawkular.metrics.jobs.TEMP_TABLE_CREATOR";
    public static final String FORWARD_TIME = "org.hawkular.metrics.jobs.TEMP_TABLE_CREATORbuffer.tables.time.forward.duration";
    public static final Duration DEFAULT_FORWARD_TIME = Duration.of(1L, ChronoUnit.DAYS);
    private Duration forwardTime;

    public TempTableCreator(MetricsService metricsService, ConfigurationService configurationService) {
        this.service = metricsService;
        Configuration configuration = (Configuration)configurationService.load(CONFIG_ID).toSingle().toBlocking().value();
        this.forwardTime = configuration.get(FORWARD_TIME) != null ? Duration.parse(configuration.get(FORWARD_TIME)) : DEFAULT_FORWARD_TIME;
    }

    public Completable call(JobDetails jobDetails) {
        Trigger trigger = jobDetails.getTrigger();
        ZonedDateTime currentBlock = ZonedDateTime.ofInstant(Instant.ofEpochMilli(trigger.getTriggerTime()), ZoneOffset.UTC).with(DateTimeService.startOfPreviousEvenHour());
        ZonedDateTime lastMaintainedBlock = currentBlock.plus(this.forwardTime);
        return this.service.verifyAndCreateTempTables(currentBlock, lastMaintainedBlock).doOnCompleted(() -> logger.debugf("Temporary tables are valid until %s", (Object)lastMaintainedBlock.toString()));
    }
}

