/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Statement;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.core.service.DataAccessImpl;
import org.hawkular.rx.cassandra.driver.RxSession;
import org.jboss.logging.Logger;
import org.joda.time.Days;
import rx.Observable;
import rx.Scheduler;
import rx.schedulers.Schedulers;

public class TempTablesCleaner {
    private static Logger logger = Logger.getLogger(TempTablesCleaner.class);
    private RxSession session;
    private PreparedStatement findTables;
    private long ttl;
    private DataAccessImpl dataAccess;
    private volatile boolean finished;
    private static final String DROP_TABLE_CQL = "DROP TABLE IF EXISTS %s";

    public TempTablesCleaner(RxSession session, DataAccessImpl dataAccess, String keyspace, int ttl) {
        this.session = session;
        this.dataAccess = dataAccess;
        this.ttl = Days.days(ttl).toStandardDuration().getMillis();
        this.findTables = session.getSession().prepare("SELECT table_name FROM system_schema.tables WHERE keyspace_name = '" + keyspace + "'");
    }

    public void run() {
        logger.info((Object)"Checking for expired temp tables");
        Observable.interval((long)1L, (TimeUnit)TimeUnit.DAYS, (Scheduler)Schedulers.io()).takeUntil(i -> this.finished).flatMap(i -> this.session.execute((Statement)this.findTables.bind())).compose(this.applyRetryPolicy()).flatMap(Observable::from).filter(row -> row.getString(0).startsWith("data_temp_")).map(row -> row.getString(0)).filter(this::isTableExpired).flatMap(this::dropTable).subscribe(table -> logger.infof("Dropped table %s", table), t -> logger.warn((Object)"Cleaning temp tables failed", t), () -> logger.infof("Finished cleaning expired temp tables", new Object[0]));
    }

    public void shutdown() {
        this.finished = true;
    }

    private <T> Observable.Transformer<T, T> applyRetryPolicy() {
        return tObservable -> tObservable.retryWhen(observable -> {
            Integer maxRetries = Integer.getInteger("hawkular.metrics.temp-table-cleaner.max-retries", 10);
            Integer maxDelay = Integer.getInteger("hawkular.metrics.temp-table-cleaner.max-delay", 300);
            Observable range = Observable.range((int)1, (int)maxRetries);
            Observable zipWith = observable.zipWith(range, (t, i) -> {
                int delay = Math.min((int)Math.pow(2.0, i.intValue()), maxDelay);
                logger.debugf(t, "The findTables query failed. Attempting retry # %d seconds", delay);
                return Observable.timer((long)delay, (TimeUnit)TimeUnit.SECONDS).onBackpressureDrop();
            });
            return Observable.merge((Observable)zipWith);
        });
    }

    private boolean isTableExpired(String table) {
        Long timestamp = this.dataAccess.tableToMapKey(table);
        return timestamp < System.currentTimeMillis() - this.ttl;
    }

    private Observable<String> dropTable(String table) {
        return this.session.execute(String.format(DROP_TABLE_CQL, table)).map(resultSet -> table).onErrorResumeNext(t -> {
            logger.infof(t, "Failed to drop %s", (Object)table);
            return Observable.empty();
        });
    }
}

