/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service.tags;

import com.datastax.driver.core.Row;
import com.google.common.base.MoreObjects;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.hawkular.metrics.core.service.DataAccess;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.core.service.PatternUtil;
import org.hawkular.metrics.core.service.transformers.ItemsToSetTransformer;
import org.hawkular.metrics.core.service.transformers.TagsIndexRowTransformerFilter;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.jboss.logging.Logger;
import rx.Observable;
import rx.functions.Func1;

public class SimpleTagQueryParser {
    private static final Logger logger = Logger.getLogger(SimpleTagQueryParser.class);
    private DataAccess dataAccess;
    private MetricsService metricsService;
    private boolean enableACostQueries;
    private int pageSize;
    private int pageThreshold;

    public SimpleTagQueryParser(DataAccess dataAccess, MetricsService metricsService, boolean disableACostQueries, int pageSize, int pageThreshold) {
        this.dataAccess = dataAccess;
        this.metricsService = metricsService;
        this.enableACostQueries = !disableACostQueries;
        this.pageSize = pageSize;
        this.pageThreshold = pageThreshold;
    }

    public Observable<MetricId<?>> findMetricIdentifiersWithFilters(String tenantId, MetricType<?> metricType, Map<String, String> tagsQueries) {
        logger.debugf("Preparing to optimize and execute %s for tenant %s and for metric type %s", tagsQueries, (Object)tenantId, metricType);
        Map<Long, List<Query>> costSortedMap = QueryOptimizer.reOrderTagsQuery(tagsQueries, this.enableACostQueries);
        List<Query> openshiftQuery = costSortedMap.get(1L);
        List<Query> groupAEntries = costSortedMap.get(10L);
        List<Query> groupAOREntries = costSortedMap.get(11L);
        List<Query> groupBEntries = costSortedMap.get(50L);
        List<Query> groupCEntries = costSortedMap.get(99L);
        Observable groupMetrics = null;
        if (openshiftQuery.size() > 0) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            Observable<Metric<?>> enrichedMetrics = Observable.just((Object)openshiftQuery.get(0)).flatMap(query -> this.dataAccess.findMetricsByTagNameValue(tenantId, query.getTagName(), query.getTagValues()).compose(new TagsIndexRowTransformerFilter(metricType)).compose(new ItemsToSetTransformer()).doOnNext(metricIds -> this.logQuery(tenantId, (Query)query, "pod_id", (Set<? extends MetricId<?>>)metricIds))).flatMap(Observable::from).flatMap(metricId -> {
                Stopwatch findMetricStopWatch = Stopwatch.createStarted();
                return this.metricsService.findMetric(metricId).doOnCompleted(() -> {
                    findMetricStopWatch.stop();
                    logger.debugf("Fetched metric definition for %s in %d ms", metricId, (Object)findMetricStopWatch.elapsed(TimeUnit.MILLISECONDS));
                });
            });
            if (!groupAOREntries.isEmpty()) {
                enrichedMetrics = enrichedMetrics.filter(m -> {
                    for (Query q : groupAOREntries) {
                        HashSet<String> values = Sets.newHashSet(q.tagValues);
                        if (values.contains(m.getTags().getOrDefault(q.tagName, ""))) continue;
                        return false;
                    }
                    return true;
                });
            }
            enrichedMetrics = this.applyBFilters(enrichedMetrics, groupAEntries);
            enrichedMetrics = this.applyBFilters(enrichedMetrics, groupBEntries);
            enrichedMetrics = this.applyCFilters(enrichedMetrics, groupCEntries);
            groupMetrics = enrichedMetrics.map(Metric::getMetricId);
            return groupMetrics.doOnError(t -> logger.warnf(t, "Finding %s metrics with tag queries %s failed", (Object)metricType, (Object)tagsQueries)).doOnCompleted(() -> {
                stopwatch.stop();
                logger.debugf("Finished fetch metrics using pod_id optimization in %d ms", stopwatch.elapsed(TimeUnit.MILLISECONDS));
            });
        }
        if (!groupAEntries.isEmpty() || !groupAOREntries.isEmpty()) {
            if (!groupAEntries.isEmpty()) {
                groupMetrics = Observable.from(groupAEntries).flatMap(e -> this.dataAccess.findMetricsByTagNameValue(tenantId, e.getTagName(), e.getTagValueMatcher()).compose(new TagsIndexRowTransformerFilter(metricType)).compose(new ItemsToSetTransformer()).doOnNext(metricIds -> this.logQuery(tenantId, (Query)e, "A", (Set<? extends MetricId<?>>)metricIds))).reduce((s1, s2) -> {
                    s1.retainAll((Collection<?>)s2);
                    return s1;
                }).flatMap(Observable::from);
            }
            if (!groupAOREntries.isEmpty()) {
                Observable groupAORMetrics = Observable.from(groupAOREntries).flatMap(e -> this.dataAccess.findMetricsByTagNameValue(tenantId, e.getTagName(), e.getTagValues()).compose(new TagsIndexRowTransformerFilter(metricType)).compose(new ItemsToSetTransformer()).doOnNext(metricIds -> this.logQuery(tenantId, (Query)e, "A_OR", (Set<? extends MetricId<?>>)metricIds)).reduce((s1, s2) -> {
                    s1.addAll(s2);
                    return s1;
                })).flatMap(Observable::from);
                if (groupMetrics == null) {
                    groupMetrics = groupAORMetrics;
                } else {
                    Observable groupAPart = groupMetrics.toList().map(HashSet::new);
                    Observable groupAORPart = groupAORMetrics.toList().map(HashSet::new);
                    groupMetrics = groupAPart.mergeWith(groupAORPart).reduce((s1, s2) -> {
                        s1.retainAll((Collection<?>)s2);
                        return s1;
                    }).flatMap(Observable::from);
                }
            }
            if (!groupBEntries.isEmpty() || !groupCEntries.isEmpty()) {
                logger.debug((Object)"Fetching metric definitions");
                AtomicLong count = new AtomicLong();
                Observable<Metric<?>> enrichedMetrics = groupMetrics.flatMap(mId -> this.metricsService.findMetric(mId).doOnNext(m -> count.incrementAndGet()).doOnTerminate(() -> logger.debugf("Fetched %d metric definitions for tenant %s", count.get(), (Object)tenantId)));
                if (!groupBEntries.isEmpty()) {
                    enrichedMetrics = this.applyBFilters(enrichedMetrics, groupBEntries);
                }
                if (!groupCEntries.isEmpty()) {
                    enrichedMetrics = this.applyCFilters(enrichedMetrics, groupCEntries);
                }
                groupMetrics = enrichedMetrics.map(Metric::getMetricId);
            }
        } else if (!groupBEntries.isEmpty()) {
            groupMetrics = Observable.from(groupBEntries).flatMap(e -> {
                logger.debugf("Fetching all metrics for %s", (Object)Query.toString(tenantId, e, "B"));
                return this.dataAccess.findMetricsByTagName(tenantId, e.getTagName()).filter(this.tagValueFilter(e.getTagValueMatcher(), 3)).compose(new TagsIndexRowTransformerFilter(metricType)).compose(new ItemsToSetTransformer()).doOnNext(metricIds -> this.logQuery(tenantId, (Query)e, "B", (Set<? extends MetricId<?>>)metricIds)).reduce((s1, s2) -> {
                    s1.addAll(s2);
                    return s1;
                });
            }).reduce((s1, s2) -> {
                s1.retainAll((Collection<?>)s2);
                return s1;
            }).flatMap(Observable::from);
            if (!groupCEntries.isEmpty()) {
                groupMetrics = this.applyCFilters(groupMetrics.flatMap(this.metricsService::findMetric), groupCEntries).map(Metric::getMetricId);
            }
        } else {
            logger.warnf("Fetching all metric definitions for tenant %s. This can be an expensive operation for large data sets which can result in timeouts!", (Object)tenantId);
            Observable tagsMetrics = this.dataAccess.findAllMetricsFromTagsIndex().compose(new TagsIndexRowTransformerFilter(metricType)).filter(mId -> mId.getTenantId().equals(tenantId));
            Observable dataMetrics = this.metricsService.findAllMetricIdentifiers().filter(m -> m.getTenantId().equals(tenantId)).filter(this.metricTypeFilter(metricType));
            AtomicLong count = new AtomicLong();
            groupMetrics = this.applyCFilters(Observable.concat((Observable)tagsMetrics, (Observable)dataMetrics).distinct().flatMap(mId -> this.metricsService.findMetric(mId).doOnNext(m -> count.incrementAndGet()).doAfterTerminate(() -> logger.infof("Fetched %d metric definitions for tenant %s", (Object)count.get(), (Object)tenantId))), groupCEntries).map(Metric::getMetricId);
        }
        return groupMetrics;
    }

    private void logQuery(String tenantId, Query query, String queryType, Set<? extends MetricId<?>> metricIds) {
        if (logger.isDebugEnabled()) {
            logger.debugf("Tag query %s returned %d rows", (Object)Query.toString(tenantId, query, queryType), (Object)metricIds.size());
        } else if (metricIds.size() / this.pageSize > this.pageThreshold) {
            logger.infof("Tag query %s returned %d rows", (Object)Query.toString(tenantId, query, queryType), (Object)metricIds.size());
        }
    }

    private Observable<Metric<?>> applyBFilters(Observable<Metric<?>> metrics, List<Query> groupBEntries) {
        for (Query groupBQuery : groupBEntries) {
            metrics = metrics.filter(this.tagValueFilter(groupBQuery.getTagValueMatcher(), groupBQuery.getTagName()));
        }
        return metrics;
    }

    private Observable<Metric<?>> applyCFilters(Observable<Metric<?>> metrics, List<Query> groupCEntries) {
        for (Query groupCQuery : groupCEntries) {
            metrics = metrics.filter(this.tagNotExistsFilter(groupCQuery.getTagName().substring(1)));
        }
        return metrics;
    }

    public Observable<Map<String, Set<String>>> getTagValues(String tenantId, MetricType<?> metricType, Map<String, String> tagsQueries) {
        return Observable.from(tagsQueries.entrySet()).flatMap(e -> this.dataAccess.findMetricsByTagName(tenantId, (String)e.getKey()).filter(this.typeFilter(metricType, 1)).filter(this.tagValueFilter((String)e.getValue(), 3)).map(row -> {
            HashMap idMap = new HashMap();
            HashMap valueMap = new HashMap();
            valueMap.put(e.getKey(), row.getString(3));
            idMap.put(row.getString(2), valueMap);
            return idMap;
        }).switchIfEmpty(Observable.just(new HashMap())).reduce((map1, map2) -> {
            map1.putAll(map2);
            return map1;
        })).reduce((m1, m2) -> {
            Iterator iterator = m1.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                if (!m2.containsKey(next.getKey())) {
                    iterator.remove();
                    continue;
                }
                Map map2 = (Map)m2.get(next.getKey());
                map2.forEach((k, v) -> ((Map)next.getValue()).put(k, v));
            }
            return m1;
        }).map(m -> {
            HashMap tagValueMap = new HashMap();
            m.forEach((k, v) -> v.forEach((subKey, subValue) -> {
                if (tagValueMap.containsKey(subKey)) {
                    ((Set)tagValueMap.get(subKey)).add(subValue);
                } else {
                    HashSet<String> values = new HashSet<String>();
                    values.add((String)subValue);
                    tagValueMap.put(subKey, values);
                }
            }));
            return tagValueMap;
        });
    }

    public Observable<String> getTagNames(String tenantId, MetricType<?> metricType, String filter) {
        Observable tagNames = metricType == null ? this.dataAccess.getTagNames().filter(r -> tenantId.equals(r.getString(0))).map(r -> r.getString(1)).distinct() : this.dataAccess.getTagNamesWithType().filter(this.typeFilter(metricType, 2)).filter(r -> tenantId.equals(r.getString(0))).map(r -> r.getString(1)).distinct();
        return tagNames.filter(this.tagNameFilter(filter));
    }

    private Func1<Metric<?>, Boolean> tagNotExistsFilter(String unwantedTagName) {
        return tMetric -> !tMetric.getTags().keySet().contains(unwantedTagName);
    }

    private Func1<String, Boolean> tagNameFilter(String regexp) {
        if (regexp != null) {
            boolean positive = !regexp.startsWith("!");
            Pattern p = PatternUtil.filterPattern(regexp);
            return s -> positive == p.matcher((CharSequence)s).matches();
        }
        return s -> true;
    }

    private Func1<Row, Boolean> tagValueFilter(String regexp, int index) {
        boolean positive = !regexp.startsWith("!");
        Pattern p = PatternUtil.filterPattern(regexp);
        return r -> positive == p.matcher(r.getString(index)).matches();
    }

    private Func1<Metric<?>, Boolean> tagValueFilter(String regexp, String tagName) {
        return tMetric -> {
            String tagValue = tMetric.getTags().get(tagName);
            if (tagValue != null) {
                boolean positive = !regexp.startsWith("!");
                Pattern p = PatternUtil.filterPattern(regexp);
                return positive == p.matcher(tagValue).matches();
            }
            return false;
        };
    }

    public Func1<Row, Boolean> typeFilter(MetricType<?> type, int index) {
        return row -> {
            MetricType<?> metricType = MetricType.fromCode(row.getByte(index));
            return type == null && metricType.isUserType() || metricType == type;
        };
    }

    public Func1<MetricId<?>, Boolean> metricTypeFilter(MetricType<?> type) {
        return tMetricId -> type == null && tMetricId.getType().isUserType() || tMetricId.getType() == type;
    }

    static class QueryOptimizer {
        public static final String OPENSHIFT_OPTIMIZED_TAG_QUERY = "pod_id";
        public static final long GROUP_OPENSHIFT_OPTIMIZATION = 1L;
        public static final long GROUP_A_COST = 10L;
        public static final long GROUP_A_OR_COST = 11L;
        public static final long GROUP_B_COST = 50L;
        public static final long GROUP_C_COST = 99L;
        public static String IS_REGEXP = "^.*[]?+*{}()\\[^$|\\\\]+.*$|^[!].*";
        public static Pattern MATCH_REGEXP = Pattern.compile(IS_REGEXP);

        QueryOptimizer() {
        }

        public static Map<Long, List<Query>> reOrderTagsQuery(Map<String, String> tagsQuery, boolean enableACostQueries) {
            ArrayList<Query> groupASortedList = new ArrayList<Query>();
            ArrayList<Query> openshiftQuery = new ArrayList<Query>(1);
            TreeMap<Long, List<Query>> costSortedMap = new TreeMap<Long, List<Query>>();
            costSortedMap.put(1L, openshiftQuery);
            costSortedMap.put(10L, groupASortedList);
            costSortedMap.put(11L, new ArrayList());
            costSortedMap.put(50L, new ArrayList());
            costSortedMap.put(99L, new ArrayList());
            block3: for (Map.Entry<String, String> tagQuery : tagsQuery.entrySet()) {
                if (tagQuery.getKey().startsWith("!")) {
                    ((List)costSortedMap.get(99L)).add(new Query(tagQuery.getKey(), tagQuery.getValue(), new String[0]));
                    continue;
                }
                if (enableACostQueries && !QueryOptimizer.isRegExp(tagQuery.getValue())) {
                    ((List)costSortedMap.get(10L)).add(new Query(tagQuery.getKey(), tagQuery.getValue(), new String[0]));
                    continue;
                }
                RegExpOptimizer strategy = QueryOptimizer.optimalStrategy(tagQuery.getValue());
                switch (strategy) {
                    case OR_SINGLE_SEEK: {
                        String[] queries = tagQuery.getValue().split("\\|");
                        ((List)costSortedMap.get(11L)).add(new Query(tagQuery.getKey(), null, queries));
                        continue block3;
                    }
                }
                ((List)costSortedMap.get(50L)).add(new Query(tagQuery.getKey(), tagQuery.getValue(), new String[0]));
            }
            Query podIdQuery = QueryOptimizer.getPodIdQuery(groupASortedList);
            if (podIdQuery == null) {
                podIdQuery = QueryOptimizer.getPodIdQuery((List)costSortedMap.get(11L));
                if (podIdQuery != null) {
                    openshiftQuery.add(podIdQuery);
                }
            } else {
                openshiftQuery.add(new Query(podIdQuery.tagName, null, podIdQuery.tagValueMatcher));
            }
            return costSortedMap;
        }

        private static Query getPodIdQuery(List<Query> queries) {
            Query podIdQuery = null;
            Iterator<Query> iterator = queries.iterator();
            while (iterator.hasNext()) {
                Query next = iterator.next();
                if (!OPENSHIFT_OPTIMIZED_TAG_QUERY.equals(next.tagName)) continue;
                podIdQuery = next;
                iterator.remove();
                break;
            }
            return podIdQuery;
        }

        public static boolean isRegExp(String tagValuesQuery) {
            return MATCH_REGEXP.matcher(tagValuesQuery).matches();
        }

        public static RegExpOptimizer optimalStrategy(String tagValuesQuery) {
            String[] orParts = tagValuesQuery.split("\\|");
            if (orParts.length > 1) {
                for (String orPart : orParts) {
                    if (!QueryOptimizer.isRegExp(orPart)) continue;
                    return RegExpOptimizer.NONE;
                }
                return RegExpOptimizer.OR_SINGLE_SEEK;
            }
            return RegExpOptimizer.NONE;
        }

        static enum RegExpOptimizer {
            OR_SINGLE_SEEK,
            NONE;

        }
    }

    static class Query {
        private String tagName;
        private String tagValueMatcher;
        private String[] tagValues;

        public Query(String tagName, String tagValueMatcher, String ... tagValues) {
            this.tagName = tagName;
            if (tagValues.length > 0) {
                this.tagValues = tagValues;
            } else {
                this.tagValueMatcher = tagValueMatcher;
            }
        }

        public String getTagName() {
            return this.tagName;
        }

        public String getTagValueMatcher() {
            return this.tagValueMatcher;
        }

        public String[] getTagValues() {
            return this.tagValues;
        }

        public static String toString(String tenantId, Query query, String queryType) {
            return MoreObjects.toStringHelper(query).omitNullValues().add("tenantId", tenantId).add("queryType", queryType).add("tagName", query.tagName).add("tagValueMatcher", query.tagValueMatcher).add("tagValues", query.tagValues == null ? null : Arrays.toString(query.tagValues)).toString();
        }
    }
}

