/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service.transformers;

import com.datastax.driver.core.Row;
import fi.iki.yak.ts.compression.gorilla.ByteBufferBitOutput;
import fi.iki.yak.ts.compression.gorilla.Compressor;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Map;
import org.hawkular.metrics.core.service.compress.CompressedPointContainer;
import org.hawkular.metrics.core.service.compress.CompressorHeader;
import org.hawkular.metrics.core.service.compress.TagsSerializer;
import org.hawkular.metrics.model.AvailabilityType;
import rx.Observable;

public class TempTableCompressTransformer
implements Observable.Transformer<Row, CompressedPointContainer> {
    private long timeslice;

    public TempTableCompressTransformer(long timeslice) {
        this.timeslice = timeslice;
    }

    public Observable<CompressedPointContainer> call(Observable<Row> dataRow) {
        ByteBufferBitOutput out = new ByteBufferBitOutput();
        byte gorillaHeader = CompressorHeader.getHeader(CompressorHeader.Compressor.GORILLA, EnumSet.noneOf(CompressorHeader.GorillaSettings.class));
        out.getByteBuffer().put(gorillaHeader);
        Compressor compressor = new Compressor(this.timeslice, out);
        TagsSerializer tagsSerializer = new TagsSerializer(this.timeslice);
        return dataRow.collect(CompressedPointContainer::new, (container, r) -> {
            long timestamp = r.getTimestamp(3).getTime();
            switch (r.getByte(1)) {
                case 0: {
                    compressor.addValue(timestamp, r.getDouble(4));
                    break;
                }
                case 1: {
                    compressor.addValue(timestamp, Byte.valueOf(AvailabilityType.fromBytes(r.getBytes(5)).getCode()).doubleValue());
                    break;
                }
                case 2: {
                    compressor.addValue(timestamp, Long.valueOf(r.getLong(6)).doubleValue());
                    break;
                }
                default: {
                    throw new RuntimeException("Metric of type " + r.getByte(1) + " is not supported in compression");
                }
            }
            Map<String, String> tags = r.getMap(7, String.class, String.class);
            if (tags != null && !tags.isEmpty()) {
                tagsSerializer.addDataPointTags(timestamp, tags);
            }
        }).doOnNext(cpc -> {
            compressor.close();
            ByteBuffer valueBuffer = (ByteBuffer)out.getByteBuffer().flip();
            ByteBuffer tagsBuffer = (ByteBuffer)tagsSerializer.getByteBuffer().flip();
            cpc.setValueBuffer(valueBuffer);
            if (tagsBuffer.limit() > 1) {
                cpc.setTagsBuffer(tagsBuffer);
            }
        });
    }
}

