/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import org.openjdk.jmh.util.TempFile;
import org.openjdk.jmh.util.TempFileManager;

public class FileUtils {
    static final TempFileManager TEMP_FILE_MANAGER = new TempFileManager();

    private FileUtils() {
    }

    public static TempFile weakTempFile(String suffix) throws IOException {
        return TEMP_FILE_MANAGER.create(suffix);
    }

    public static void purgeTemps() {
        TEMP_FILE_MANAGER.purge();
    }

    public static File tempFile(String suffix) throws IOException {
        File file = File.createTempFile("jmh", suffix);
        file.deleteOnExit();
        return file;
    }

    /*
     * Exception decompiling
     */
    public static File extractFromResource(String name) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String createTempFileWithLines(String suffix, Iterable<String> lines) throws IOException {
        File file = FileUtils.tempFile(suffix);
        PrintWriter pw = new PrintWriter(file);
        for (String l : lines) {
            pw.println(l);
        }
        pw.close();
        return file.getAbsolutePath();
    }

    /*
     * Exception decompiling
     */
    public static Collection<String> tail(File file, int num) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Collection<String> readAllLines(Reader src) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(src);
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        return lines;
    }

    public static Collection<String> readAllLines(File file) throws IOException {
        try (FileReader fr = new FileReader(file);){
            Collection<String> collection = FileUtils.readAllLines(fr);
            return collection;
        }
    }

    /*
     * Loose catch block
     */
    public static Collection<String> readAllLines(InputStream stream) throws IOException {
        try {
            try (InputStreamReader reader = new InputStreamReader(stream);){
                Collection<String> collection = FileUtils.readAllLines(reader);
                return collection;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            FileUtils.safelyClose(stream);
        }
    }

    public static void writeLines(File file, Collection<String> lines) throws IOException {
        try (PrintWriter pw = new PrintWriter(file);){
            for (String line : lines) {
                pw.println(line);
            }
            pw.close();
        }
    }

    public static void appendLines(File file, Collection<String> lines) throws IOException {
        ArrayList<String> newLines = new ArrayList<String>();
        try {
            newLines.addAll(FileUtils.readAllLines(file));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        newLines.addAll(lines);
        FileUtils.writeLines(file, newLines);
    }

    public static Collection<File> getClasses(File root) {
        ArrayList<File> result = new ArrayList<File>();
        ArrayList<File> newDirs = new ArrayList<File>();
        newDirs.add(root);
        while (!newDirs.isEmpty()) {
            ArrayList<File> add = new ArrayList<File>();
            for (File dir : newDirs) {
                File[] files = dir.listFiles();
                if (files == null) continue;
                for (File f : files) {
                    if (f.isDirectory()) {
                        add.add(f);
                        continue;
                    }
                    if (!f.getName().endsWith(".class")) continue;
                    result.add(f);
                }
            }
            newDirs.clear();
            newDirs = add;
        }
        return result;
    }

    public static void copy(String src, String dst) throws IOException {
        try (FileInputStream fis = new FileInputStream(src);
             FileOutputStream fos = new FileOutputStream(dst);){
            int read;
            byte[] buf = new byte[8192];
            while ((read = fis.read(buf)) != -1) {
                fos.write(buf, 0, read);
            }
            fos.close();
        }
    }

    public static <T extends Flushable & Closeable> void safelyClose(T obj) {
        if (obj != null) {
            try {
                obj.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                ((Closeable)obj).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static <T extends Closeable> void safelyClose(T obj) {
        if (obj != null) {
            try {
                obj.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void touch(String f) throws IOException {
        File file = new File(f);
        try {
            if (file.createNewFile() || file.canWrite()) {
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new IOException("The file is not writable: " + f);
    }
}

