/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.datetime;

import java.util.function.Supplier;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.Hours;
import org.joda.time.Period;

public class DateTimeService {
    public static Supplier<DateTime> now = DateTime::now;

    public static DateTime currentMinute() {
        return DateTimeService.getTimeSlice(now.get(), Duration.standardMinutes((long)1L));
    }

    public static DateTime currentHour() {
        return DateTimeService.getTimeSlice(now.get(), Hours.ONE.toStandardDuration());
    }

    public static DateTime current24HourTimeSlice() {
        return DateTimeService.get24HourTimeSlice(DateTimeService.currentHour());
    }

    public static DateTime get24HourTimeSlice(DateTime time) {
        return DateTimeService.getTimeSlice(time, Days.ONE.toStandardDuration());
    }

    public static long getTimeSlice(long time, Duration duration) {
        return DateTimeService.getTimeSlice(new DateTime(time), duration).getMillis();
    }

    public static DateTime getTimeSlice(DateTime dt, Duration duration) {
        Period p = duration.toPeriod();
        if (p.getYears() != 0) {
            return dt.yearOfEra().roundFloorCopy().minusYears(dt.getYearOfEra() % p.getYears());
        }
        if (p.getMonths() != 0) {
            return dt.monthOfYear().roundFloorCopy().minusMonths((dt.getMonthOfYear() - 1) % p.getMonths());
        }
        if (p.getWeeks() != 0) {
            return dt.weekOfWeekyear().roundFloorCopy().minusWeeks((dt.getWeekOfWeekyear() - 1) % p.getWeeks());
        }
        if (p.getDays() != 0) {
            return dt.dayOfMonth().roundFloorCopy().minusDays((dt.getDayOfMonth() - 1) % p.getDays());
        }
        if (p.getHours() != 0) {
            return dt.hourOfDay().roundFloorCopy().minusHours(dt.getHourOfDay() % p.getHours());
        }
        if (p.getMinutes() != 0) {
            return dt.minuteOfHour().roundFloorCopy().minusMinutes(dt.getMinuteOfHour() % p.getMinutes());
        }
        if (p.getSeconds() != 0) {
            return dt.secondOfMinute().roundFloorCopy().minusSeconds(dt.getSecondOfMinute() % p.getSeconds());
        }
        return dt.millisOfSecond().roundCeilingCopy().minusMillis(dt.getMillisOfSecond() % p.getMillis());
    }
}

