/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hawkular.metrics.model.BucketPoint;
import org.hawkular.metrics.model.Buckets;
import org.hawkular.metrics.model.Percentile;

public class NumericBucketPoint
extends BucketPoint {
    private final double min;
    private final double avg;
    private final double median;
    private final double max;
    private int samples;
    private final List<Percentile> percentiles;

    private NumericBucketPoint(long start, long end, double min, double avg, double median, double max, List<Percentile> percentiles, int samples) {
        super(start, end);
        this.min = min;
        this.avg = avg;
        this.median = median;
        this.max = max;
        this.percentiles = percentiles;
        this.samples = samples;
    }

    public double getMin() {
        return this.min;
    }

    public double getAvg() {
        return this.avg;
    }

    public double getMedian() {
        return this.median;
    }

    public double getMax() {
        return this.max;
    }

    public List<Percentile> getPercentiles() {
        return this.percentiles;
    }

    public int getSamples() {
        return this.samples;
    }

    @Override
    public boolean isEmpty() {
        return this.samples == 0 || Double.isNaN(this.min) || Double.isNaN(this.avg) || Double.isNaN(this.median) || Double.isNaN(this.max);
    }

    public String toString() {
        return "NumericBucketPoint[start=" + this.getStart() + ", end=" + this.getEnd() + ", min=" + this.min + ", avg=" + this.avg + ", median=" + this.median + ", max=" + this.max + ", percentiles=" + this.percentiles + ", samples=" + this.samples + ", isEmpty=" + this.isEmpty() + ']';
    }

    public static List<NumericBucketPoint> toList(Map<Long, NumericBucketPoint> pointMap, Buckets buckets) {
        return BucketPoint.toList(pointMap, buckets, (start, end) -> new Builder((long)start, (long)end).build());
    }

    public static class Builder {
        private final long start;
        private final long end;
        private double min = Double.NaN;
        private double avg = Double.NaN;
        private double median = Double.NaN;
        private double max = Double.NaN;
        private List<Percentile> percentiles = new ArrayList<Percentile>();
        private int samples = 0;

        public Builder(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public Builder(NumericBucketPoint numericBucketPoint) {
            this.start = numericBucketPoint.getStart();
            this.end = numericBucketPoint.getEnd();
            this.setMin(numericBucketPoint.getMin());
            this.setAvg(numericBucketPoint.getAvg());
            this.setMedian(numericBucketPoint.getMedian());
            this.setMax(numericBucketPoint.getMax());
        }

        public Builder setMin(double min) {
            this.min = min;
            return this;
        }

        public Builder setAvg(double avg) {
            this.avg = avg;
            return this;
        }

        public Builder setMedian(double median) {
            this.median = median;
            return this;
        }

        public Builder setMax(double max) {
            this.max = max;
            return this;
        }

        public Builder setPercentiles(List<Percentile> percentiles) {
            this.percentiles = percentiles;
            return this;
        }

        public Builder setSamples(int samples) {
            this.samples = samples;
            return this;
        }

        public NumericBucketPoint build() {
            return new NumericBucketPoint(this.start, this.end, this.min, this.avg, this.median, this.max, this.percentiles, this.samples);
        }
    }
}

