/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.hawkular.metrics.model.MetricType;

public class MetricId<T> {
    private final String tenantId;
    private final MetricType<T> type;
    private final String name;

    public MetricId(String tenantId, MetricType<T> type, String name) {
        Preconditions.checkArgument((tenantId != null ? 1 : 0) != 0, (Object)"tenantId is null");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type is null");
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name is null");
        this.tenantId = tenantId;
        this.type = type;
        this.name = name;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public MetricType<T> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricId metricId = (MetricId)o;
        return Objects.equals(this.name, metricId.name) && Objects.equals(this.tenantId, metricId.tenantId) && Objects.equals(this.type, metricId.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.tenantId, this.type);
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("tenantId", (Object)this.tenantId).add("type", this.type).add("name", (Object)this.name).omitNullValues().toString();
    }
}

