/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class DataPoint<T> {
    protected final long timestamp;
    protected final T value;
    protected final Map<String, String> tags;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public DataPoint(@JsonProperty(value="timestamp") Long timestamp, @JsonProperty(value="value") T value) {
        Preconditions.checkArgument((timestamp != null ? 1 : 0) != 0, (Object)"Data point timestamp is null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Data point value is null");
        this.timestamp = timestamp;
        this.value = value;
        this.tags = Collections.emptyMap();
    }

    public DataPoint(Long timestamp, T value, Map<String, String> tags) {
        Preconditions.checkArgument((timestamp != null ? 1 : 0) != 0, (Object)"Data point timestamp is null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Data point value is null");
        this.timestamp = timestamp;
        this.value = value;
        this.tags = Collections.unmodifiableMap(tags);
    }

    @ApiModelProperty(required=true)
    public long getTimestamp() {
        return this.timestamp;
    }

    @ApiModelProperty(required=true)
    public T getValue() {
        return this.value;
    }

    @ApiModelProperty(required=false)
    public Map<String, String> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataPoint dataPoint = (DataPoint)o;
        return Objects.equals(this.timestamp, dataPoint.timestamp) && Objects.equals(this.value, dataPoint.value) && Objects.equals(this.tags, dataPoint.tags);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.value, this.tags);
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("timestamp", this.timestamp).add("value", this.value).add("tags", this.tags).omitNullValues().toString();
    }
}

