/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.hawkular.metrics.model.AvailabilityType;

public final class MetricType<T> {
    public static final MetricType<Double> GAUGE = new MetricType(0, "gauge", true);
    public static final MetricType<AvailabilityType> AVAILABILITY = new MetricType(1, "availability", true);
    public static final MetricType<Long> COUNTER = new MetricType(2, "counter", true);
    public static final MetricType<Double> COUNTER_RATE = new MetricType(3, "counter_rate", false);
    public static final MetricType<String> STRING = new MetricType(4, "string", true);
    public static final MetricType UNDEFINED = new MetricType(127, "undefined", false);
    private static final Set<MetricType<?>> all = ImmutableSet.of(GAUGE, AVAILABILITY, COUNTER, COUNTER_RATE);
    private static final Set<MetricType<?>> userTypes;
    private static final Map<Byte, MetricType<?>> codes;
    private static final Map<String, MetricType<?>> texts;
    private final byte code;
    private final String text;
    private final boolean userType;

    private MetricType(byte code, String text, boolean userType) {
        this.code = code;
        this.text = text;
        this.userType = userType;
    }

    public byte getCode() {
        return this.code;
    }

    public String getText() {
        return this.text;
    }

    public boolean isUserType() {
        return this.userType;
    }

    public String toString() {
        return this.getText();
    }

    public static MetricType<?> fromCode(byte code) {
        MetricType<?> type = codes.get(code);
        if (type == null) {
            throw new IllegalArgumentException(code + " is not a recognized metric type");
        }
        return type;
    }

    public static MetricType<?> fromTextCode(String textCode) {
        if (textCode == null || textCode.trim().isEmpty()) {
            return UNDEFINED;
        }
        MetricType<?> type = texts.get(textCode);
        if (type == null) {
            throw new IllegalArgumentException(textCode + " is not a recognized metric type");
        }
        return type;
    }

    public static Set<MetricType<?>> all() {
        return all;
    }

    public static Set<MetricType<?>> userTypes() {
        return userTypes;
    }

    static {
        ImmutableSet.Builder userTypesBuilder = ImmutableSet.builder();
        ImmutableMap.Builder codesBuilder = ImmutableMap.builder();
        ImmutableMap.Builder textsBuilder = ImmutableMap.builder();
        all.forEach(type -> {
            if (type.isUserType()) {
                userTypesBuilder.add(type);
            }
            codesBuilder.put((Object)type.code, type);
            textsBuilder.put((Object)type.text, type);
        });
        userTypes = userTypesBuilder.build();
        codes = codesBuilder.build();
        Preconditions.checkArgument((codes.size() == all.size() ? 1 : 0) != 0, (Object)"Some metric types have the same code");
        texts = textsBuilder.build();
        Preconditions.checkArgument((texts.size() == all.size() ? 1 : 0) != 0, (Object)"Some metric types have the same string value");
    }
}

