/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model.param;

import com.google.common.base.MoreObjects;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.model.Utils;

public class TimeRange {
    static final long EIGHT_HOURS = TimeUnit.MILLISECONDS.convert(8L, TimeUnit.HOURS);
    private final long start;
    private final long end;
    private final boolean valid;
    private final String problem;

    public TimeRange(Long start, Long end) {
        long now = System.currentTimeMillis();
        this.start = start == null ? now - EIGHT_HOURS : start;
        long l = this.end = end == null ? now : end;
        if (!Utils.isValidTimeRange(this.start, this.end)) {
            this.valid = false;
            this.problem = "Range end must be strictly greater than start";
        } else {
            this.valid = true;
            this.problem = null;
        }
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getProblem() {
        return this.problem;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("start", this.start).add("end", this.end).add("valid", this.valid).add("problem", (Object)this.problem).omitNullValues().toString();
    }
}

