/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.fasterxml.jackson.MetricTypeDeserializer;
import org.hawkular.metrics.model.fasterxml.jackson.MetricTypeSerializer;

public class Metric<T> {
    private final MetricId<T> id;
    private final Map<String, String> tags;
    private final Integer dataRetention;
    private final List<DataPoint<T>> dataPoints;
    private final Long minTimestamp;
    private final Long maxTimestamp;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public Metric(@JsonProperty(value="id") String id, @JsonProperty(value="tags") Map<String, String> tags, @JsonProperty(value="dataRetention") Integer dataRetention, @JsonProperty(value="type") @JsonDeserialize(using=MetricTypeDeserializer.class) MetricType<T> type, @JsonProperty(value="data") List<DataPoint<T>> data, @JsonProperty(value="tenantId", defaultValue="") String tenantId) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Metric id is null");
        if (type == null) {
            type = MetricType.UNDEFINED;
        }
        if (tenantId == null) {
            tenantId = "";
        }
        this.id = new MetricId(tenantId, type, id);
        this.tags = tags == null ? Collections.emptyMap() : Collections.unmodifiableMap(tags);
        this.dataRetention = dataRetention;
        this.dataPoints = data == null || data.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(data);
        this.maxTimestamp = null;
        this.minTimestamp = null;
    }

    public Metric(String id, Map<String, String> tags, Integer dataRetention, MetricType<T> type, List<DataPoint<T>> data) {
        this(id, tags, dataRetention, type, data, "");
    }

    public Metric(MetricId<T> id) {
        this(id, Collections.emptyMap(), null, Collections.emptyList());
    }

    public Metric(MetricId<T> id, Integer dataRetention) {
        this(id, Collections.emptyMap(), dataRetention, Collections.emptyList());
    }

    public Metric(MetricId<T> id, Map<String, String> tags, Integer dataRetention) {
        this(id, tags, dataRetention, Collections.emptyList());
    }

    public Metric(MetricId<T> id, List<DataPoint<T>> dataPoints) {
        this(id, Collections.emptyMap(), null, dataPoints);
    }

    public Metric(MetricId<T> id, List<DataPoint<T>> dataPoints, Integer dataRetention) {
        this(id, Collections.emptyMap(), dataRetention, dataPoints);
    }

    public Metric(MetricId<T> id, Map<String, String> tags, Integer dataRetention, List<DataPoint<T>> dataPoints) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"id is null");
        Preconditions.checkArgument((tags != null ? 1 : 0) != 0, (Object)"tags is null");
        Preconditions.checkArgument((dataPoints != null ? 1 : 0) != 0, (Object)"dataPoints is null");
        this.id = id;
        this.tags = Collections.unmodifiableMap(tags);
        this.dataRetention = dataRetention;
        this.dataPoints = Collections.unmodifiableList(dataPoints);
        this.maxTimestamp = null;
        this.minTimestamp = null;
    }

    public Metric(Metric<T> other, long minTimestamp, long maxTimestamp) {
        this.id = other.id;
        this.tags = other.tags;
        this.dataRetention = other.dataRetention;
        this.dataPoints = other.dataPoints;
        this.minTimestamp = minTimestamp;
        this.maxTimestamp = maxTimestamp;
    }

    public String getId() {
        return this.getMetricId().getName();
    }

    public String getTenantId() {
        return this.getMetricId().getTenantId();
    }

    @ApiModelProperty(value="Metric type", dataType="string", allowableValues="gauge, availability, counter")
    @JsonSerialize(using=MetricTypeSerializer.class)
    public MetricType<T> getType() {
        return this.getMetricId().getType();
    }

    @JsonIgnore
    public MetricId<T> getMetricId() {
        return this.id;
    }

    @ApiModelProperty(value="Metric tags")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    public Map<String, String> getTags() {
        return this.tags;
    }

    @ApiModelProperty(value="How long, in days, a data point of this metric stays in the system after it is stored")
    public Integer getDataRetention() {
        return this.dataRetention;
    }

    @ApiModelProperty(value="Metric data points")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    public List<DataPoint<T>> getDataPoints() {
        return this.dataPoints;
    }

    @ApiModelProperty(value="Timestamp of the metric's oldest data point")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    public Long getMinTimestamp() {
        return this.minTimestamp;
    }

    @ApiModelProperty(value="Timestamp of the metric's most recent data point")
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    public Long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metric metric = (Metric)o;
        return Objects.equals(this.id, metric.id) && Objects.equals(this.tags, metric.tags) && Objects.equals(this.dataRetention, metric.dataRetention);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.tags, this.dataRetention);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("tags", this.tags).add("dataRetention", (Object)this.dataRetention).add("dataPoints", this.dataPoints).toString();
    }
}

