/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model;

import com.google.common.base.Preconditions;

public final class Buckets {
    private final long start;
    private final long step;
    private final int count;

    public Buckets(long start, long step, int count) {
        Preconditions.checkArgument((start > 0L ? 1 : 0) != 0, (Object)"start is not positive");
        this.start = start;
        Preconditions.checkArgument((step > 0L ? 1 : 0) != 0, (Object)"step is not positive");
        this.step = step;
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"count is not positive");
        this.count = count;
    }

    public long getStart() {
        return this.start;
    }

    public long getStep() {
        return this.step;
    }

    public int getCount() {
        return this.count;
    }

    public int getIndex(long timestamp) {
        Preconditions.checkArgument((timestamp >= this.start && timestamp < this.start + (long)this.count * this.step ? 1 : 0) != 0, (Object)"timestamp out of range");
        return (int)((timestamp - this.start) / this.step);
    }

    public long getBucketStart(int index) {
        Preconditions.checkArgument((index >= 0 && index < this.count ? 1 : 0) != 0, (Object)"index out of range");
        return this.start + (long)index * this.step;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Buckets buckets = (Buckets)o;
        return this.count == buckets.count && this.start == buckets.start && this.step == buckets.step;
    }

    public int hashCode() {
        int result = (int)(this.start ^ this.start >>> 32);
        result = 31 * result + (int)(this.step ^ this.step >>> 32);
        result = 31 * result + this.count;
        return result;
    }

    public String toString() {
        return "Buckets[start=" + this.start + ", step=" + this.step + ", count=" + this.count + ']';
    }

    public static Buckets fromCount(long start, long end, int count) {
        Buckets.checkTimeRange(start, end);
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (String)"count is not positive: %s", (int)count);
        long quotient = (end - start) / (long)count;
        long remainder = (end - start) % (long)count;
        long step = remainder != 0L && (long)(count - 1) * (quotient + 1L) < end - start ? quotient + 1L : quotient;
        Preconditions.checkArgument((step > 0L ? 1 : 0) != 0, (Object)"Computed step is equal to zero");
        return new Buckets(start, step, count);
    }

    public static Buckets fromStep(long start, long end, long step) {
        Buckets.checkTimeRange(start, end);
        Preconditions.checkArgument((step > 0L ? 1 : 0) != 0, (String)"step is not positive: %s", (long)step);
        if (step > end - start) {
            return new Buckets(start, step, 1);
        }
        long quotient = (end - start) / step;
        long remainder = (end - start) % step;
        long count = remainder == 0L ? quotient : quotient + 1L;
        Preconditions.checkArgument((count <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Computed number of buckets is too big: %s", (long)count);
        return new Buckets(start, step, (int)count);
    }

    private static void checkTimeRange(long start, long end) {
        Preconditions.checkArgument((end > start ? 1 : 0) != 0, (String)"Start is higher than end: %s, %s", (long)start, (long)end);
    }
}

