/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model.param;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.hawkular.metrics.model.param.Tags;

public class TagNames {
    private final Set<String> names;

    public TagNames(Set<String> names) {
        Preconditions.checkArgument((names != null ? 1 : 0) != 0, (Object)"names is null");
        Preconditions.checkArgument((boolean)names.stream().allMatch(Tags::isValid), (String)"Invalid tag name: %s", names);
        this.names = ImmutableSet.copyOf(names);
    }

    private static boolean isValid(Map.Entry<String, String> tag) {
        return TagNames.isValid(tag.getKey()) && TagNames.isValid(tag.getValue());
    }

    private static boolean isValid(String s) {
        return s != null && !s.trim().isEmpty();
    }

    public Set<String> getNames() {
        return this.names;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagNames tagNames = (TagNames)o;
        return this.names.equals(tagNames.names);
    }

    public int hashCode() {
        return this.names.hashCode();
    }

    public String toString() {
        return "TagNames{names=" + this.names + '}';
    }
}

