/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model.param;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Duration {
    public static final ImmutableBiMap<TimeUnit, String> UNITS = new ImmutableBiMap.Builder().put((Object)TimeUnit.MILLISECONDS, (Object)"ms").put((Object)TimeUnit.SECONDS, (Object)"s").put((Object)TimeUnit.MINUTES, (Object)"mn").put((Object)TimeUnit.HOURS, (Object)"h").put((Object)TimeUnit.DAYS, (Object)"d").build();
    private static final Pattern REGEXP = Pattern.compile("(\\d+)(" + UNITS.values().stream().collect(Collectors.joining("|")) + ")");
    private static final ImmutableBiMap<String, TimeUnit> STRING_UNITS = UNITS.inverse();
    private final long value;
    private final TimeUnit timeUnit;

    public Duration(long value, TimeUnit timeUnit) {
        Preconditions.checkArgument((timeUnit != null ? 1 : 0) != 0, (Object)"timeUnit is null");
        Preconditions.checkArgument((boolean)UNITS.containsKey((Object)timeUnit), (String)"Invalid unit %s", (Object[])new Object[]{timeUnit});
        this.value = value;
        this.timeUnit = timeUnit;
    }

    public Duration(String duration) {
        Matcher matcher = REGEXP.matcher(duration);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"Invalid duration %s", (Object[])new Object[]{duration});
        long value = Long.valueOf(matcher.group(1));
        TimeUnit timeUnit = (TimeUnit)((Object)STRING_UNITS.get((Object)matcher.group(2)));
        Preconditions.checkArgument((timeUnit != null ? 1 : 0) != 0, (Object)"timeUnit is null");
        Preconditions.checkArgument((boolean)UNITS.containsKey((Object)timeUnit), (String)"Invalid unit %s", (Object[])new Object[]{timeUnit});
        this.value = value;
        this.timeUnit = timeUnit;
    }

    public long getValue() {
        return this.value;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public long toMillis() {
        return TimeUnit.MILLISECONDS.convert(this.value, this.timeUnit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duration duration = (Duration)o;
        return this.value == duration.value && this.timeUnit == duration.timeUnit;
    }

    public int hashCode() {
        int result = (int)(this.value ^ this.value >>> 32);
        result = 31 * result + this.timeUnit.hashCode();
        return result;
    }

    public String toString() {
        return "Duration[value=" + this.value + ", timeUnit=" + (Object)((Object)this.timeUnit) + ']';
    }
}

