/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hawkular.metrics.model.Percentile;

public class TaggedBucketPoint {
    private Map<String, String> tags;
    private final double min;
    private final double avg;
    private final double median;
    private final double max;
    private final double sum;
    private int samples;
    private final List<Percentile> percentiles;

    public TaggedBucketPoint(Map<String, String> tags, double min, double avg, double median, double max, double sum, int samples, List<Percentile> percentiles) {
        this.tags = tags;
        this.min = min;
        this.avg = avg;
        this.median = median;
        this.max = max;
        this.sum = sum;
        this.samples = samples;
        this.percentiles = percentiles;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public double getMin() {
        return this.min;
    }

    public double getAvg() {
        return this.avg;
    }

    public double getMedian() {
        return this.median;
    }

    public double getMax() {
        return this.max;
    }

    public double getSum() {
        return this.sum;
    }

    public int getSamples() {
        return this.samples;
    }

    public List<Percentile> getPercentiles() {
        return this.percentiles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaggedBucketPoint that = (TaggedBucketPoint)o;
        return Objects.equals(this.min, that.min) && Objects.equals(this.avg, that.avg) && Objects.equals(this.median, that.median) && Objects.equals(this.max, that.max) && Objects.equals(this.sum, that.sum) && Objects.equals(this.samples, that.samples) && Objects.equals(this.tags, that.tags) && Objects.equals(this.percentiles, that.percentiles);
    }

    public int hashCode() {
        return Objects.hash(this.tags, this.min, this.avg, this.median, this.max, this.sum, this.samples, this.percentiles);
    }

    public String toString() {
        return "TaggedBucketPoint{tags=" + this.tags + ", min=" + this.min + ", avg=" + this.avg + ", median=" + this.median + ", max=" + this.max + ", sum=" + this.sum + ", samples=" + this.samples + ", percentiles=" + this.percentiles + '}';
    }
}

