/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.hawkular.metrics.model.Buckets;

public abstract class BucketPoint {
    private final long start;
    private final long end;

    protected BucketPoint(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    protected Double getDoubleValue(double value) {
        if (Double.isNaN(value)) {
            return null;
        }
        return value;
    }

    public abstract boolean isEmpty();

    public static <T extends BucketPoint> List<T> toList(Map<Long, T> pointMap, Buckets buckets, BiFunction<Long, Long, T> emptyBucketFactory) {
        ArrayList<BucketPoint> result = new ArrayList<BucketPoint>(buckets.getCount());
        for (int index = 0; index < buckets.getCount(); ++index) {
            long from = buckets.getBucketStart(index);
            BucketPoint bucketPoint = (BucketPoint)pointMap.get(from);
            if (bucketPoint == null) {
                long to = from + buckets.getStep();
                bucketPoint = (BucketPoint)emptyBucketFactory.apply(from, to);
            }
            result.add(bucketPoint);
        }
        return result;
    }
}

