/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;
import org.hawkular.metrics.model.DataPoint;

public class NamedDataPoint<T>
extends DataPoint<T> {
    private String name;

    public NamedDataPoint(String name, Long timestamp, T value, Map<String, String> tags) {
        super(timestamp, value, tags);
        this.name = name;
    }

    public NamedDataPoint(String name, DataPoint<T> dataPoint) {
        super(dataPoint.getTimestamp(), dataPoint.getValue(), dataPoint.getTags());
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedDataPoint that = (NamedDataPoint)o;
        return Objects.equals(this.name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("timestamp", this.getTimestamp()).add("value", this.getValue()).add("tags", this.getTags()).toString();
    }
}

