/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.openshift.auth;

import com.google.common.collect.Sets;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.hawkular.openshift.auth.BasicAuthenticator;
import org.hawkular.openshift.auth.SecurityOption;
import org.hawkular.openshift.auth.TokenAuthenticator;
import org.hawkular.openshift.auth.Utils;

public class OpenshiftAuthHandler
implements HttpHandler {
    private static final String SECURITY_OPTION_SYSPROP = "hawkular-metrics.openshift.auth-methods";
    private static final Set<SecurityOption> SECURITY_OPTIONS;
    private final HttpHandler containerHandler;
    private final TokenAuthenticator tokenAuthenticator;
    private final BasicAuthenticator basicAuthenticator;

    public OpenshiftAuthHandler(HttpHandler containerHandler) {
        this.containerHandler = containerHandler;
        this.tokenAuthenticator = new TokenAuthenticator(containerHandler);
        this.basicAuthenticator = new BasicAuthenticator(containerHandler);
    }

    public void handleRequest(HttpServerExchange serverExchange) throws Exception {
        if (Methods.OPTIONS.equals(serverExchange.getRequestMethod()) && serverExchange.getRequestHeaders().contains(Headers.ORIGIN)) {
            this.containerHandler.handleRequest(serverExchange);
            return;
        }
        String path = serverExchange.getRelativePath();
        if (path == null || path.equals("") || path.equals("/") || path.equals("/status") || path.startsWith("/static")) {
            this.containerHandler.handleRequest(serverExchange);
            return;
        }
        if (SECURITY_OPTIONS.contains((Object)SecurityOption.DISABLED)) {
            this.containerHandler.handleRequest(serverExchange);
            return;
        }
        String authorizationHeader = serverExchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION);
        if (authorizationHeader == null) {
            Utils.endExchange(serverExchange, 403);
        } else if (authorizationHeader.startsWith("Bearer ") && SECURITY_OPTIONS.contains((Object)SecurityOption.OPENSHIFT_OAUTH)) {
            this.tokenAuthenticator.handleRequest(serverExchange);
        } else if (authorizationHeader.startsWith("Basic ") && SECURITY_OPTIONS.contains((Object)SecurityOption.HTPASSWD)) {
            this.basicAuthenticator.handleRequest(serverExchange);
        } else {
            Utils.endExchange(serverExchange, 403);
        }
    }

    public void stop() {
        this.basicAuthenticator.stop();
        this.tokenAuthenticator.stop();
    }

    static {
        HashSet<SecurityOption> active = new HashSet<SecurityOption>();
        String property = System.getProperty(SECURITY_OPTION_SYSPROP, SecurityOption.OPENSHIFT_OAUTH.toString());
        Set configured = Arrays.stream(property.split(",")).map(String::trim).collect(Collectors.toSet());
        for (SecurityOption option : SecurityOption.values()) {
            if (!configured.contains(option.toString())) continue;
            active.add(option);
        }
        SECURITY_OPTIONS = Sets.immutableEnumSet(active);
    }
}

