/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.rx.cassandra.driver;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;

public class RxUtil {
    private RxUtil() {
    }

    public static <T> Observable<T> from(ListenableFuture<T> future, Scheduler scheduler) {
        final Scheduler.Worker worker = scheduler.createWorker();
        return RxUtil.from(future, new Executor(){

            @Override
            public void execute(final Runnable command) {
                worker.schedule(new Action0(){

                    public void call() {
                        command.run();
                    }
                });
            }
        });
    }

    public static <T> Observable<T> from(final ListenableFuture<T> future, final Executor executor) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            public void call(final Subscriber<? super T> subscriber) {
                future.addListener(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Object t = future.get();
                            subscriber.onNext(t);
                            subscriber.onCompleted();
                        }
                        catch (Exception e) {
                            subscriber.onError((Throwable)e);
                        }
                    }
                }, executor);
            }
        });
    }
}

