/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.rx.cassandra.driver;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.ListenableFuture;
import org.hawkular.rx.cassandra.driver.ResultSetToRowsTransformer;
import org.hawkular.rx.cassandra.driver.RxSession;
import rx.Observable;
import rx.Scheduler;
import rx.observable.ListenableFutureObservable;
import rx.schedulers.Schedulers;

public class RxSessionImpl
implements RxSession {
    private Session session;

    public RxSessionImpl(Session session) {
        this.session = session;
    }

    @Override
    public String getLoggedKeyspace() {
        return this.session.getLoggedKeyspace();
    }

    @Override
    public RxSession init() {
        this.session.init();
        return this;
    }

    @Override
    public Observable<ResultSet> execute(String query) {
        ResultSetFuture future = this.session.executeAsync(query);
        return ListenableFutureObservable.from((ListenableFuture)future, (Scheduler)Schedulers.computation());
    }

    @Override
    public Observable<Row> executeAndFetch(String query) {
        return this.execute(query).compose((Observable.Transformer)new ResultSetToRowsTransformer());
    }

    @Override
    public Observable<ResultSet> execute(String query, Scheduler scheduler) {
        ResultSetFuture future = this.session.executeAsync(query);
        return ListenableFutureObservable.from((ListenableFuture)future, (Scheduler)scheduler);
    }

    @Override
    public Observable<Row> executeAndFetch(String query, Scheduler scheduler) {
        return this.execute(query, scheduler).compose((Observable.Transformer)new ResultSetToRowsTransformer(scheduler));
    }

    @Override
    public Observable<ResultSet> execute(String query, Object ... values) {
        ResultSetFuture future = this.session.executeAsync(query, values);
        return ListenableFutureObservable.from((ListenableFuture)future, (Scheduler)Schedulers.computation());
    }

    @Override
    public Observable<Row> executeAndFetch(String query, Object ... values) {
        return this.execute(query, values).compose((Observable.Transformer)new ResultSetToRowsTransformer());
    }

    @Override
    public Observable<ResultSet> execute(String query, Scheduler scheduler, Object ... values) {
        ResultSetFuture future = this.session.executeAsync(query, new Object[]{values, scheduler});
        return ListenableFutureObservable.from((ListenableFuture)future, (Scheduler)scheduler);
    }

    @Override
    public Observable<Row> executeAndFetch(String query, Scheduler scheduler, Object ... values) {
        return this.execute(query, scheduler, values).compose((Observable.Transformer)new ResultSetToRowsTransformer(scheduler));
    }

    @Override
    public Observable<ResultSet> execute(Statement statement) {
        ResultSetFuture future = this.session.executeAsync(statement);
        return ListenableFutureObservable.from((ListenableFuture)future, (Scheduler)Schedulers.computation());
    }

    @Override
    public Observable<Row> executeAndFetch(Statement statement) {
        return this.execute(statement).compose((Observable.Transformer)new ResultSetToRowsTransformer());
    }

    @Override
    public Observable<ResultSet> execute(Statement statement, Scheduler scheduler) {
        ResultSetFuture future = this.session.executeAsync(statement);
        return ListenableFutureObservable.from((ListenableFuture)future, (Scheduler)scheduler);
    }

    @Override
    public Observable<Row> executeAndFetch(Statement statement, Scheduler scheduler) {
        return this.execute(statement, scheduler).compose((Observable.Transformer)new ResultSetToRowsTransformer(scheduler));
    }

    @Override
    public Observable<PreparedStatement> prepare(String query) {
        ListenableFuture future = this.session.prepareAsync(query);
        return ListenableFutureObservable.from((ListenableFuture)future, (Scheduler)Schedulers.computation());
    }

    @Override
    public Observable<PreparedStatement> prepare(String query, Scheduler scheduler) {
        ListenableFuture future = this.session.prepareAsync(query);
        return ListenableFutureObservable.from((ListenableFuture)future, (Scheduler)scheduler);
    }

    @Override
    public Observable<PreparedStatement> prepare(RegularStatement statement) {
        ListenableFuture future = this.session.prepareAsync(statement);
        return ListenableFutureObservable.from((ListenableFuture)future, (Scheduler)Schedulers.computation());
    }

    @Override
    public Observable<PreparedStatement> prepare(RegularStatement statement, Scheduler scheduler) {
        ListenableFuture future = this.session.prepareAsync(statement);
        return ListenableFutureObservable.from((ListenableFuture)future, (Scheduler)scheduler);
    }

    @Override
    public void close() {
        this.session.close();
    }

    @Override
    public boolean isClosed() {
        return this.session.isClosed();
    }

    @Override
    public Cluster getCluster() {
        return this.session.getCluster();
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public Session.State getState() {
        return this.session.getState();
    }
}

