/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.scheduler.impl;

import com.google.common.base.MoreObjects;
import java.util.Objects;

public class Lock {
    private final String name;
    private final String value;
    private final long expirationTime;
    private final int renewalRate;
    private final boolean locked;

    public Lock(String name, String value, long expirationTime, int renewalRate) {
        this.name = name;
        this.value = value;
        this.expirationTime = expirationTime;
        this.renewalRate = renewalRate;
        this.locked = false;
    }

    public Lock(String name, String value, long expirationTime, int renewalRate, boolean locked) {
        this.name = name;
        this.value = value;
        this.expirationTime = expirationTime;
        this.renewalRate = renewalRate;
        this.locked = locked;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public long getExpiration() {
        return this.expirationTime;
    }

    public int getRenewalRate() {
        return this.renewalRate;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Lock lock = (Lock)o;
        return this.expirationTime == lock.expirationTime && this.renewalRate == lock.renewalRate && this.locked == lock.locked && Objects.equals(this.name, lock.name) && Objects.equals(this.value, lock.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.expirationTime, this.renewalRate, this.locked);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("value", this.value).add("expirationTime", this.expirationTime).add("renewalRate", this.renewalRate).add("locked", this.locked).toString();
    }
}

