/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayDeque;
import java.util.Deque;
import rx.Observable;
import rx.Subscriber;
import rx.internal.operators.NotificationLite;

public class OperatorSkipLast<T>
implements Observable.Operator<T, T> {
    final int count;

    public OperatorSkipLast(int count) {
        if (count < 0) {
            throw new IndexOutOfBoundsException("count could not be negative");
        }
        this.count = count;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> subscriber) {
        return new Subscriber<T>(subscriber){
            private final Deque<Object> deque;
            {
                super(x0);
                this.deque = new ArrayDeque<Object>();
            }

            @Override
            public void onCompleted() {
                subscriber.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                subscriber.onError(e);
            }

            @Override
            public void onNext(T value) {
                if (OperatorSkipLast.this.count == 0) {
                    subscriber.onNext(value);
                    return;
                }
                if (this.deque.size() == OperatorSkipLast.this.count) {
                    subscriber.onNext(NotificationLite.getValue(this.deque.removeFirst()));
                } else {
                    this.request(1L);
                }
                this.deque.offerLast(NotificationLite.next(value));
            }
        };
    }
}

