/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.scheduler.impl;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.hawkular.metrics.scheduler.api.JobParameters;
import rx.Completable;

public class JobParametersImpl
implements JobParameters {
    private Map<String, String> parameters = new HashMap<String, String>();
    private Function<Map<String, String>, Completable> saveParameters;

    JobParametersImpl(Map<String, String> parameters, Function<Map<String, String>, Completable> saveParameters) {
        this.parameters.putAll(parameters);
        this.saveParameters = saveParameters;
    }

    public void setSaveParameters(Function<Map<String, String>, Completable> saveParameters) {
        this.saveParameters = saveParameters;
    }

    @Override
    public String get(String key) {
        return this.parameters.get(key);
    }

    @Override
    public String put(String key, String value) {
        return this.parameters.put(key, value);
    }

    @Override
    public String remove(String key) {
        return this.parameters.remove(key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.parameters.containsKey(key);
    }

    @Override
    public Map<String, String> getMap() {
        return ImmutableMap.copyOf(this.parameters);
    }

    @Override
    public Completable save() {
        return this.saveParameters.apply(this.parameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobParametersImpl that = (JobParametersImpl)o;
        return Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.parameters);
    }

    public String toString() {
        return this.parameters.toString();
    }
}

