/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.schemabuilder;

import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.datastax.driver.core.schemabuilder.SchemaStatement;
import com.datastax.driver.core.schemabuilder.StatementStart;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;

public abstract class TableOptions<T extends TableOptions>
extends SchemaStatement {
    private StatementStart statementStart;
    private Optional<SchemaBuilder.Caching> cassandra20Caching = Optional.absent();
    private Optional<SchemaBuilder.KeyCaching> cassandra21KeyCaching = Optional.absent();
    private Optional<CachingRowsPerPartition> cassandra21RowCaching = Optional.absent();
    private Optional<Double> bloomFilterFPChance = Optional.absent();
    private Optional<String> comment = Optional.absent();
    private Optional<CompressionOptions> compressionOptions = Optional.absent();
    private Optional<CompactionOptions> compactionOptions = Optional.absent();
    private Optional<Double> dcLocalReadRepairChance = Optional.absent();
    private Optional<Integer> defaultTTL = Optional.absent();
    private Optional<Integer> gcGraceSeconds = Optional.absent();
    private Optional<Integer> indexInterval = Optional.absent();
    private Optional<Integer> minIndexInterval = Optional.absent();
    private Optional<Integer> maxIndexInterval = Optional.absent();
    private Optional<Integer> memtableFlushPeriodInMillis = Optional.absent();
    private Optional<Boolean> populateIOOnCacheFlush = Optional.absent();
    private Optional<Double> readRepairChance = Optional.absent();
    private Optional<Boolean> replicateOnWrite = Optional.absent();
    private Optional<SpeculativeRetryValue> speculativeRetry = Optional.absent();
    private Optional<Boolean> cdc = Optional.absent();
    private List<String> customOptions = new ArrayList<String>();
    private final T self = this;

    TableOptions(StatementStart statementStart) {
        this.statementStart = statementStart;
    }

    public T caching(SchemaBuilder.Caching caching) {
        this.cassandra20Caching = Optional.fromNullable(caching);
        return this.self;
    }

    public T caching(SchemaBuilder.KeyCaching keys, CachingRowsPerPartition rowsPerPartition) {
        this.cassandra21KeyCaching = Optional.fromNullable(keys);
        this.cassandra21RowCaching = Optional.fromNullable(rowsPerPartition);
        return this.self;
    }

    public T bloomFilterFPChance(Double fpChance) {
        TableOptions.validateRateValue(fpChance, "Bloom filter false positive change");
        this.bloomFilterFPChance = Optional.fromNullable(fpChance);
        return this.self;
    }

    public T comment(String comment) {
        this.comment = Optional.fromNullable(comment);
        return this.self;
    }

    public T compressionOptions(CompressionOptions compressionOptions) {
        this.compressionOptions = Optional.fromNullable(compressionOptions);
        return this.self;
    }

    public T compactionOptions(CompactionOptions compactionOptions) {
        this.compactionOptions = Optional.fromNullable(compactionOptions);
        return this.self;
    }

    public T dcLocalReadRepairChance(Double dcLocalReadRepairChance) {
        TableOptions.validateRateValue(dcLocalReadRepairChance, "DC local read repair chance");
        this.dcLocalReadRepairChance = Optional.fromNullable(dcLocalReadRepairChance);
        return this.self;
    }

    public T defaultTimeToLive(Integer defaultTimeToLive) {
        this.defaultTTL = Optional.fromNullable(defaultTimeToLive);
        return this.self;
    }

    public T gcGraceSeconds(Integer gcGraceSeconds) {
        this.gcGraceSeconds = Optional.fromNullable(gcGraceSeconds);
        return this.self;
    }

    public T indexInterval(Integer indexInterval) {
        this.indexInterval = Optional.fromNullable(indexInterval);
        return this.self;
    }

    public T minIndexInterval(Integer minIndexInterval) {
        this.minIndexInterval = Optional.fromNullable(minIndexInterval);
        return this.self;
    }

    public T maxIndexInterval(Integer maxIndexInterval) {
        this.maxIndexInterval = Optional.fromNullable(maxIndexInterval);
        return this.self;
    }

    public T memtableFlushPeriodInMillis(Integer memtableFlushPeriodInMillis) {
        this.memtableFlushPeriodInMillis = Optional.fromNullable(memtableFlushPeriodInMillis);
        return this.self;
    }

    public T populateIOCacheOnFlush(Boolean populateIOOnCacheFlush) {
        this.populateIOOnCacheFlush = Optional.fromNullable(populateIOOnCacheFlush);
        return this.self;
    }

    public T readRepairChance(Double readRepairChance) {
        TableOptions.validateRateValue(readRepairChance, "Read repair chance");
        this.readRepairChance = Optional.fromNullable(readRepairChance);
        return this.self;
    }

    public T replicateOnWrite(Boolean replicateOnWrite) {
        this.replicateOnWrite = Optional.fromNullable(replicateOnWrite);
        return this.self;
    }

    public T speculativeRetry(SpeculativeRetryValue speculativeRetry) {
        this.speculativeRetry = Optional.fromNullable(speculativeRetry);
        return this.self;
    }

    public T cdc(Boolean cdc) {
        this.cdc = Optional.fromNullable(cdc);
        return this.self;
    }

    public T freeformOption(String key, Object value) {
        if (Strings.isNullOrEmpty(key)) {
            throw new IllegalArgumentException("Key for custom option should not be null or blank");
        }
        this.customOptions.add(TableOptions.buildCustomOption(key, value));
        return this.self;
    }

    private static String buildCustomOption(String key, Object value) {
        return String.format("%s = %s", key, value instanceof String ? "'" + value + "'" : value.toString());
    }

    private List<String> buildCommonOptions() {
        ArrayList<String> options = new ArrayList<String>();
        this.buildCachingOptions(options);
        if (this.bloomFilterFPChance.isPresent()) {
            options.add("bloom_filter_fp_chance = " + this.bloomFilterFPChance.get());
        }
        if (this.comment.isPresent()) {
            options.add("comment = '" + this.comment.get() + "'");
        }
        if (this.compressionOptions.isPresent()) {
            options.add("compression = " + this.compressionOptions.get().build());
        }
        if (this.compactionOptions.isPresent()) {
            options.add("compaction = " + this.compactionOptions.get().build());
        }
        if (this.dcLocalReadRepairChance.isPresent()) {
            options.add("dclocal_read_repair_chance = " + this.dcLocalReadRepairChance.get());
        }
        if (this.defaultTTL.isPresent()) {
            options.add("default_time_to_live = " + this.defaultTTL.get());
        }
        if (this.gcGraceSeconds.isPresent()) {
            options.add("gc_grace_seconds = " + this.gcGraceSeconds.get());
        }
        if (this.indexInterval.isPresent()) {
            options.add("index_interval = " + this.indexInterval.get());
        }
        if (this.minIndexInterval.isPresent()) {
            options.add("min_index_interval = " + this.minIndexInterval.get());
        }
        if (this.maxIndexInterval.isPresent()) {
            options.add("max_index_interval = " + this.maxIndexInterval.get());
        }
        if (this.memtableFlushPeriodInMillis.isPresent()) {
            options.add("memtable_flush_period_in_ms = " + this.memtableFlushPeriodInMillis.get());
        }
        if (this.populateIOOnCacheFlush.isPresent()) {
            options.add("populate_io_cache_on_flush = " + this.populateIOOnCacheFlush.get());
        }
        if (this.readRepairChance.isPresent()) {
            options.add("read_repair_chance = " + this.readRepairChance.get());
        }
        if (this.replicateOnWrite.isPresent()) {
            options.add("replicate_on_write = " + this.replicateOnWrite.get());
        }
        if (this.speculativeRetry.isPresent()) {
            options.add("speculative_retry = " + this.speculativeRetry.get().value());
        }
        if (this.cdc.isPresent()) {
            options.add("cdc = " + this.cdc.get());
        }
        options.addAll(this.customOptions);
        return options;
    }

    private void buildCachingOptions(List<String> options) {
        if (this.cassandra20Caching.isPresent() && this.cassandra21KeyCaching.isPresent()) {
            throw new IllegalStateException("Can't use Cassandra 2.0 and 2.1 caching at the same time, you must call only one version of caching()");
        }
        if (this.cassandra20Caching.isPresent()) {
            options.add("caching = " + this.cassandra20Caching.get().value());
        } else if (this.cassandra21KeyCaching.isPresent() && this.cassandra21RowCaching.isPresent()) {
            options.add(String.format("caching = {'keys' : %s, 'rows_per_partition' : %s}", this.cassandra21KeyCaching.get().value(), this.cassandra21RowCaching.get().value()));
        }
    }

    protected abstract void addSpecificOptions(List<String> var1);

    @Override
    public final String buildInternal() {
        List<String> options = this.buildCommonOptions();
        this.addSpecificOptions(options);
        return this.statementStart.buildInternal() + "\n\t" + "WITH " + Joiner.on(" AND ").join(options);
    }

    static void validateRateValue(Double rateValue, String property) {
        if (rateValue != null && (rateValue < 0.0 || rateValue > 1.0)) {
            throw new IllegalArgumentException(property + " should be between 0 and 1");
        }
    }

    public static class CachingRowsPerPartition {
        private String value;

        CachingRowsPerPartition(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static class SpeculativeRetryValue {
        private String value;

        SpeculativeRetryValue(String value) {
            this.value = value;
        }

        String value() {
            return this.value;
        }
    }

    public static class CompressionOptions {
        private Algorithm algorithm;
        private Optional<Integer> chunkLengthInKb = Optional.absent();
        private Optional<Double> crcCheckChance = Optional.absent();

        CompressionOptions(Algorithm algorithm) {
            this.algorithm = algorithm;
        }

        public CompressionOptions withChunkLengthInKb(Integer chunkLengthInKb) {
            this.chunkLengthInKb = Optional.fromNullable(chunkLengthInKb);
            return this;
        }

        public CompressionOptions withCRCCheckChance(Double crcCheckChance) {
            TableOptions.validateRateValue(crcCheckChance, "CRC check chance");
            this.crcCheckChance = Optional.fromNullable(crcCheckChance);
            return this;
        }

        public String build() {
            ArrayList<String> options = new ArrayList<String>();
            options.add("'sstable_compression' : " + this.algorithm.value());
            if (this.chunkLengthInKb.isPresent()) {
                options.add("'chunk_length_kb' : " + this.chunkLengthInKb.get());
            }
            if (this.crcCheckChance.isPresent()) {
                options.add("'crc_check_chance' : " + this.crcCheckChance.get());
            }
            return "{" + Joiner.on(", ").join(options) + "}";
        }

        public static class NoCompression
        extends CompressionOptions {
            public NoCompression() {
                super(Algorithm.NONE);
            }

            @Override
            public CompressionOptions withChunkLengthInKb(Integer chunkLengthInKb) {
                return this;
            }

            @Override
            public CompressionOptions withCRCCheckChance(Double crcCheckChance) {
                return this;
            }
        }

        public static enum Algorithm {
            NONE("''"),
            LZ4("'LZ4Compressor'"),
            SNAPPY("'SnappyCompressor'"),
            DEFLATE("'DeflateCompressor'");

            private String value;

            private Algorithm(String value) {
                this.value = value;
            }

            public String value() {
                return this.value;
            }

            public String toString() {
                return this.value;
            }
        }
    }

    public static abstract class CompactionOptions<T extends CompactionOptions> {
        private Strategy strategy;
        private Optional<Boolean> enabled = Optional.absent();
        private Optional<Integer> tombstoneCompactionIntervalInDay = Optional.absent();
        private Optional<Double> tombstoneThreshold = Optional.absent();
        private Optional<Boolean> uncheckedTombstoneCompaction = Optional.absent();
        private List<String> customOptions = new ArrayList<String>();
        private final T self = this;

        CompactionOptions(Strategy compactionStrategy) {
            this.strategy = compactionStrategy;
        }

        public T enabled(Boolean enabled) {
            this.enabled = Optional.fromNullable(enabled);
            return this.self;
        }

        public T tombstoneCompactionIntervalInDay(Integer tombstoneCompactionInterval) {
            this.tombstoneCompactionIntervalInDay = Optional.fromNullable(tombstoneCompactionInterval);
            return this.self;
        }

        public T tombstoneThreshold(Double tombstoneThreshold) {
            TableOptions.validateRateValue(tombstoneThreshold, "Tombstone threshold");
            this.tombstoneThreshold = Optional.fromNullable(tombstoneThreshold);
            return this.self;
        }

        public T uncheckedTombstoneCompaction(Boolean uncheckedTombstoneCompaction) {
            this.uncheckedTombstoneCompaction = Optional.fromNullable(uncheckedTombstoneCompaction);
            return this.self;
        }

        public T freeformOption(String key, Object value) {
            if (Strings.isNullOrEmpty(key)) {
                throw new IllegalArgumentException("Key for custom option should not be null or blank");
            }
            this.customOptions.add(CompactionOptions.buildCustomOption(key, value));
            return this.self;
        }

        private static String buildCustomOption(String key, Object value) {
            return String.format("'%s' : %s", key, value instanceof CharSequence ? "'" + value + "'" : value.toString());
        }

        List<String> buildCommonOptions() {
            ArrayList<String> options = new ArrayList<String>();
            options.add("'class' : " + this.strategy.strategyClass());
            if (this.enabled.isPresent()) {
                options.add("'enabled' : " + this.enabled.get());
            }
            if (this.tombstoneCompactionIntervalInDay.isPresent()) {
                options.add("'tombstone_compaction_interval' : " + this.tombstoneCompactionIntervalInDay.get());
            }
            if (this.tombstoneThreshold.isPresent()) {
                options.add("'tombstone_threshold' : " + this.tombstoneThreshold.get());
            }
            if (this.uncheckedTombstoneCompaction.isPresent()) {
                options.add("'unchecked_tombstone_compaction' : " + this.uncheckedTombstoneCompaction.get());
            }
            options.addAll(this.customOptions);
            return options;
        }

        public abstract String build();

        public static enum Strategy {
            SIZED_TIERED("'SizeTieredCompactionStrategy'"),
            LEVELED("'LeveledCompactionStrategy'"),
            DATE_TIERED("'DateTieredCompactionStrategy'");

            private String strategyClass;

            private Strategy(String strategyClass) {
                this.strategyClass = strategyClass;
            }

            public String strategyClass() {
                return this.strategyClass;
            }

            public String toString() {
                return this.strategyClass;
            }
        }

        public static class DateTieredCompactionStrategyOptions
        extends CompactionOptions<DateTieredCompactionStrategyOptions> {
            private Optional<Integer> baseTimeSeconds = Optional.absent();
            private Optional<Integer> maxSSTableAgeDays = Optional.absent();
            private Optional<Integer> minThreshold = Optional.absent();
            private Optional<Integer> maxThreshold = Optional.absent();
            private Optional<TimeStampResolution> timestampResolution = Optional.absent();

            DateTieredCompactionStrategyOptions() {
                super(Strategy.DATE_TIERED);
            }

            public DateTieredCompactionStrategyOptions baseTimeSeconds(Integer baseTimeSeconds) {
                this.baseTimeSeconds = Optional.fromNullable(baseTimeSeconds);
                return this;
            }

            public DateTieredCompactionStrategyOptions maxSSTableAgeDays(Integer maxSSTableAgeDays) {
                this.maxSSTableAgeDays = Optional.fromNullable(maxSSTableAgeDays);
                return this;
            }

            public DateTieredCompactionStrategyOptions minThreshold(Integer minThreshold) {
                this.minThreshold = Optional.fromNullable(minThreshold);
                return this;
            }

            public DateTieredCompactionStrategyOptions maxThreshold(Integer maxThreshold) {
                this.maxThreshold = Optional.fromNullable(maxThreshold);
                return this;
            }

            public DateTieredCompactionStrategyOptions timestampResolution(TimeStampResolution timestampResolution) {
                this.timestampResolution = Optional.fromNullable(timestampResolution);
                return this;
            }

            @Override
            public String build() {
                List<String> generalOptions = super.buildCommonOptions();
                ArrayList<String> options = new ArrayList<String>(generalOptions);
                if (this.baseTimeSeconds.isPresent()) {
                    options.add("'base_time_seconds' : " + this.baseTimeSeconds.get());
                }
                if (this.maxSSTableAgeDays.isPresent()) {
                    options.add("'max_sstable_age_days' : " + this.maxSSTableAgeDays.get());
                }
                if (this.minThreshold.isPresent()) {
                    options.add("'min_threshold' : " + this.minThreshold.get());
                }
                if (this.maxThreshold.isPresent()) {
                    options.add("'max_threshold' : " + this.maxThreshold.get());
                }
                if (this.timestampResolution.isPresent()) {
                    options.add("'timestamp_resolution' : '" + (Object)((Object)this.timestampResolution.get()) + "'");
                }
                return "{" + Joiner.on(", ").join(options) + "}";
            }

            public static enum TimeStampResolution {
                MICROSECONDS,
                MILLISECONDS;

            }
        }

        public static class LeveledCompactionStrategyOptions
        extends CompactionOptions<LeveledCompactionStrategyOptions> {
            private Optional<Integer> ssTableSizeInMB = Optional.absent();

            LeveledCompactionStrategyOptions() {
                super(Strategy.LEVELED);
            }

            public LeveledCompactionStrategyOptions ssTableSizeInMB(Integer ssTableSizeInMB) {
                this.ssTableSizeInMB = Optional.fromNullable(ssTableSizeInMB);
                return this;
            }

            @Override
            public String build() {
                List<String> generalOptions = super.buildCommonOptions();
                ArrayList<String> options = new ArrayList<String>(generalOptions);
                if (this.ssTableSizeInMB.isPresent()) {
                    options.add("'sstable_size_in_mb' : " + this.ssTableSizeInMB.get());
                }
                return "{" + Joiner.on(", ").join(options) + "}";
            }
        }

        public static class SizeTieredCompactionStrategyOptions
        extends CompactionOptions<SizeTieredCompactionStrategyOptions> {
            private Optional<Double> bucketHigh = Optional.absent();
            private Optional<Double> bucketLow = Optional.absent();
            private Optional<Double> coldReadsRatioToOmit = Optional.absent();
            private Optional<Integer> minThreshold = Optional.absent();
            private Optional<Integer> maxThreshold = Optional.absent();
            private Optional<Long> minSSTableSizeInBytes = Optional.absent();

            SizeTieredCompactionStrategyOptions() {
                super(Strategy.SIZED_TIERED);
            }

            public SizeTieredCompactionStrategyOptions bucketHigh(Double bucketHigh) {
                this.bucketHigh = Optional.fromNullable(bucketHigh);
                return this;
            }

            public SizeTieredCompactionStrategyOptions bucketLow(Double bucketLow) {
                this.bucketLow = Optional.fromNullable(bucketLow);
                return this;
            }

            public SizeTieredCompactionStrategyOptions coldReadsRatioToOmit(Double coldReadsRatio) {
                TableOptions.validateRateValue(coldReadsRatio, "Cold read ratio to omit ");
                this.coldReadsRatioToOmit = Optional.fromNullable(coldReadsRatio);
                return this;
            }

            public SizeTieredCompactionStrategyOptions minThreshold(Integer minThreshold) {
                this.minThreshold = Optional.fromNullable(minThreshold);
                return this;
            }

            public SizeTieredCompactionStrategyOptions maxThreshold(Integer maxThreshold) {
                this.maxThreshold = Optional.fromNullable(maxThreshold);
                return this;
            }

            public SizeTieredCompactionStrategyOptions minSSTableSizeInBytes(Long minSSTableSize) {
                this.minSSTableSizeInBytes = Optional.fromNullable(minSSTableSize);
                return this;
            }

            @Override
            public String build() {
                List<String> generalOptions = super.buildCommonOptions();
                ArrayList<String> options = new ArrayList<String>(generalOptions);
                if (this.bucketHigh.isPresent()) {
                    options.add("'bucket_high' : " + this.bucketHigh.get());
                }
                if (this.bucketLow.isPresent()) {
                    options.add("'bucket_low' : " + this.bucketLow.get());
                }
                if (this.coldReadsRatioToOmit.isPresent()) {
                    options.add("'cold_reads_to_omit' : " + this.coldReadsRatioToOmit.get());
                }
                if (this.minThreshold.isPresent()) {
                    options.add("'min_threshold' : " + this.minThreshold.get());
                }
                if (this.maxThreshold.isPresent()) {
                    options.add("'max_threshold' : " + this.maxThreshold.get());
                }
                if (this.minSSTableSizeInBytes.isPresent()) {
                    options.add("'min_sstable_size' : " + this.minSSTableSizeInBytes.get());
                }
                return "{" + Joiner.on(", ").join(options) + "}";
            }
        }
    }
}

