/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.schema;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class TokenReplacingReader
extends Reader {
    private PushbackReader pushbackReader = null;
    private Map<String, String> tokens = null;
    private StringBuilder tokenNameBuffer = new StringBuilder();
    private String tokenValue = null;
    private int tokenValueIndex = 0;
    private boolean escaping = false;
    private Deque<String> activeTokens;
    private Map<String, String> resolvedTokens;

    public TokenReplacingReader(String source, Map<String, String> tokens) {
        this.pushbackReader = new PushbackReader(new StringReader(source), 2);
        this.tokens = tokens;
        this.activeTokens = new ArrayDeque<String>();
        this.resolvedTokens = new HashMap<String, String>();
    }

    public TokenReplacingReader(String source, Map<String, String> tokens, Deque<String> activeTokens, Map<String, String> resolvedTokens) {
        this.pushbackReader = new PushbackReader(new StringReader(source));
        this.tokens = tokens;
        this.activeTokens = activeTokens;
        this.resolvedTokens = resolvedTokens;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        throw new RuntimeException("Operation Not Supported");
    }

    @Override
    public int read() throws IOException {
        String tokenName;
        if (this.tokenValue != null) {
            if (this.tokenValueIndex < this.tokenValue.length()) {
                return this.tokenValue.charAt(this.tokenValueIndex++);
            }
            if (this.tokenValueIndex == this.tokenValue.length()) {
                this.tokenValue = null;
                this.tokenValueIndex = 0;
            }
        }
        int data = this.pushbackReader.read();
        if (this.escaping) {
            this.escaping = false;
            return data;
        }
        if (data == 92) {
            data = this.pushbackReader.read();
            if (data != 36) {
                this.pushbackReader.unread(data);
                return 92;
            }
            data = this.pushbackReader.read();
            this.pushbackReader.unread(data);
            if (data != 123) {
                this.pushbackReader.unread(36);
                return 92;
            }
            this.escaping = true;
            return 36;
        }
        if (data != 36) {
            return data;
        }
        data = this.pushbackReader.read();
        if (data != 123) {
            this.pushbackReader.unread(data);
            return 36;
        }
        this.tokenNameBuffer.delete(0, this.tokenNameBuffer.length());
        boolean skipUntilExpressionEnd = false;
        boolean nameIsValue = false;
        boolean cont = true;
        int state = 0;
        block13: while (cont) {
            data = this.pushbackReader.read();
            block0 : switch (state) {
                case 0: {
                    switch (data) {
                        case 44: {
                            if (skipUntilExpressionEnd) break;
                            tokenName = this.tokenNameBuffer.toString();
                            if (this.tokens.containsKey(tokenName)) {
                                skipUntilExpressionEnd = true;
                                break;
                            }
                            this.tokenNameBuffer.delete(0, this.tokenNameBuffer.length());
                            break;
                        }
                        case 58: {
                            if (skipUntilExpressionEnd) {
                                state = 1;
                                break;
                            }
                            if (this.tokenNameBuffer.length() == 0) {
                                this.tokenNameBuffer.append((char)data);
                                break;
                            }
                            state = 1;
                            tokenName = this.tokenNameBuffer.toString();
                            if (this.tokens.containsKey(tokenName)) {
                                skipUntilExpressionEnd = true;
                                break;
                            }
                            this.tokenNameBuffer.delete(0, this.tokenNameBuffer.length());
                            nameIsValue = true;
                            break;
                        }
                        case 125: {
                            cont = false;
                            break;
                        }
                        default: {
                            this.tokenNameBuffer.append((char)data);
                            break;
                        }
                    }
                    continue block13;
                }
                case 1: {
                    switch (data) {
                        case 92: {
                            data = this.pushbackReader.read();
                            if (data != 125) {
                                this.pushbackReader.unread(data);
                                data = 92;
                            }
                            if (!nameIsValue) break block0;
                            this.tokenNameBuffer.append((char)data);
                            break block0;
                        }
                        case 125: {
                            cont = false;
                            break block0;
                        }
                    }
                    if (!nameIsValue) break;
                    this.tokenNameBuffer.append((char)data);
                }
            }
        }
        tokenName = this.tokenNameBuffer.toString();
        if (nameIsValue) {
            TokenReplacingReader childReader = new TokenReplacingReader(tokenName, this.tokens, this.activeTokens, this.resolvedTokens);
            this.tokenValue = this.readAll(childReader);
        } else {
            this.tokenValue = this.resolveToken(tokenName);
        }
        this.tokenValueIndex = 0;
        if (!this.tokenValue.isEmpty()) {
            return this.tokenValue.charAt(this.tokenValueIndex++);
        }
        return this.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int i;
        for (i = 0; i < len; ++i) {
            int nextChar = this.read();
            if (nextChar == -1) {
                if (i != 0) break;
                i = -1;
                break;
            }
            cbuf[off + i] = (char)nextChar;
        }
        return i;
    }

    @Override
    public void close() throws IOException {
        this.pushbackReader.close();
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException("skip() not supported on TokenReplacingReader.");
    }

    @Override
    public boolean ready() throws IOException {
        return this.pushbackReader.ready();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark() not supported on TokenReplacingReader.");
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset() not supported on TokenReplacingReader.");
    }

    private String readAll(Reader r) throws IOException {
        int c;
        StringBuilder bld = new StringBuilder();
        while ((c = r.read()) >= 0) {
            bld.append((char)c);
        }
        return bld.toString();
    }

    private String resolveToken(String tokenName) throws IOException {
        if (this.resolvedTokens.containsKey(tokenName)) {
            return this.resolvedTokens.get(tokenName);
        }
        if (this.activeTokens.contains(tokenName)) {
            throw new IllegalArgumentException("Token '" + tokenName + "' (indirectly) contains reference to itself in its value.");
        }
        this.activeTokens.push(tokenName);
        String tokenValue = this.tokens.get(tokenName);
        if (tokenValue != null) {
            if (tokenValue.contains("${")) {
                TokenReplacingReader childReader = new TokenReplacingReader(tokenValue, this.tokens, this.activeTokens, this.resolvedTokens);
                tokenValue = this.readAll(childReader);
            }
        } else {
            tokenValue = "${" + tokenName + "}";
        }
        this.resolvedTokens.put(tokenName, tokenValue);
        this.activeTokens.pop();
        return tokenValue;
    }
}

