/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.schema;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaManager {
    private static final Logger logger = LoggerFactory.getLogger(SchemaManager.class);
    private final Session session;

    public SchemaManager(Session session) {
        this.session = session;
    }

    public void dropKeyspace(String keyspace) {
        logger.info("Dropping keyspace " + keyspace);
        this.session.execute("DROP KEYSPACE IF EXISTS " + keyspace);
    }

    public void createSchema(String keyspace) {
        logger.info("Creating schema for keyspace " + keyspace);
        ResultSet resultSet = this.session.execute("SELECT * FROM system.schema_keyspaces WHERE keyspace_name = '" + keyspace + "'");
        if (!resultSet.isExhausted()) {
            logger.info("Schema already exist. Skipping schema creation.");
            return;
        }
        ImmutableMap schemaVars = ImmutableMap.of((Object)"keyspace", (Object)keyspace);
        try (InputStream inputStream = this.getClass().getResourceAsStream("/schema.cql");
             InputStreamReader reader = new InputStreamReader(inputStream);){
            String content = CharStreams.toString((Readable)reader);
            for (String cql : content.split("(?m)^-- #.*$")) {
                if (cql.startsWith("--")) continue;
                String updatedCQL = this.substituteVars(cql.trim(), (Map<String, String>)schemaVars);
                logger.debug("Executing CQL:\n" + updatedCQL + "\n");
                this.session.execute(updatedCQL);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Schema creation failed", e);
        }
    }

    /*
     * Exception decompiling
     */
    private String substituteVars(String cql, Map<String, String> vars) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

