/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.internal.OrderList;
import com.thinkaurelius.titan.graphdb.internal.RelationCategory;
import com.thinkaurelius.titan.graphdb.query.BackendQueryHolder;
import com.thinkaurelius.titan.graphdb.query.condition.PredicateCondition;
import com.thinkaurelius.titan.graphdb.query.vertex.BaseVertexCentricQuery;
import com.thinkaurelius.titan.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.hadoop.FaunusRelation;
import com.thinkaurelius.titan.hadoop.FaunusSchemaManager;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.FaunusVertexQuery;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import java.util.Iterator;

public class FaunusVertexQueryFilter
extends FaunusVertexQuery
implements Iterable<FaunusRelation> {
    private RelationCategory resultType;
    private static final GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine();
    private boolean doesFilter = false;

    public FaunusVertexQueryFilter(FaunusSchemaManager typeManager) {
        super(typeManager);
    }

    private void setDoesFilter(boolean doesFilter) {
        this.doesFilter = doesFilter;
    }

    public boolean doesFilter() {
        return this.doesFilter;
    }

    public static FaunusVertexQueryFilter create(Configuration configuration) {
        engine.put("v", (Object)new DummyVertex(FaunusSchemaManager.getTypeManager(configuration)));
        try {
            FaunusVertexQueryFilter query = (FaunusVertexQueryFilter)engine.eval((String)configuration.get(TitanHadoopConfiguration.INPUT_VERTEX_QUERY_FILTER, new String[0]));
            if (configuration.has(TitanHadoopConfiguration.INPUT_VERTEX_QUERY_FILTER, new String[0])) {
                query.setDoesFilter(true);
            }
            query.relations();
            return query;
        }
        catch (Exception e) {
            throw new RuntimeException("VertexQueryFilter compilation error: " + e.getMessage(), e);
        }
    }

    @Override
    public Iterator<FaunusRelation> iterator() {
        throw new UnsupportedOperationException("This filter can only be used for query construction, not execution.");
    }

    public void filterRelationsOf(FaunusVertex vertex) {
        Preconditions.checkArgument((this.resultType != null ? 1 : 0) != 0, (Object)"Query filter has not been initialized correctly");
        if (!this.doesFilter) {
            return;
        }
        for (Direction dir : Direction.proper) {
            Iterator iter = vertex.getAdjacency(dir).values().iterator();
            Predicate<FaunusRelation> filter = this.getFilter(vertex, this.resultType);
            while (iter.hasNext()) {
                if (filter.apply(iter.next())) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SliceQuery determineQueryBounds(TitanGraph graph) {
        Preconditions.checkArgument((this.resultType != null ? 1 : 0) != 0, (Object)"Query filter has not been initialized correctly");
        TitanTransaction tx = graph.newTransaction();
        try {
            QueryBounds qb = new SlicePredicateQueryBuilder((StandardTitanTx)tx, this).getQueryBounds(this.resultType);
            if (qb.isFitted) {
                this.setDoesFilter(false);
            }
            SliceQuery sliceQuery = qb.query;
            return sliceQuery;
        }
        finally {
            tx.rollback();
        }
    }

    @Override
    public TitanVertex getVertex(long vid) {
        throw new UnsupportedOperationException("Adjacency constraints are not supported by filter");
    }

    @Override
    public FaunusVertexQuery adjacent(TitanVertex vertex) {
        throw new UnsupportedOperationException("Adjacency constraints are not supported by filter");
    }

    @Override
    protected Iterable<FaunusRelation> getRelations(RelationCategory returnType) {
        this.resultType = returnType;
        return this;
    }

    @Override
    public long count() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long propertyCount() {
        throw new UnsupportedOperationException();
    }

    private static class SlicePredicateQueryBuilder
    extends BasicVertexCentricQueryBuilder<SlicePredicateQueryBuilder> {
        public SlicePredicateQueryBuilder(StandardTitanTx tx, FaunusVertexQueryFilter query) {
            super(tx);
            this.direction(query.dir);
            this.types(query.types);
            this.limit(query.limit);
            for (PredicateCondition constraint : query.constraints) {
                this.has((String)constraint.getKey(), (com.tinkerpop.blueprints.Predicate)constraint.getPredicate(), constraint.getValue());
            }
            if (!query.orders.isEmpty()) {
                for (OrderList.OrderEntry entry : query.orders) {
                    this.orderBy(entry.getKey().getName(), entry.getOrder());
                }
            }
            assert (query.adjacentVertex == null);
        }

        protected SlicePredicateQueryBuilder getThis() {
            return this;
        }

        public QueryBounds getQueryBounds(RelationCategory resultType) {
            SliceQuery result;
            BaseVertexCentricQuery q = this.constructQuery(resultType);
            boolean isFitted = false;
            if (q.numSubQueries() == 0) {
                throw new IllegalArgumentException("Query filter is invalid - does not match anything");
            }
            if (q.numSubQueries() == 1) {
                BackendQueryHolder bqh = q.getSubQuery(0);
                result = ((SliceQuery)bqh.getBackendQuery()).updateLimit(bqh.isSorted() ? this.limit : Integer.MAX_VALUE);
                isFitted = bqh.isFitted() && bqh.isSorted();
            } else {
                StaticBuffer start = null;
                StaticBuffer end = null;
                for (int i = 0; i < q.numSubQueries(); ++i) {
                    SliceQuery sq = (SliceQuery)q.getSubQuery(i).getBackendQuery();
                    if (start == null || start.compareTo((Object)sq.getSliceStart()) > 0) {
                        start = sq.getSliceStart();
                    }
                    if (end != null && end.compareTo((Object)sq.getSliceEnd()) >= 0) continue;
                    end = sq.getSliceEnd();
                }
                assert (start != null && end != null && start.compareTo(end) <= 0);
                result = new SliceQuery(start, end).setLimit(Integer.MAX_VALUE);
            }
            return new QueryBounds(result, isFitted);
        }
    }

    public static class QueryBounds {
        public final SliceQuery query;
        public final boolean isFitted;

        private QueryBounds(SliceQuery query, boolean fitted) {
            this.query = query;
            this.isFitted = fitted;
        }
    }

    private static class DummyVertex {
        private final FaunusSchemaManager manager;

        private DummyVertex(FaunusSchemaManager manager) {
            this.manager = manager;
        }

        public FaunusVertexQueryFilter query() {
            return new FaunusVertexQueryFilter(this.manager);
        }
    }
}

