/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats;

import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.Holder;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeCopyMapReduce {
    public static org.apache.hadoop.conf.Configuration createConfiguration(Direction direction) {
        org.apache.hadoop.conf.Configuration c = new org.apache.hadoop.conf.Configuration(false);
        c.set(ConfigElement.getPath(TitanHadoopConfiguration.INPUT_EDGE_COPY_DIRECTION, (String[])new String[0]), direction.name());
        return c;
    }

    public static class Reduce
    extends Reducer<LongWritable, Holder<FaunusVertex>, NullWritable, FaunusVertex> {
        private Direction direction = Direction.OUT;
        private ModifiableHadoopConfiguration faunusConf;
        private static final Logger log = LoggerFactory.getLogger(Reduce.class);

        public void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.faunusConf = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context));
            this.direction = this.faunusConf.getEdgeCopyDirection();
            if (this.direction.equals((Object)Direction.BOTH)) {
                throw new InterruptedException(ExceptionFactory.bothIsNotSupported().getMessage());
            }
        }

        public void reduce(LongWritable key, Iterable<Holder<FaunusVertex>> values, Reducer.Context context) throws IOException, InterruptedException {
            long edgesAggregated = 0L;
            FaunusVertex vertex = new FaunusVertex((Configuration)this.faunusConf, key.get());
            for (Holder<FaunusVertex> holder : values) {
                if (holder.getTag() == 's') {
                    edgesAggregated += (long)Iterables.size(holder.get().getEdges(this.direction.opposite(), new String[0]));
                    vertex.addEdges(this.direction.opposite(), holder.get());
                    continue;
                }
                vertex.addAll(holder.get());
            }
            context.write((Object)NullWritable.get(), (Object)vertex);
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.EDGES_ADDED, edgesAggregated);
        }
    }

    public static class Map
    extends Mapper<NullWritable, FaunusVertex, LongWritable, Holder<FaunusVertex>> {
        private final Holder<FaunusVertex> vertexHolder = new Holder();
        private final LongWritable longWritable = new LongWritable();
        private Direction direction = Direction.OUT;
        private ModifiableHadoopConfiguration faunusConf;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.faunusConf = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context));
            this.direction = this.faunusConf.getEdgeCopyDirection();
            if (this.direction.equals((Object)Direction.BOTH)) {
                throw new InterruptedException(ExceptionFactory.bothIsNotSupported().getMessage());
            }
        }

        public void map(NullWritable key, FaunusVertex value, Mapper.Context context) throws IOException, InterruptedException {
            long edgesInverted = 0L;
            for (Edge edge : value.getEdges(this.direction, new String[0])) {
                long id = (Long)edge.getVertex(this.direction.opposite()).getId();
                FaunusVertex shellVertex = new FaunusVertex((Configuration)this.faunusConf, id);
                this.longWritable.set(id);
                shellVertex.addEdge(this.direction.opposite(), (StandardFaunusEdge)edge);
                context.write((Object)this.longWritable, this.vertexHolder.set('s', shellVertex));
                ++edgesInverted;
            }
            this.longWritable.set(value.getLongId());
            context.write((Object)this.longWritable, this.vertexHolder.set('r', value));
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.EDGES_COPIED, edgesInverted);
        }
    }

    public static enum Counters {
        EDGES_COPIED,
        EDGES_ADDED;

    }
}

