/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats;

import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.VertexQuery;
import com.tinkerpop.blueprints.util.DefaultQuery;
import com.tinkerpop.blueprints.util.DefaultVertexQuery;
import com.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import java.util.Iterator;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;

public class VertexQueryFilter
extends DefaultVertexQuery {
    private static final GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine();
    private static final String V = "v";
    private static final DummyVertex DUMMY_VERTEX = new DummyVertex();
    private boolean doesFilter = false;

    protected VertexQueryFilter() {
        super((Vertex)DUMMY_VERTEX);
    }

    public static VertexQueryFilter create(Configuration configuration) {
        ModifiableHadoopConfiguration faunusConf = ModifiableHadoopConfiguration.of(configuration);
        engine.put(V, (Object)DUMMY_VERTEX);
        try {
            VertexQueryFilter query = (VertexQueryFilter)((Object)engine.eval(faunusConf.get(TitanHadoopConfiguration.INPUT_VERTEX_QUERY_FILTER, new String[0])));
            if (faunusConf.has(TitanHadoopConfiguration.INPUT_VERTEX_QUERY_FILTER, new String[0])) {
                query.setDoesFilter(true);
            }
            return query;
        }
        catch (Exception e) {
            throw new RuntimeException("VertexQueryFilter compilation error: " + e.getMessage(), e);
        }
    }

    protected void setDoesFilter(boolean doesFilter) {
        this.doesFilter = doesFilter;
    }

    public boolean doesFilter() {
        return this.doesFilter;
    }

    public Iterable<Edge> edges() {
        throw new UnsupportedOperationException("This VertexQuery is used for graph filtering, not edge iteration");
    }

    public Iterable<Vertex> vertices() {
        throw new UnsupportedOperationException("This VertexQuery is used for graph filtering, not vertex iteration");
    }

    public Object vertexIds() {
        throw new UnsupportedOperationException("This VertexQuery is used for graph filtering, not id aggregation");
    }

    public long count() {
        throw new UnsupportedOperationException("This VertexQuery is used for graph filtering, not element counting");
    }

    public void defaultFilter(FaunusVertex vertex) {
        Iterator<Edge> itty;
        if (!this.doesFilter) {
            return;
        }
        vertex.removeEdges(Tokens.Action.KEEP, this.direction, this.labels);
        if (this.hasContainers.size() > 0) {
            itty = vertex.getEdges(this.direction, new String[0]).iterator();
            while (itty.hasNext()) {
                Edge edge = itty.next();
                for (DefaultQuery.HasContainer hasContainer : this.hasContainers) {
                    if (hasContainer.isLegal((Element)edge)) continue;
                    itty.remove();
                }
            }
        }
        if ((long)this.limit != Long.MAX_VALUE) {
            itty = vertex.getEdges(this.direction, new String[0]).iterator();
            long counter = 0L;
            while (itty.hasNext()) {
                itty.next();
                if (++counter <= (long)this.limit) continue;
                itty.remove();
            }
        }
    }

    protected static class DummyVertex
    implements Vertex {
        protected DummyVertex() {
        }

        public VertexQuery query() {
            return new VertexQueryFilter();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Edge addEdge(String label, Vertex inVertex) {
            throw new UnsupportedOperationException();
        }

        public Iterable<Edge> getEdges(Direction direction, String ... labels) {
            throw new UnsupportedOperationException();
        }

        public Iterable<Vertex> getVertices(Direction direction, String ... labels) {
            throw new UnsupportedOperationException();
        }

        public Set<String> getPropertyKeys() {
            throw new UnsupportedOperationException();
        }

        public <T> T getProperty(String key) {
            throw new UnsupportedOperationException();
        }

        public void setProperty(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        public <T> T removeProperty(String key) {
            throw new UnsupportedOperationException();
        }

        public Object getId() {
            throw new UnsupportedOperationException();
        }
    }
}

