/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.util;

import com.google.common.collect.ImmutableMap;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.formats.util.LoaderScriptWrapper;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoaderScriptChecker {
    private static final Logger log = LoggerFactory.getLogger(LoaderScriptChecker.class);

    public static void main(String[] args) throws IOException {
        ModifiableHadoopConfiguration faunusConf;
        if (null == args || 1 != args.length) {
            log.error("Usage: {} <titan-hadoop-config-file>", (Object)LoaderScriptChecker.class.getSimpleName());
            System.exit(2);
        }
        if (!(faunusConf = LoaderScriptChecker.getConf(args[0])).has(TitanHadoopConfiguration.OUTPUT_LOADER_SCRIPT_FILE, new String[0])) {
            log.error("No value defined to for {} in {}", (Object)ConfigElement.getPath(TitanHadoopConfiguration.OUTPUT_LOADER_SCRIPT_FILE, (String[])new String[0]), (Object)args[0]);
            System.exit(2);
        }
        String s = faunusConf.get(TitanHadoopConfiguration.OUTPUT_LOADER_SCRIPT_FILE, new String[0]);
        FileSystem fs = FileSystem.get((Configuration)faunusConf.getHadoopConfiguration());
        log.info("Attempting to load {} from filesystem {}", (Object)s, (Object)fs);
        LoaderScriptWrapper script = new LoaderScriptWrapper(fs, new Path(s));
        log.info("Summary of methods loaded from {}:", (Object)s);
        ImmutableMap methods = ImmutableMap.of((Object)"getOrCreateEdge", (Object)script.hasEdgeMethod(), (Object)"getOrCreateVertex", (Object)script.hasVertexMethod(), (Object)"getOrCreateVertexProperty", (Object)script.hasVPropMethod());
        int ok = 0;
        for (Map.Entry m : methods.entrySet()) {
            if (((Boolean)m.getValue()).booleanValue()) {
                log.info("Successfully compiled method:       {}", m.getKey());
                ++ok;
                continue;
            }
            log.info("Unable to compile or locate method: {}", m.getKey());
        }
        log.info("Detected and compiled {} total method(s) from {}", (Object)ok, (Object)s);
        System.exit(0 < ok ? 0 : 1);
    }

    private static ModifiableHadoopConfiguration getConf(String path) throws IOException {
        Properties properties = new Properties();
        Configuration configuration = new Configuration();
        properties.load(new FileInputStream(path));
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            configuration.set(entry.getKey().toString(), entry.getValue().toString());
        }
        return ModifiableHadoopConfiguration.of(configuration);
    }
}

