/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.util;

import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.schema.DefaultSchemaMaker;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.graphdb.blueprints.BlueprintsDefaultSchemaMaker;
import com.thinkaurelius.titan.graphdb.types.system.BaseVertexLabel;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.FaunusVertexLabel;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.formats.util.TitanGraphOutputMapReduce;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaInferencerMapReduce {
    private static final long funnyLong = Long.MAX_VALUE;
    private static final LongWritable funnyKey = new LongWritable(Long.MAX_VALUE);
    private static final Logger log = LoggerFactory.getLogger(SchemaInferencerMapReduce.class);

    public static class Reduce
    extends Reducer<LongWritable, FaunusVertex, NullWritable, FaunusVertex> {
        private TitanGraph graph;
        private ModifiableHadoopConfiguration faunusConf;
        private TitanTransaction tx;

        public void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.faunusConf = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context));
            this.graph = TitanGraphOutputMapReduce.generateGraph(this.faunusConf);
            this.tx = this.graph.buildTransaction().disableBatchLoading().start();
            log.debug("Dumping configuration");
            for (Map.Entry ent : this.faunusConf.getHadoopConfiguration()) {
                log.debug("[SchemaInferencerMRConfig] {}={}", ent.getKey(), ent.getValue());
            }
            log.debug("Done dumping configuration");
            log.debug("Dumping credentials");
            for (Token token : context.getCredentials().getAllTokens()) {
                log.debug("[Credentials] kind={} ident={} token={}", new Object[]{token.getKind(), token.getIdentifier(), token});
            }
            log.debug("Done dumping credentials");
        }

        public void reduce(LongWritable key, Iterable<FaunusVertex> value, Reducer.Context context) throws IOException, InterruptedException {
            if (key.get() == Long.MAX_VALUE) {
                DefaultSchemaMaker typeMaker = BlueprintsDefaultSchemaMaker.INSTANCE;
                for (FaunusVertex vertex : value) {
                    for (String property : vertex.getPropertyKeys()) {
                        char type = property.charAt(0);
                        String typeName = property.substring(1);
                        if ((type == 'k' || type == 'l') && this.tx.getRelationType(typeName) != null || type == 'v' && this.tx.containsVertexLabel(typeName)) continue;
                        if (type == 'k') {
                            typeMaker.makePropertyKey(this.tx.makePropertyKey(typeName));
                            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.PROPERTY_KEYS_CREATED, 1L);
                            continue;
                        }
                        if (type == 'l') {
                            typeMaker.makeEdgeLabel(this.tx.makeEdgeLabel(typeName));
                            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.EDGE_LABELS_CREATED, 1L);
                            continue;
                        }
                        if (type == 'v') {
                            typeMaker.makeVertexLabel(this.tx.makeVertexLabel(typeName));
                            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTEX_LABELS_CREATED, 1L);
                            continue;
                        }
                        throw new IllegalArgumentException("Unexpected type: " + type);
                    }
                }
            } else {
                for (FaunusVertex vertex : value) {
                    context.write((Object)NullWritable.get(), (Object)vertex);
                }
            }
        }

        public void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            this.tx.commit();
            this.graph.shutdown();
        }
    }

    public static class Map
    extends Mapper<NullWritable, FaunusVertex, LongWritable, FaunusVertex> {
        private FaunusVertex funnyVertex;
        private Configuration faunusConf;
        private final LongWritable longWritable = new LongWritable();

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.faunusConf = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context));
            this.funnyVertex = new FaunusVertex(this.faunusConf, Long.MAX_VALUE);
        }

        public void map(NullWritable key, FaunusVertex value, Mapper.Context context) throws IOException, InterruptedException {
            FaunusVertexLabel vl = value.getVertexLabel();
            if (vl != BaseVertexLabel.DEFAULT_VERTEXLABEL) {
                this.funnyVertex.setProperty("v" + vl.getName(), (Object)String.class.getName());
            }
            for (String property : value.getPropertyKeys()) {
                this.funnyVertex.setProperty("k" + property, (Object)Object.class.getName());
            }
            for (Edge edge : value.getEdges(Direction.OUT, new String[0])) {
                this.funnyVertex.setProperty("l" + edge.getLabel(), (Object)String.class.getName());
                for (String property : edge.getPropertyKeys()) {
                    this.funnyVertex.setProperty("k" + property, (Object)Object.class.getName());
                }
            }
            this.longWritable.set(value.getLongId());
            context.write((Object)this.longWritable, (Object)value);
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)funnyKey, (Object)this.funnyVertex);
        }
    }

    public static enum Counters {
        EDGE_LABELS_CREATED,
        VERTEX_LABELS_CREATED,
        PROPERTY_KEYS_CREATED;

    }
}

