/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.hdfs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.CompressionCodec;

public class TextFileLineIterator
implements Iterator<String> {
    private final FileSystem fs;
    private final Queue<Path> paths;
    private final long totalLines;
    private long lines = 0L;
    private BufferedReader reader = null;
    private String line;
    private CompressionCodec codec = new BZip2Codec();

    public TextFileLineIterator(FileSystem fs, Queue<Path> paths, long totalLines) throws IOException {
        this.fs = fs;
        this.totalLines = totalLines;
        this.paths = paths;
    }

    public TextFileLineIterator(FileSystem fs, FileStatus[] statuses, long totalLines) throws IOException {
        this.fs = fs;
        this.totalLines = totalLines;
        this.paths = new LinkedList<Path>();
        for (FileStatus status : statuses) {
            this.paths.add(status.getPath());
        }
    }

    @Override
    public boolean hasNext() {
        if (null != this.line) {
            return true;
        }
        if (this.lines >= this.totalLines) {
            return false;
        }
        try {
            if (this.reader == null) {
                if (this.paths.isEmpty()) {
                    return false;
                }
                this.reader = this.getUncompressedInputStream();
            }
            this.line = this.reader.readLine();
            if (this.line != null) {
                ++this.lines;
                return true;
            }
            this.reader.close();
            this.reader = this.paths.isEmpty() ? null : this.getUncompressedInputStream();
            return this.hasNext();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String next() {
        if (null != this.line) {
            String temp = this.line;
            this.line = null;
            return temp;
        }
        if (this.hasNext()) {
            return this.next();
        }
        throw new NoSuchElementException();
    }

    private BufferedReader getUncompressedInputStream() throws IOException {
        Path path = this.paths.remove();
        if (path.getName().endsWith("bz2")) {
            return new BufferedReader(new InputStreamReader((InputStream)this.codec.createInputStream((InputStream)this.fs.open(path))));
        }
        return new BufferedReader(new InputStreamReader((InputStream)this.fs.open(path)));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

