/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.HadoopGraph;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompiler;
import com.thinkaurelius.titan.hadoop.config.HybridConfigured;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.job.JobClasspathConfigurer;
import com.thinkaurelius.titan.hadoop.config.job.JobClasspathConfigurers;
import com.thinkaurelius.titan.hadoop.formats.FormatTools;
import com.thinkaurelius.titan.hadoop.formats.JobConfigurationFormat;
import com.thinkaurelius.titan.hadoop.hdfs.NoSideEffectFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.slf4j.Logger;

public abstract class AbstractHadoopCompiler
extends HybridConfigured
implements HadoopCompiler {
    protected final HadoopGraph graph;
    protected final List<Job> jobs;
    private static final Class<? extends InputFormat> INTERMEDIATE_INPUT_FORMAT = SequenceFileInputFormat.class;
    private static final Class<? extends OutputFormat> INTERMEDIATE_OUTPUT_FORMAT = SequenceFileOutputFormat.class;

    protected abstract Logger getLog();

    protected AbstractHadoopCompiler(HadoopGraph graph) {
        this.graph = graph;
        this.setConf(new Configuration(this.graph.getConf()));
        this.jobs = new ArrayList<Job>();
    }

    protected abstract String getMapReduceJarConfigKey();

    protected abstract String getDefaultMapReduceJar();

    @Override
    public void composeJobs() throws IOException {
        if (this.jobs.size() == 0) {
            return;
        }
        if (this.getTitanConf().get(TitanHadoopConfiguration.PIPELINE_TRACK_PATHS, new String[0]).booleanValue()) {
            this.getLog().warn("Path tracking is enabled for this Titan/Hadoop job (space and time expensive)");
        }
        if (this.getTitanConf().get(TitanHadoopConfiguration.PIPELINE_TRACK_STATE, new String[0]).booleanValue()) {
            this.getLog().warn("State tracking is enabled for this Titan/Hadoop job (full deletes not possible)");
        }
        String customConfigurer = this.getTitanConf().has(TitanHadoopConfiguration.CLASSPATH_CONFIGURER, new String[0]) ? this.getTitanConf().get(TitanHadoopConfiguration.CLASSPATH_CONFIGURER, new String[0]) : null;
        JobClasspathConfigurer cpConf = JobClasspathConfigurers.get(customConfigurer, this.graph.getConf().get(this.getMapReduceJarConfigKey()), this.getDefaultMapReduceJar());
        Path tmpPath = this.graph.getJobDir();
        FileSystem fs = FileSystem.get((Configuration)this.graph.getConf());
        fs.mkdirs(tmpPath);
        this.getLog().debug("Created " + tmpPath + " on filesystem " + fs);
        String jobPathPrefix = tmpPath.toString() + "/" + "job";
        this.getLog().info("Configuring " + this.jobs.size() + " MapReduce job(s)...");
        for (int i = 0; i < this.jobs.size(); ++i) {
            Path curJobDir;
            Job job = this.jobs.get(i);
            ModifiableHadoopConfiguration jobFaunusConf = ModifiableHadoopConfiguration.of(job.getConfiguration());
            Path defaultJobDir = new Path(jobPathPrefix + "-" + i);
            Path prevJobDir = new Path(jobPathPrefix + "-" + (i - 1));
            for (ConfigOption c : Arrays.asList(TitanHadoopConfiguration.PIPELINE_TRACK_PATHS, TitanHadoopConfiguration.PIPELINE_TRACK_STATE)) {
                jobFaunusConf.set(c, this.getTitanConf().get(c, new String[0]), new String[0]);
            }
            cpConf.configure(job);
            this.getLog().info("Configuring [Job " + (i + 1) + "/" + this.jobs.size() + ": " + job.getJobName() + "]");
            if (i == 0) {
                job.setInputFormatClass(this.graph.getGraphInputFormat());
                if (FileInputFormat.class.isAssignableFrom(this.graph.getGraphInputFormat())) {
                    FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{this.graph.getInputLocation()});
                    FileInputFormat.setInputPathFilter((Job)job, NoSideEffectFilter.class);
                }
            } else {
                job.setInputFormatClass(INTERMEDIATE_INPUT_FORMAT);
                FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{prevJobDir});
                FileInputFormat.setInputPathFilter((Job)job, NoSideEffectFilter.class);
            }
            try {
                this.getLog().debug("Set input format: {}", (Object)job.getInputFormatClass());
            }
            catch (ClassNotFoundException e) {
                this.getLog().warn("Unable to check input format class on current job");
            }
            for (Path p : FileInputFormat.getInputPaths((JobContext)job)) {
                this.getLog().debug("Set input path: {}", (Object)p);
            }
            if (i == this.jobs.size() - 1) {
                LazyOutputFormat.setOutputFormatClass((Job)job, this.graph.getGraphOutputFormat());
                this.addNamedOutput(job, "sideeffect", this.graph.getSideEffectOutputFormat(), job.getOutputKeyClass(), job.getOutputKeyClass());
                this.addNamedOutput(job, "graph", this.graph.getGraphOutputFormat(), NullWritable.class, FaunusVertex.class);
                curJobDir = jobFaunusConf.has(TitanHadoopConfiguration.FINAL_OUTPUT_LOCATION, new String[0]) ? new Path(jobFaunusConf.get(TitanHadoopConfiguration.FINAL_OUTPUT_LOCATION, new String[0])) : defaultJobDir;
            } else {
                LazyOutputFormat.setOutputFormatClass((Job)job, INTERMEDIATE_OUTPUT_FORMAT);
                this.addNamedOutput(job, "sideeffect", this.graph.getSideEffectOutputFormat(), job.getOutputKeyClass(), job.getOutputKeyClass());
                this.addNamedOutput(job, "graph", INTERMEDIATE_OUTPUT_FORMAT, NullWritable.class, FaunusVertex.class);
                curJobDir = defaultJobDir;
            }
            SequenceFileOutputFormat.setOutputPath((Job)job, (Path)curJobDir);
            try {
                this.getLog().debug("Set output format: {}", (Object)job.getOutputFormatClass());
            }
            catch (ClassNotFoundException e) {
                this.getLog().warn("Unable to check output format class on job {}", (Object)job);
            }
            this.getLog().debug("Output path: {}", (Object)curJobDir);
            this.getLog().debug("Map output key class: " + job.getMapOutputKeyClass());
            this.getLog().debug("Map output val class: " + job.getMapOutputValueClass());
            this.getLog().debug("Job output key class: " + job.getOutputKeyClass());
            this.getLog().debug("Job output val class: " + job.getOutputValueClass());
        }
        this.getLog().info("Configured {} MapReduce job(s)", (Object)this.jobs.size());
    }

    @Override
    public int run(String[] args) throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        if (null != this.graph.getJobDir() && this.graph.getJobDirOverwrite() && fs.exists(this.graph.getJobDir())) {
            fs.delete(this.graph.getJobDir(), true);
        }
        this.composeJobs();
        String jobTmp = this.graph.getJobDir().toString() + "/" + "job";
        this.getLog().info("Preparing to execute {} MapReduce job(s)...", (Object)this.jobs.size());
        for (int i = 0; i < this.jobs.size(); ++i) {
            Job job = this.jobs.get(i);
            try {
                ((JobConfigurationFormat)FormatTools.getBaseOutputFormatClass(job).newInstance()).updateJob(job);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String jobString = "[Job " + (i + 1) + "/" + this.jobs.size() + ": " + job.getJobName() + "]";
            this.getLog().info("Executing " + jobString);
            boolean success = job.waitForCompletion(true);
            if (i > 0) {
                Preconditions.checkNotNull((Object)jobTmp);
                Path path = new Path(jobTmp + "-" + (i - 1));
                for (FileStatus temp : fs.globStatus(new Path(path.toString() + "/" + "graph" + "*"))) {
                    this.getLog().debug("Deleting temp data location: " + temp.getPath());
                    fs.delete(temp.getPath(), true);
                }
                for (FileStatus temp : fs.globStatus(new Path(path.toString() + "/" + "part" + "*"))) {
                    this.getLog().debug("Deleting temp data location: " + temp.getPath());
                    fs.delete(temp.getPath(), true);
                }
            }
            if (!success) {
                this.getLog().error("Error executing {}; this job has failed and {} subsequent MapReduce job(s) have been canceled", (Object)jobString, (Object)(this.jobs.size() - (i + 1)));
                return -1;
            }
            this.getLog().info("Executed {} successfully", (Object)jobString);
        }
        this.getLog().info("Finished executing {} MapReduce job(s)", (Object)this.jobs.size());
        return 0;
    }

    private void addNamedOutput(Job job, String name, Class<? extends OutputFormat> outfmt, Class<?> keyClass, Class<?> valueClass) {
        this.getLog().debug("Adding output: name={}, format={}, keycls={}, valcls={}", new Object[]{name, outfmt, keyClass, valueClass});
        MultipleOutputs.addNamedOutput((Job)job, (String)name, outfmt, keyClass, valueClass);
    }
}

