/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.filter;

import com.thinkaurelius.titan.hadoop.FaunusPathElement;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class CyclicPathFilterMap {
    public static final String CLASS = Tokens.makeNamespace(CyclicPathFilterMap.class) + ".class";

    public static Configuration createConfiguration(Class<? extends Element> klass) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setClass(CLASS, klass, Element.class);
        configuration.setBoolean(Tokens.TITAN_HADOOP_PIPELINE_TRACK_PATHS, true);
        return configuration;
    }

    public static class Map
    extends Mapper<NullWritable, FaunusVertex, NullWritable, FaunusVertex> {
        private boolean isVertex;
        private HashSet set = new HashSet();

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.isVertex = HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context).getClass(CLASS, Element.class, Element.class).equals(Vertex.class);
        }

        public void map(NullWritable key, FaunusVertex value, Mapper.Context context) throws IOException, InterruptedException {
            long pathsFiltered = 0L;
            if (this.isVertex) {
                if (value.hasPaths()) {
                    Iterator<List<FaunusPathElement.MicroElement>> itty = value.getPaths().iterator();
                    while (itty.hasNext()) {
                        List<FaunusPathElement.MicroElement> path = itty.next();
                        this.set.clear();
                        this.set.addAll(path);
                        if (path.size() == this.set.size()) continue;
                        itty.remove();
                        ++pathsFiltered;
                    }
                }
            } else {
                for (Edge e : value.getEdges(Direction.BOTH, new String[0])) {
                    StandardFaunusEdge edge = (StandardFaunusEdge)e;
                    if (!edge.hasPaths()) continue;
                    Iterator<List<FaunusPathElement.MicroElement>> itty = edge.getPaths().iterator();
                    while (itty.hasNext()) {
                        List<FaunusPathElement.MicroElement> path = itty.next();
                        this.set.clear();
                        this.set.addAll(path);
                        if (path.size() == this.set.size()) continue;
                        itty.remove();
                        ++pathsFiltered;
                    }
                }
            }
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.PATHS_FILTERED, pathsFiltered);
            context.write((Object)NullWritable.get(), (Object)value);
        }
    }

    public static enum Counters {
        PATHS_FILTERED;

    }
}

