/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.filter;

import com.thinkaurelius.titan.hadoop.FaunusPathElement;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class DuplicateFilterMap {
    public static final String CLASS = Tokens.makeNamespace(DuplicateFilterMap.class) + ".class";

    public static Configuration createConfiguration(Class<? extends Element> klass) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setClass(CLASS, klass, Element.class);
        return configuration;
    }

    public static class Map
    extends Mapper<NullWritable, FaunusVertex, NullWritable, FaunusVertex> {
        private boolean isVertex;
        private boolean trackPaths;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            Configuration c = HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context);
            this.isVertex = c.getClass(CLASS, Element.class, Element.class).equals(Vertex.class);
            this.trackPaths = c.getBoolean(Tokens.TITAN_HADOOP_PIPELINE_TRACK_PATHS, false);
        }

        public void map(NullWritable key, FaunusVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.isVertex) {
                if (value.hasPaths()) {
                    if (this.trackPaths) {
                        List<FaunusPathElement.MicroElement> path = value.getPaths().get(0);
                        value.clearPaths();
                        value.addPath(path, false);
                    } else {
                        value.clearPaths();
                        value.startPath();
                    }
                    HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTICES_DEDUPED, 1L);
                }
            } else {
                long counter = 0L;
                for (Edge e : value.getEdges(Direction.BOTH, new String[0])) {
                    StandardFaunusEdge edge = (StandardFaunusEdge)e;
                    if (!edge.hasPaths()) continue;
                    if (this.trackPaths) {
                        List<FaunusPathElement.MicroElement> path = edge.getPaths().get(0);
                        edge.clearPaths();
                        edge.addPath(path, false);
                    } else {
                        edge.clearPaths();
                        edge.startPath();
                    }
                    ++counter;
                }
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.EDGES_DEDUPED, counter);
            }
            context.write((Object)NullWritable.get(), (Object)value);
        }
    }

    public static enum Counters {
        VERTICES_DEDUPED,
        EDGES_DEDUPED;

    }
}

