/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.sideeffect;

import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class CommitEdgesMap {
    public static final String ACTION = Tokens.makeNamespace(CommitEdgesMap.class) + ".action";

    public static Configuration createConfiguration(Tokens.Action action) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.set(ACTION, action.name());
        return configuration;
    }

    public static class Map
    extends Mapper<NullWritable, FaunusVertex, NullWritable, FaunusVertex> {
        private boolean drop;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.drop = Tokens.Action.valueOf(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context).get(ACTION)).equals((Object)Tokens.Action.DROP);
        }

        public void map(NullWritable key, FaunusVertex value, Mapper.Context context) throws IOException, InterruptedException {
            Iterator<Edge> itty = value.getEdges(Direction.IN, new String[0]).iterator();
            long edgesKept = 0L;
            long edgesDropped = 0L;
            while (itty.hasNext()) {
                if (this.drop) {
                    if (((StandardFaunusEdge)itty.next()).hasPaths()) {
                        itty.remove();
                        ++edgesDropped;
                        continue;
                    }
                    ++edgesKept;
                    continue;
                }
                if (!((StandardFaunusEdge)itty.next()).hasPaths()) {
                    itty.remove();
                    ++edgesDropped;
                    continue;
                }
                ++edgesKept;
            }
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.IN_EDGES_DROPPED, edgesDropped);
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.IN_EDGES_KEPT, edgesKept);
            itty = value.getEdges(Direction.OUT, new String[0]).iterator();
            edgesKept = 0L;
            edgesDropped = 0L;
            while (itty.hasNext()) {
                if (this.drop) {
                    if (((StandardFaunusEdge)itty.next()).hasPaths()) {
                        itty.remove();
                        ++edgesDropped;
                        continue;
                    }
                    ++edgesKept;
                    continue;
                }
                if (!((StandardFaunusEdge)itty.next()).hasPaths()) {
                    itty.remove();
                    ++edgesDropped;
                    continue;
                }
                ++edgesKept;
            }
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.OUT_EDGES_DROPPED, edgesDropped);
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.OUT_EDGES_KEPT, edgesKept);
            context.write((Object)NullWritable.get(), (Object)value);
        }
    }

    public static enum Counters {
        OUT_EDGES_DROPPED,
        OUT_EDGES_KEPT,
        IN_EDGES_DROPPED,
        IN_EDGES_KEPT;

    }
}

