/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.sideeffect;

import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.graphdb.internal.ElementLifeCycle;
import com.thinkaurelius.titan.hadoop.FaunusElement;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.Holder;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class CommitVerticesMapReduce {
    public static org.apache.hadoop.conf.Configuration createConfiguration(Tokens.Action action) {
        ModifiableHadoopConfiguration c = ModifiableHadoopConfiguration.withoutResources();
        c.set(TitanHadoopConfiguration.COMMIT_VERTICES_ACTION, action, new String[0]);
        return c.getHadoopConfiguration();
    }

    public static class Reduce
    extends Reducer<LongWritable, Holder, NullWritable, FaunusVertex> {
        private boolean trackState;

        public void setup(Reducer.Context context) {
            this.trackState = HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context).getBoolean(Tokens.TITAN_HADOOP_PIPELINE_TRACK_STATE, false);
        }

        public void reduce(LongWritable key, Iterable<Holder> values, Reducer.Context context) throws IOException, InterruptedException {
            FaunusVertex vertex = null;
            HashSet<Long> ids = new HashSet<Long>();
            for (Holder holder : values) {
                char tag = holder.getTag();
                if (tag == 'k') {
                    ids.add(((FaunusElement)holder.get()).getLongId());
                    continue;
                }
                if (tag == 'v') {
                    vertex = (FaunusVertex)holder.get();
                    continue;
                }
                vertex = (FaunusVertex)holder.get();
                Iterator<Edge> itty = vertex.getEdges(Direction.BOTH, new String[0]).iterator();
                while (itty.hasNext()) {
                    itty.next();
                    itty.remove();
                }
                vertex.updateLifeCycle(ElementLifeCycle.Event.REMOVED);
            }
            if (null != vertex) {
                if (ids.size() > 0) {
                    vertex.removeEdgesToFrom(ids);
                }
                if (this.trackState) {
                    context.write((Object)NullWritable.get(), (Object)vertex);
                } else if (!vertex.isRemoved()) {
                    context.write((Object)NullWritable.get(), (Object)vertex);
                }
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.OUT_EDGES_KEPT, Iterables.size(vertex.getEdges(Direction.OUT, new String[0])));
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.IN_EDGES_KEPT, Iterables.size(vertex.getEdges(Direction.IN, new String[0])));
            }
        }
    }

    public static class Combiner
    extends Reducer<LongWritable, Holder, LongWritable, Holder> {
        private final Holder<FaunusVertex> holder = new Holder();
        private Configuration faunusConf;

        public void setup(Reducer.Context context) {
            this.faunusConf = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context));
        }

        public void reduce(LongWritable key, Iterable<Holder> values, Reducer.Context context) throws IOException, InterruptedException {
            FaunusVertex vertex = null;
            HashSet<Long> ids = new HashSet<Long>();
            boolean isDeleted = false;
            for (Holder holder : values) {
                char tag = holder.getTag();
                if (tag == 'k') {
                    ids.add(((FaunusElement)holder.get()).getLongId());
                    continue;
                }
                vertex = (FaunusVertex)holder.get();
                isDeleted = tag == 'd';
            }
            if (null != vertex) {
                if (ids.size() > 0) {
                    vertex.removeEdgesToFrom(ids);
                }
                context.write((Object)key, this.holder.set(isDeleted ? (char)'d' : 'v', vertex));
            } else {
                for (Long id : ids) {
                    context.write((Object)key, this.holder.set('k', new FaunusVertex(this.faunusConf, id)));
                }
            }
        }
    }

    public static class Map
    extends Mapper<NullWritable, FaunusVertex, LongWritable, Holder> {
        private boolean drop;
        private final Holder<FaunusVertex> holder = new Holder();
        private final LongWritable longWritable = new LongWritable();
        private Configuration faunusConf;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.faunusConf = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context));
            Tokens.Action configuredAction = (Tokens.Action)((Object)this.faunusConf.get(TitanHadoopConfiguration.COMMIT_VERTICES_ACTION, new String[0]));
            this.drop = Tokens.Action.DROP.equals((Object)configuredAction);
        }

        public void map(NullWritable key, FaunusVertex value, Mapper.Context context) throws IOException, InterruptedException {
            boolean keep;
            boolean hasPaths = value.hasPaths();
            long verticesKept = 0L;
            long verticesDropped = 0L;
            if (this.drop && hasPaths) {
                keep = false;
            } else if (!this.drop && hasPaths) {
                keep = true;
            } else {
                boolean bl = keep = this.drop && !hasPaths;
            }
            if (keep) {
                this.longWritable.set(value.getLongId());
                context.write((Object)this.longWritable, this.holder.set('v', value));
                ++verticesKept;
            } else {
                Long id;
                long vertexId = value.getLongId();
                this.holder.set('k', new FaunusVertex(this.faunusConf, vertexId));
                for (Edge edge : value.getEdges(Direction.OUT, new String[0])) {
                    id = (Long)edge.getVertex(Direction.IN).getId();
                    if (id.equals(vertexId)) continue;
                    this.longWritable.set(id.longValue());
                    context.write((Object)this.longWritable, this.holder);
                }
                for (Edge edge : value.getEdges(Direction.IN, new String[0])) {
                    id = (Long)edge.getVertex(Direction.OUT).getId();
                    if (id.equals(vertexId)) continue;
                    this.longWritable.set(id.longValue());
                    context.write((Object)this.longWritable, this.holder);
                }
                this.longWritable.set(value.getLongId());
                context.write((Object)this.longWritable, this.holder.set('d', value));
                ++verticesDropped;
            }
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTICES_DROPPED, verticesDropped);
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTICES_KEPT, verticesKept);
        }
    }

    public static enum Counters {
        VERTICES_KEPT,
        VERTICES_DROPPED,
        OUT_EDGES_KEPT,
        IN_EDGES_KEPT;

    }
}

