/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.transform;

import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class EdgesMap {
    public static final String PROCESS_VERTICES = Tokens.makeNamespace(EdgesMap.class) + ".processVertices";

    public static Configuration createConfiguration(boolean processVertices) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setBoolean(PROCESS_VERTICES, processVertices);
        return configuration;
    }

    public static class Map
    extends Mapper<NullWritable, FaunusVertex, NullWritable, FaunusVertex> {
        private boolean processVertices;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.processVertices = HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context).getBoolean(PROCESS_VERTICES, true);
        }

        public void map(NullWritable key, FaunusVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.processVertices) {
                value.clearPaths();
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTICES_PROCESSED, 1L);
            }
            long edgesProcessed = 0L;
            for (Edge edge : value.getEdges(Direction.IN, new String[0])) {
                ((StandardFaunusEdge)edge).startPath();
                ++edgesProcessed;
            }
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.IN_EDGES_PROCESSED, edgesProcessed);
            edgesProcessed = 0L;
            for (Edge edge : value.getEdges(Direction.OUT, new String[0])) {
                ((StandardFaunusEdge)edge).startPath();
                ++edgesProcessed;
            }
            HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.OUT_EDGES_PROCESSED, edgesProcessed);
            context.write((Object)NullWritable.get(), (Object)value);
        }
    }

    public static enum Counters {
        VERTICES_PROCESSED,
        OUT_EDGES_PROCESSED,
        IN_EDGES_PROCESSED;

    }
}

