/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.transform;

import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.mapreduce.util.ElementPicker;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.thinkaurelius.titan.hadoop.mapreduce.util.SafeMapperOutputs;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class PropertyMapMap {
    public static final String CLASS = Tokens.makeNamespace(PropertyMapMap.class) + ".class";

    public static Configuration createConfiguration(Class<? extends Element> klass) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setClass(CLASS, klass, Element.class);
        return configuration;
    }

    public static class Map
    extends Mapper<NullWritable, FaunusVertex, LongWritable, Text> {
        private boolean isVertex;
        private SafeMapperOutputs outputs;
        private LongWritable longWritable = new LongWritable();
        private Text text = new Text();

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.isVertex = HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context).getClass(CLASS, Element.class, Element.class).equals(Vertex.class);
            this.outputs = new SafeMapperOutputs(context);
        }

        public void map(NullWritable key, FaunusVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.isVertex) {
                if (value.hasPaths()) {
                    this.longWritable.set(value.getLongId());
                    this.text.set(ElementPicker.getPropertyAsString(value, "_properties"));
                    int i = 0;
                    while ((long)i < value.pathCount()) {
                        this.outputs.write("sideeffect", (Writable)this.longWritable, (Writable)this.text);
                        ++i;
                    }
                    HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTICES_PROCESSED, 1L);
                }
            } else {
                long edgesProcessed = 0L;
                for (Edge e : value.getEdges(Direction.OUT, new String[0])) {
                    StandardFaunusEdge edge = (StandardFaunusEdge)e;
                    if (!edge.hasPaths()) continue;
                    this.longWritable.set(edge.getLongId());
                    this.text.set(ElementPicker.getPropertyAsString(edge, "_properties"));
                    int i = 0;
                    while ((long)i < edge.pathCount()) {
                        this.outputs.write("sideeffect", (Writable)this.longWritable, (Writable)this.text);
                        ++i;
                    }
                    ++edgesProcessed;
                }
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.OUT_EDGES_PROCESSED, edgesProcessed);
            }
            this.outputs.write("graph", (Writable)NullWritable.get(), (Writable)value);
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            this.outputs.close();
        }
    }

    public static enum Counters {
        VERTICES_PROCESSED,
        OUT_EDGES_PROCESSED;

    }
}

