/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.hadoop.FaunusElement;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import java.util.ArrayList;

public class ElementPicker {
    protected ElementPicker() {
    }

    public static String getPropertyAsString(FaunusElement element, String key) {
        if (key.equals("_properties")) {
            ArrayListMultimap properties = ArrayListMultimap.create();
            for (TitanProperty property : element.query().properties()) {
                properties.put((Object)property.getType().getName(), property.getValue());
            }
            properties.put((Object)"_id", (Object)element.getLongId());
            if (element instanceof StandardFaunusEdge) {
                properties.put((Object)"_label", (Object)((StandardFaunusEdge)element).getLabel());
            }
            return properties.toString();
        }
        if (element instanceof FaunusVertex) {
            ArrayList values = new ArrayList();
            Iterables.addAll(values, ((FaunusVertex)element).getPropertyValues(key));
            if (values.size() == 0) {
                return "null";
            }
            if (values.size() == 1) {
                return values.iterator().next().toString();
            }
            return ((Object)values).toString();
        }
        Object value = element.getProperty(key);
        if (null != value) {
            return value.toString();
        }
        return "null";
    }

    public static Object getProperty(FaunusElement element, String key) {
        if (key.equals("_properties")) {
            ArrayListMultimap properties = ArrayListMultimap.create();
            for (TitanProperty property : element.query().properties()) {
                properties.put((Object)property.getType().getName(), property.getValue());
            }
            properties.put((Object)"_id", (Object)element.getLongId());
            return properties;
        }
        if (element instanceof FaunusVertex) {
            ArrayList values = new ArrayList();
            Iterables.addAll(values, ((FaunusVertex)element).getPropertyValues(key));
            if (values.size() == 0) {
                return null;
            }
            if (values.size() == 1) {
                return values.iterator().next();
            }
            return values;
        }
        return element.getProperty(key);
    }
}

