/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan;

import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ReadConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.util.system.IOUtils;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public class StorageSetup {
    public static final String getHomeDir(String subdir) {
        File homefile;
        String homedir = System.getProperty("titan.testdir");
        if (null == homedir) {
            homedir = "target" + File.separator + "db";
        }
        if (subdir != null && !StringUtils.isEmpty((String)subdir)) {
            homedir = homedir + File.separator + subdir;
        }
        if (!(homefile = new File(homedir)).exists()) {
            homefile.mkdirs();
        }
        return homedir;
    }

    public static final String getHomeDir() {
        return StorageSetup.getHomeDir(null);
    }

    public static final File getHomeDirFile() {
        return StorageSetup.getHomeDirFile(null);
    }

    public static final File getHomeDirFile(String subdir) {
        return new File(StorageSetup.getHomeDir(subdir));
    }

    public static final void deleteHomeDir() {
        StorageSetup.deleteHomeDir(null);
    }

    public static final void deleteHomeDir(String subdir) {
        boolean success;
        File homeDirFile = StorageSetup.getHomeDirFile(subdir);
        if (!homeDirFile.exists()) {
            homeDirFile.mkdirs();
        }
        if (!(success = IOUtils.deleteFromDirectory((File)homeDirFile))) {
            throw new IllegalStateException("Could not remove " + homeDirFile);
        }
    }

    public static TitanGraph getInMemoryGraph() {
        return TitanFactory.open((BasicConfiguration)GraphDatabaseConfiguration.buildConfiguration().set(GraphDatabaseConfiguration.STORAGE_BACKEND, (Object)"inmemory", new String[0]));
    }

    public static WriteConfiguration addPermanentCache(ModifiableConfiguration conf) {
        conf.set(GraphDatabaseConfiguration.DB_CACHE, (Object)true, new String[0]);
        conf.set(GraphDatabaseConfiguration.DB_CACHE_TIME, (Object)0L, new String[0]);
        return conf.getConfiguration();
    }

    public static ModifiableConfiguration getConfig(WriteConfiguration config) {
        return new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, config, BasicConfiguration.Restriction.NONE);
    }

    public static BasicConfiguration getConfig(ReadConfiguration config) {
        return new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, config, BasicConfiguration.Restriction.NONE);
    }
}

