/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.blueprints;

import com.google.common.collect.ImmutableSet;
import com.thinkaurelius.titan.blueprints.TitanEdgeTestSuite;
import com.thinkaurelius.titan.blueprints.TitanGraphQueryTestSuite;
import com.thinkaurelius.titan.blueprints.TitanSpecificBlueprintsTestSuite;
import com.thinkaurelius.titan.blueprints.TransactionalTitanGraphTestSuite;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.GraphTestSuite;
import com.tinkerpop.blueprints.TestSuite;
import com.tinkerpop.blueprints.VertexQueryTestSuite;
import com.tinkerpop.blueprints.VertexTestSuite;
import com.tinkerpop.blueprints.impls.GraphTest;
import com.tinkerpop.blueprints.util.io.gml.GMLReaderTestSuite;
import com.tinkerpop.blueprints.util.io.graphml.GraphMLReaderTestSuite;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONReaderTestSuite;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TitanBlueprintsTest
extends GraphTest {
    private static final Logger log = LoggerFactory.getLogger(TitanBlueprintsTest.class);
    private volatile String lastSeenMethodName;
    protected final Map<String, TitanGraph> openGraphs = new HashMap<String, TitanGraph>();

    public void testVertexTestSuite() throws Exception {
        this.stopWatch();
        this.doTestSuite((TestSuite)new VertexTestSuite((GraphTest)this));
        TitanBlueprintsTest.printTestPerformance((String)"VertexTestSuite", (double)this.stopWatch());
    }

    public void testVertexQueryTestSuite() throws Exception {
        this.stopWatch();
        this.doTestSuite((TestSuite)new VertexQueryTestSuite((GraphTest)this));
        TitanBlueprintsTest.printTestPerformance((String)"VertexQueryTestSuite", (double)this.stopWatch());
    }

    public void testEdgeTestSuite() throws Exception {
        this.stopWatch();
        this.doTestSuite((TestSuite)new TitanEdgeTestSuite(this), (Set<String>)ImmutableSet.of((Object)"testEdgeIterator"));
        TitanBlueprintsTest.printTestPerformance((String)"EdgeTestSuite", (double)this.stopWatch());
    }

    public void testGraphTestSuite() throws Exception {
        this.stopWatch();
        this.doTestSuite((TestSuite)new GraphTestSuite((GraphTest)this), (Set<String>)ImmutableSet.of((Object)"testStringRepresentation", (Object)"testConnectivityPatterns", (Object)"testTreeConnectivity", (Object)"testGraphDataPersists"));
        TitanBlueprintsTest.printTestPerformance((String)"GraphTestSuite", (double)this.stopWatch());
    }

    public void testGraphQueryTestSuite() throws Exception {
        this.stopWatch();
        this.doTestSuite((TestSuite)new TitanGraphQueryTestSuite(this));
        TitanBlueprintsTest.printTestPerformance((String)"GraphQueryTestSuite", (double)this.stopWatch());
    }

    public void testTransactionalGraphTestSuite() throws Exception {
        this.stopWatch();
        HashSet<String> excludedTests = new HashSet<String>();
        if (!this.supportsMultipleGraphs()) {
            excludedTests.add("testCompetingThreadsOnMultipleDbInstances");
        }
        this.doTestSuite((TestSuite)new TransactionalTitanGraphTestSuite(this), excludedTests);
        TitanBlueprintsTest.printTestPerformance((String)"TransactionalTitanGraphTestSuite", (double)this.stopWatch());
    }

    public void testTitanSpecificTestSuite() throws Exception {
        this.stopWatch();
        this.doTestSuite(new TitanSpecificBlueprintsTestSuite(this));
        TitanBlueprintsTest.printTestPerformance((String)"TitanSpecificBlueprintsTestSuite", (double)this.stopWatch());
    }

    public void testGraphMLReaderTestSuite() throws Exception {
        this.stopWatch();
        this.doTestSuite((TestSuite)new GraphMLReaderTestSuite((GraphTest)this));
        TitanBlueprintsTest.printTestPerformance((String)"GraphMLReaderTestSuite", (double)this.stopWatch());
    }

    public void testGraphSONReaderTestSuite() throws Exception {
        this.stopWatch();
        this.doTestSuite((TestSuite)new GraphSONReaderTestSuite((GraphTest)this));
        TitanBlueprintsTest.printTestPerformance((String)"GraphSONReaderTestSuite", (double)this.stopWatch());
    }

    public void testGMLReaderTestSuite() throws Exception {
        this.stopWatch();
        this.doTestSuite((TestSuite)new GMLReaderTestSuite((GraphTest)this));
        TitanBlueprintsTest.printTestPerformance((String)"GMLReaderTestSuite", (double)this.stopWatch());
    }

    public abstract boolean supportsMultipleGraphs();

    public abstract void beforeSuite();

    public void afterSuite() {
    }

    protected String getMostRecentMethodName() {
        return this.lastSeenMethodName;
    }

    public Object convertId(Object id) {
        return null;
    }

    public String convertLabel(String label) {
        return label;
    }

    public void doTestSuite(TestSuite testSuite) throws Exception {
        this.doTestSuite(testSuite, new HashSet<String>());
    }

    protected abstract TitanGraph openGraph(String var1);

    protected void beforeOpeningGraph(String uid) {
        log.debug("Opening graph[uid={}] for the first time", (Object)uid);
    }

    protected void extraCleanUp(String uid) throws BackendException {
    }

    public Graph generateGraph() {
        return this.generateGraph("_DEFAULT_TITAN_GRAPH_UID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graph generateGraph(String uid) {
        Map<String, TitanGraph> map = this.openGraphs;
        synchronized (map) {
            if (!this.openGraphs.containsKey(uid)) {
                this.beforeOpeningGraph(uid);
            } else if (this.openGraphs.get(uid).isOpen()) {
                log.warn("Detected possible graph[uid={}] leak in Blueprints GraphTest method {}, shutting down the leaked graph", (Object)uid, (Object)this.getMostRecentMethodName());
                this.openGraphs.get(uid).shutdown();
            } else {
                log.debug("Reopening previously-closed graph[uid={}]", (Object)uid);
            }
        }
        log.info("Opening graph with uid={}", (Object)uid);
        this.openGraphs.put(uid, this.openGraph(uid));
        return (Graph)this.openGraphs.get(uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() throws BackendException {
        Map<String, TitanGraph> map = this.openGraphs;
        synchronized (map) {
            for (Map.Entry<String, TitanGraph> entry : this.openGraphs.entrySet()) {
                String uid = entry.getKey();
                TitanGraph g = entry.getValue();
                if (g.isOpen()) {
                    log.warn("Detected possible graph[uid={}] leak in Blueprints GraphTest method {}, shutting down the leaked graph", (Object)uid, (Object)this.getMostRecentMethodName());
                    g.shutdown();
                }
                this.extraCleanUp(uid);
            }
            this.openGraphs.clear();
        }
    }

    public void doTestSuite(TestSuite testSuite, Set<String> ignoreTests) throws Exception {
        this.beforeSuite();
        this.cleanUp();
        for (Method method : testSuite.getClass().getMethods()) {
            String name;
            if (ignoreTests.contains(method.getName()) || !method.getName().startsWith("test")) continue;
            this.lastSeenMethodName = name = testSuite.getClass().getSimpleName() + "." + method.getName();
            try {
                log.info("Testing " + name + "...");
                method.invoke((Object)testSuite, new Object[0]);
            }
            catch (Throwable e) {
                log.error("Encountered error in " + name);
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            finally {
                this.cleanUp();
            }
        }
        this.afterSuite();
    }
}

