/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StandardStoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.locking.Locker;
import com.thinkaurelius.titan.diskstorage.locking.LockerProvider;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.ExpectedValueCheckingStoreManager;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import com.thinkaurelius.titan.diskstorage.util.KeyColumn;
import com.thinkaurelius.titan.diskstorage.util.StandardBaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntry;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntryList;
import com.thinkaurelius.titan.diskstorage.util.time.StandardDuration;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.diskstorage.util.time.Timestamps;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExpectedValueCheckingTest {
    private IMocksControl ctrl;
    private ExpectedValueCheckingStoreManager expectManager;
    private KeyColumnValueStoreManager backingManager;
    private LockerProvider lockerProvider;
    private StoreFeatures backingFeatures;
    private ModifiableConfiguration globalConfig;
    private ModifiableConfiguration localConfig;
    private ModifiableConfiguration defaultConfig;
    private StoreTransaction consistentTx;
    private StoreTransaction inconsistentTx;
    private StoreTransaction expectTx;
    private Locker backingLocker;
    private KeyColumnValueStore backingStore;
    private KeyColumnValueStore expectStore;
    private Capture<BaseTransactionConfig> txConfigCapture;
    private BaseTransactionConfig defaultTxConfig;
    private static final String STORE_NAME = "ExpectTestStore";
    private static final String LOCK_SUFFIX = "_expecttest";
    private static final String LOCKER_NAME = "ExpectTestStore_expecttest";
    private static final StaticBuffer DATA_KEY = BufferUtil.getIntBuffer((int)1);
    private static final StaticBuffer DATA_COL = BufferUtil.getIntBuffer((int)2);
    private static final StaticBuffer DATA_VAL = BufferUtil.getIntBuffer((int)4);
    private static final StaticBuffer LOCK_KEY = BufferUtil.getIntBuffer((int)32);
    private static final StaticBuffer LOCK_COL = BufferUtil.getIntBuffer((int)64);
    private static final StaticBuffer LOCK_VAL = BufferUtil.getIntBuffer((int)128);

    @Before
    public void setupMocks() throws BackendException {
        this.ctrl = EasyMock.createStrictControl();
        this.ctrl.checkOrder(true);
        this.backingManager = (KeyColumnValueStoreManager)this.ctrl.createMock(KeyColumnValueStoreManager.class);
        this.lockerProvider = (LockerProvider)this.ctrl.createMock(LockerProvider.class);
        this.globalConfig = GraphDatabaseConfiguration.buildConfiguration();
        this.localConfig = GraphDatabaseConfiguration.buildConfiguration();
        this.defaultConfig = GraphDatabaseConfiguration.buildConfiguration();
        this.globalConfig.set(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, (Object)"global", new String[0]);
        this.localConfig.set(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, (Object)"local", new String[0]);
        this.defaultConfig.set(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, (Object)"default", new String[0]);
        this.defaultTxConfig = new StandardBaseTransactionConfig.Builder().customOptions((Configuration)this.defaultConfig).timestampProvider((TimestampProvider)Timestamps.MICRO).build();
        this.backingFeatures = new StandardStoreFeatures.Builder().keyConsistent((Configuration)this.globalConfig, (Configuration)this.localConfig).build();
        EasyMock.expect((Object)this.backingManager.getFeatures()).andReturn((Object)this.backingFeatures).once();
        this.txConfigCapture = new Capture(CaptureType.ALL);
        this.inconsistentTx = (StoreTransaction)this.ctrl.createMock(StoreTransaction.class);
        this.consistentTx = (StoreTransaction)this.ctrl.createMock(StoreTransaction.class);
        EasyMock.expect((Object)this.backingManager.beginTransaction((BaseTransactionConfig)EasyMock.capture(this.txConfigCapture))).andReturn((Object)this.inconsistentTx);
        EasyMock.expect((Object)this.backingManager.beginTransaction((BaseTransactionConfig)EasyMock.capture(this.txConfigCapture))).andReturn((Object)this.consistentTx);
        this.backingLocker = (Locker)this.ctrl.createMock(Locker.class);
        this.backingStore = (KeyColumnValueStore)this.ctrl.createMock(KeyColumnValueStore.class);
        EasyMock.expect((Object)this.backingManager.openDatabase(STORE_NAME)).andReturn((Object)this.backingStore);
        EasyMock.expect((Object)this.backingStore.getName()).andReturn((Object)STORE_NAME);
        EasyMock.expect((Object)this.lockerProvider.getLocker(LOCKER_NAME)).andReturn((Object)this.backingLocker);
        this.ctrl.replay();
        this.expectManager = new ExpectedValueCheckingStoreManager(this.backingManager, LOCK_SUFFIX, this.lockerProvider, (Duration)new StandardDuration(1L, TimeUnit.SECONDS));
        this.expectTx = this.expectManager.beginTransaction(this.defaultTxConfig);
        this.expectStore = this.expectManager.openDatabase(STORE_NAME);
        this.ctrl.verify();
        this.ctrl.reset();
    }

    @After
    public void verifyMocks() {
        this.ctrl.verify();
        this.ctrl.reset();
        Assert.assertTrue((boolean)this.txConfigCapture.hasCaptured());
        List txCfgs = this.txConfigCapture.getValues();
        Assert.assertEquals((long)2L, (long)txCfgs.size());
        Assert.assertEquals((Object)"default", (Object)((BaseTransactionConfig)txCfgs.get(0)).getCustomOption(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID));
        Assert.assertEquals((Object)"global", (Object)((BaseTransactionConfig)txCfgs.get(1)).getCustomOption(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID));
    }

    @Test
    public void testMutateWithLockUsesConsistentTx() throws BackendException {
        ImmutableList adds = ImmutableList.of((Object)StaticArrayEntry.of((StaticBuffer)DATA_COL, (StaticBuffer)DATA_VAL));
        ImmutableList dels = ImmutableList.of();
        KeyColumn kc = new KeyColumn(LOCK_KEY, LOCK_COL);
        this.backingLocker.writeLock(kc, this.consistentTx);
        this.backingLocker.checkLocks(this.consistentTx);
        StaticBuffer nextBuf = BufferUtil.nextBiggerBuffer((StaticBuffer)kc.getColumn());
        KeySliceQuery expectedValueQuery = new KeySliceQuery(kc.getKey(), kc.getColumn(), nextBuf);
        EasyMock.expect((Object)this.backingStore.getSlice(expectedValueQuery, this.consistentTx)).andReturn((Object)StaticArrayEntryList.of((Entry[])new Entry[]{StaticArrayEntry.of((StaticBuffer)LOCK_COL, (StaticBuffer)LOCK_VAL)}));
        this.backingStore.mutate(DATA_KEY, (List)adds, (List)dels, this.consistentTx);
        this.ctrl.replay();
        this.expectStore.acquireLock(LOCK_KEY, LOCK_COL, LOCK_VAL, this.expectTx);
        this.expectStore.mutate(DATA_KEY, (List)adds, (List)dels, this.expectTx);
    }

    @Test
    public void testMutateWithoutLockUsesInconsistentTx() throws BackendException {
        ImmutableList adds = ImmutableList.of((Object)StaticArrayEntry.of((StaticBuffer)DATA_COL, (StaticBuffer)DATA_VAL));
        ImmutableList dels = ImmutableList.of();
        this.backingStore.mutate(DATA_KEY, (List)adds, (List)dels, this.inconsistentTx);
        this.ctrl.replay();
        this.expectStore.mutate(DATA_KEY, (List)adds, (List)dels, this.expectTx);
    }

    @Test
    public void testMutateManyWithLockUsesConsistentTx() throws BackendException {
        ImmutableList adds = ImmutableList.of((Object)StaticArrayEntry.of((StaticBuffer)DATA_COL, (StaticBuffer)DATA_VAL));
        ImmutableList dels = ImmutableList.of();
        ImmutableMap mutations = ImmutableMap.of((Object)STORE_NAME, (Object)ImmutableMap.of((Object)DATA_KEY, (Object)new KCVMutation((List)adds, (List)dels)));
        KeyColumn kc = new KeyColumn(LOCK_KEY, LOCK_COL);
        this.backingLocker.writeLock(kc, this.consistentTx);
        this.backingLocker.checkLocks(this.consistentTx);
        StaticBuffer nextBuf = BufferUtil.nextBiggerBuffer((StaticBuffer)kc.getColumn());
        KeySliceQuery expectedValueQuery = new KeySliceQuery(kc.getKey(), kc.getColumn(), nextBuf);
        EasyMock.expect((Object)this.backingStore.getSlice(expectedValueQuery, this.consistentTx)).andReturn((Object)StaticArrayEntryList.of((Entry[])new Entry[]{StaticArrayEntry.of((StaticBuffer)LOCK_COL, (StaticBuffer)LOCK_VAL)}));
        this.backingManager.mutateMany((Map)mutations, this.consistentTx);
        this.ctrl.replay();
        this.expectStore.acquireLock(LOCK_KEY, LOCK_COL, LOCK_VAL, this.expectTx);
        this.expectManager.mutateMany((Map)mutations, this.expectTx);
    }

    @Test
    public void testMutateManyWithoutLockUsesInconsistentTx() throws BackendException {
        ImmutableList adds = ImmutableList.of((Object)StaticArrayEntry.of((StaticBuffer)DATA_COL, (StaticBuffer)DATA_VAL));
        ImmutableList dels = ImmutableList.of();
        ImmutableMap mutations = ImmutableMap.of((Object)STORE_NAME, (Object)ImmutableMap.of((Object)DATA_KEY, (Object)new KCVMutation((List)adds, (List)dels)));
        this.backingManager.mutateMany((Map)mutations, this.inconsistentTx);
        this.ctrl.replay();
        this.expectManager.mutateMany((Map)mutations, this.expectTx);
    }
}

