/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.diskstorage.AbstractKCVSTest;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.EntryMetaData;
import com.thinkaurelius.titan.diskstorage.KeyColumn;
import com.thinkaurelius.titan.diskstorage.KeyColumnValueStoreUtil;
import com.thinkaurelius.titan.diskstorage.KeyValueStoreUtil;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.CustomizeStoreKCVSManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVSUtil;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyIterator;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRangeQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.ttl.TTLKVCSManager;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import com.thinkaurelius.titan.diskstorage.util.ReadArrayBuffer;
import com.thinkaurelius.titan.diskstorage.util.RecordIterator;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntry;
import com.thinkaurelius.titan.testcategory.BrittleTests;
import com.thinkaurelius.titan.testcategory.OrderedKeyStoreTests;
import com.thinkaurelius.titan.testcategory.UnorderedKeyStoreTests;
import com.thinkaurelius.titan.testutil.RandomGenerator;
import com.thinkaurelius.titan.testutil.TestGraphConfigs;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KeyColumnValueStoreTest
extends AbstractKCVSTest {
    @Rule
    public TestName name = new TestName();
    private Logger log = LoggerFactory.getLogger(KeyColumnValueStoreTest.class);
    int numKeys = 500;
    int numColumns = 50;
    protected String storeName = "testStore1";
    public KeyColumnValueStoreManager manager;
    public StoreTransaction tx;
    public KeyColumnValueStore store;

    @Before
    public void setUp() throws Exception {
        KeyColumnValueStoreManager m = this.openStorageManager();
        m.clearStorage();
        m.close();
        this.open();
    }

    public abstract KeyColumnValueStoreManager openStorageManager() throws BackendException;

    public void open() throws BackendException {
        this.manager = this.openStorageManager();
        this.store = this.manager.openDatabase(this.storeName);
        this.tx = this.startTx();
    }

    public StoreTransaction startTx() throws BackendException {
        return this.manager.beginTransaction((BaseTransactionConfig)this.getTxConfig());
    }

    public StoreFeatures storeFeatures() {
        return this.manager.getFeatures();
    }

    public void clopen() throws BackendException {
        this.close();
        this.open();
    }

    @After
    public void tearDown() throws Exception {
        this.close();
    }

    public void close() throws BackendException {
        if (this.tx != null) {
            this.tx.commit();
        }
        if (null != this.store) {
            this.store.close();
        }
        if (null != this.manager) {
            this.manager.close();
        }
    }

    public void newTx() throws BackendException {
        if (this.tx != null) {
            this.tx.commit();
        }
        this.tx = this.startTx();
    }

    @Test
    public void createDatabase() {
    }

    public String[][] generateValues() {
        return KeyValueStoreUtil.generateData(this.numKeys, this.numColumns);
    }

    public void loadValues(String[][] values) throws BackendException {
        this.loadValues(this.store, values);
    }

    public void loadValues(KeyColumnValueStore store, String[][] values) throws BackendException {
        this.loadValues(store, values, -1, -1);
    }

    public void loadValues(String[][] values, int shiftEveryNthRow, int shiftSliceLength) throws BackendException {
        this.loadValues(this.store, values, shiftEveryNthRow, shiftSliceLength);
    }

    public void loadValues(KeyColumnValueStore store, String[][] values, int shiftEveryNthRow, int shiftSliceLength) throws BackendException {
        for (int i = 0; i < values.length; ++i) {
            ArrayList<Entry> entries = new ArrayList<Entry>();
            for (int j = 0; j < values[i].length; ++j) {
                StaticBuffer col;
                if (0 < shiftEveryNthRow && 0 == i % shiftEveryNthRow) {
                    ByteBuffer bb = ByteBuffer.allocate(shiftSliceLength + 9);
                    for (int s = 0; s < shiftSliceLength; ++s) {
                        bb.put((byte)-1);
                    }
                    bb.put(KeyValueStoreUtil.getBuffer(j + 1).asByteBuffer());
                    bb.flip();
                    col = StaticArrayBuffer.of((ByteBuffer)bb);
                } else {
                    col = KeyValueStoreUtil.getBuffer(j);
                }
                entries.add(StaticArrayEntry.of((StaticBuffer)col, (StaticBuffer)KeyValueStoreUtil.getBuffer(values[i][j])));
            }
            if (entries.isEmpty()) continue;
            store.mutate(KeyValueStoreUtil.getBuffer(i), entries, KeyColumnValueStore.NO_DELETIONS, this.tx);
        }
    }

    public void loadLowerTriangularValues(int dimension, int offset) throws BackendException {
        Preconditions.checkArgument((0 < dimension ? 1 : 0) != 0);
        ByteBuffer val = ByteBuffer.allocate(1);
        val.put((byte)-1);
        StaticArrayBuffer staticVal = StaticArrayBuffer.of((ByteBuffer)val);
        ArrayList<Entry> rowAdditions = new ArrayList<Entry>(dimension);
        for (int k = 0; k < dimension; ++k) {
            rowAdditions.clear();
            ByteBuffer key = ByteBuffer.allocate(8);
            key.putInt(0);
            key.putInt(k + offset);
            key.flip();
            StaticArrayBuffer staticKey = StaticArrayBuffer.of((ByteBuffer)key);
            for (int c = 0; c <= k; ++c) {
                ByteBuffer col = ByteBuffer.allocate(4);
                col.putInt(c + offset);
                col.flip();
                StaticArrayBuffer staticCol = StaticArrayBuffer.of((ByteBuffer)col);
                rowAdditions.add(StaticArrayEntry.of((StaticBuffer)staticCol, (StaticBuffer)staticVal));
            }
            this.store.mutate((StaticBuffer)staticKey, rowAdditions, Collections.emptyList(), this.tx);
        }
    }

    public Set<KeyColumn> deleteValues(int every) throws BackendException {
        HashSet<KeyColumn> removed = new HashSet<KeyColumn>();
        int counter = 0;
        for (int i = 0; i < this.numKeys; ++i) {
            ArrayList<StaticBuffer> deletions = new ArrayList<StaticBuffer>();
            for (int j = 0; j < this.numColumns; ++j) {
                if (++counter % every != 0) continue;
                removed.add(new KeyColumn(i, j));
                deletions.add(KeyValueStoreUtil.getBuffer(j));
            }
            this.store.mutate(KeyValueStoreUtil.getBuffer(i), KeyColumnValueStore.NO_ADDITIONS, deletions, this.tx);
        }
        return removed;
    }

    public Set<Integer> deleteKeys(int every) throws BackendException {
        HashSet<Integer> removed = new HashSet<Integer>();
        for (int i = 0; i < this.numKeys; ++i) {
            if (i % every != 0) continue;
            removed.add(i);
            ArrayList<StaticBuffer> deletions = new ArrayList<StaticBuffer>();
            for (int j = 0; j < this.numColumns; ++j) {
                deletions.add(KeyValueStoreUtil.getBuffer(j));
            }
            this.store.mutate(KeyValueStoreUtil.getBuffer(i), KeyColumnValueStore.NO_ADDITIONS, deletions, this.tx);
        }
        return removed;
    }

    public void checkKeys(Set<Integer> removed) throws BackendException {
        for (int i = 0; i < this.numKeys; ++i) {
            if (removed.contains(i)) {
                Assert.assertFalse((boolean)KCVSUtil.containsKey((KeyColumnValueStore)this.store, (StaticBuffer)KeyValueStoreUtil.getBuffer(i), (StoreTransaction)this.tx));
                continue;
            }
            Assert.assertTrue((boolean)KCVSUtil.containsKey((KeyColumnValueStore)this.store, (StaticBuffer)KeyValueStoreUtil.getBuffer(i), (StoreTransaction)this.tx));
        }
    }

    public void checkValueExistence(String[][] values) throws BackendException {
        this.checkValueExistence(values, new HashSet<KeyColumn>());
    }

    public void checkValueExistence(String[][] values, Set<KeyColumn> removed) throws BackendException {
        for (int i = 0; i < this.numKeys; ++i) {
            for (int j = 0; j < this.numColumns; ++j) {
                boolean result = KCVSUtil.containsKeyColumn((KeyColumnValueStore)this.store, (StaticBuffer)KeyValueStoreUtil.getBuffer(i), (StaticBuffer)KeyValueStoreUtil.getBuffer(j), (StoreTransaction)this.tx);
                if (removed.contains(new KeyColumn(i, j))) {
                    Assert.assertFalse((boolean)result);
                    continue;
                }
                Assert.assertTrue((boolean)result);
            }
        }
    }

    public void checkValues(String[][] values) throws BackendException {
        this.checkValues(values, new HashSet<KeyColumn>());
    }

    public void checkValues(String[][] values, Set<KeyColumn> removed) throws BackendException {
        for (int i = 0; i < this.numKeys; ++i) {
            for (int j = 0; j < this.numColumns; ++j) {
                StaticBuffer result = KCVSUtil.get((KeyColumnValueStore)this.store, (StaticBuffer)KeyValueStoreUtil.getBuffer(i), (StaticBuffer)KeyValueStoreUtil.getBuffer(j), (StoreTransaction)this.tx);
                if (removed.contains(new KeyColumn(i, j))) {
                    Assert.assertNull((Object)result);
                    continue;
                }
                Assert.assertEquals((Object)values[i][j], (Object)KeyValueStoreUtil.getString(result));
            }
        }
    }

    @Test
    public void storeAndRetrieve() throws BackendException {
        String[][] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        this.log.debug("Checking values...");
        this.checkValueExistence(values);
        this.checkValues(values);
    }

    public void compareStores() throws BackendException {
        int keys = 1000;
        int columns = 2000;
        boolean normalMode = true;
        String[][] values = new String[keys * 2][];
        for (int i = 0; i < keys * 2; ++i) {
            values[i] = i % 2 == 0 ? (normalMode ? new String[columns + 4] : new String[4]) : (normalMode ? new String[0] : new String[columns]);
            for (int j = 0; j < values[i].length; ++j) {
                values[i][j] = RandomGenerator.randomString(30, 35);
            }
        }
        this.log.debug("Loading values: " + keys + "x" + columns);
        long time = System.currentTimeMillis();
        this.loadValues(values);
        this.clopen();
        System.out.println("Loading time (ms): " + (System.currentTimeMillis() - time));
        Random r = new Random();
        int trials = 500;
        this.log.debug("Reading values: " + trials + " trials");
        for (int i = 0; i < 10; ++i) {
            time = System.currentTimeMillis();
            for (int t = 0; t < trials; ++t) {
                int key = r.nextInt(keys) * 2;
                Assert.assertEquals((long)2L, (long)this.store.getSlice(new KeySliceQuery(KeyValueStoreUtil.getBuffer(key), KeyValueStoreUtil.getBuffer(2002), KeyValueStoreUtil.getBuffer(2004)), this.tx).size());
            }
            System.out.println("Reading time (ms): " + (System.currentTimeMillis() - time));
        }
    }

    @Test
    public void storeAndRetrievePerformance() throws BackendException {
        int multiplier = 4;
        int keys = 50 * multiplier;
        int columns = 200;
        String[][] values = KeyValueStoreUtil.generateData(keys, columns);
        this.log.debug("Loading values: " + keys + "x" + columns);
        long time = System.currentTimeMillis();
        this.loadValues(values);
        this.clopen();
        System.out.println("Loading time (ms): " + (System.currentTimeMillis() - time));
        Random r = new Random();
        int trials = 500 * multiplier;
        int delta = 10;
        this.log.debug("Reading values: " + trials + " trials");
        for (int i = 0; i < 1; ++i) {
            time = System.currentTimeMillis();
            for (int t = 0; t < trials; ++t) {
                int key = r.nextInt(keys);
                int start = r.nextInt(columns - delta);
                this.store.getSlice(new KeySliceQuery(KeyValueStoreUtil.getBuffer(key), KeyValueStoreUtil.getBuffer(start), KeyValueStoreUtil.getBuffer(start + delta)), this.tx);
            }
            System.out.println("Reading time (ms): " + (System.currentTimeMillis() - time));
        }
    }

    @Test
    public void storeAndRetrieveWithClosing() throws BackendException {
        String[][] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        this.clopen();
        this.log.debug("Checking values...");
        this.checkValueExistence(values);
        this.checkValues(values);
    }

    @Test
    public void deleteColumnsTest1() throws BackendException {
        String[][] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        this.clopen();
        Set<KeyColumn> deleted = this.deleteValues(7);
        this.log.debug("Checking values...");
        this.checkValueExistence(values, deleted);
        this.checkValues(values, deleted);
    }

    @Test
    public void deleteColumnsTest2() throws BackendException {
        String[][] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        this.newTx();
        Set<KeyColumn> deleted = this.deleteValues(7);
        this.clopen();
        this.log.debug("Checking values...");
        this.checkValueExistence(values, deleted);
        this.checkValues(values, deleted);
    }

    @Test
    public void deleteKeys() throws BackendException {
        String[][] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        this.newTx();
        Set<Integer> deleted = this.deleteKeys(11);
        this.clopen();
        this.checkKeys(deleted);
    }

    @Test
    public void scanTest() throws BackendException {
        if (this.manager.getFeatures().hasScan()) {
            String[][] values = this.generateValues();
            this.loadValues(values);
            KeyIterator iterator0 = KCVSUtil.getKeys((KeyColumnValueStore)this.store, (StoreFeatures)this.storeFeatures(), (int)8, (int)4, (StoreTransaction)this.tx);
            this.verifyIterator(iterator0, this.numKeys, 1);
            this.clopen();
            KeyIterator iterator1 = KCVSUtil.getKeys((KeyColumnValueStore)this.store, (StoreFeatures)this.storeFeatures(), (int)8, (int)4, (StoreTransaction)this.tx);
            KeyIterator iterator2 = KCVSUtil.getKeys((KeyColumnValueStore)this.store, (StoreFeatures)this.storeFeatures(), (int)8, (int)4, (StoreTransaction)this.tx);
            KeyIterator iterator3 = KCVSUtil.getKeys((KeyColumnValueStore)this.store, (StoreFeatures)this.storeFeatures(), (int)8, (int)4, (StoreTransaction)this.tx);
            this.verifyIterator(iterator1, this.numKeys, 1);
            this.verifyIterator(iterator2, this.numKeys, 1);
        }
    }

    private void verifyIterator(KeyIterator iter, int expectedKeys, int exepctedCols) {
        int keys = 0;
        while (iter.hasNext()) {
            StaticBuffer b = (StaticBuffer)iter.next();
            Assert.assertTrue((b != null && b.length() > 0 ? 1 : 0) != 0);
            ++keys;
            RecordIterator entries = iter.getEntries();
            int cols = 0;
            while (entries.hasNext()) {
                Entry e = (Entry)entries.next();
                Assert.assertTrue((e != null && e.length() > 0 ? 1 : 0) != 0);
                ++cols;
            }
            Assert.assertEquals((long)exepctedCols, (long)cols);
        }
        Assert.assertEquals((long)expectedKeys, (long)keys);
    }

    @Test
    @Category(value={OrderedKeyStoreTests.class})
    public void testOrderedGetKeysRespectsKeyLimit() throws BackendException {
        if (!this.manager.getFeatures().hasOrderedScan()) {
            this.log.warn("Can't test key-ordered features on incompatible store.  This warning could indicate reduced test coverage and a broken JUnit configuration.  Skipping test {}.", (Object)this.name.getMethodName());
            return;
        }
        Preconditions.checkArgument((4 <= this.numKeys ? 1 : 0) != 0);
        Preconditions.checkArgument((4 <= this.numColumns ? 1 : 0) != 0);
        long minKey = 1001L;
        long maxKey = 1000L + (long)this.numKeys - 2L;
        long expectedKeyCount = maxKey - 1001L;
        String[][] values = this.generateValues();
        this.loadValues(values);
        SliceQuery columnSlice = new SliceQuery(BufferUtil.zeroBuffer((int)8), BufferUtil.oneBuffer((int)8)).setLimit(1);
        KeyIterator keys = this.store.getKeys(new KeyRangeQuery(BufferUtil.getLongBuffer((long)1001L), BufferUtil.getLongBuffer((long)maxKey), columnSlice), this.tx);
        Assert.assertEquals((long)expectedKeyCount, (long)KeyValueStoreUtil.count(keys));
        this.clopen();
        keys = this.store.getKeys(new KeyRangeQuery(BufferUtil.getLongBuffer((long)1001L), BufferUtil.getLongBuffer((long)maxKey), columnSlice), this.tx);
        Assert.assertEquals((long)expectedKeyCount, (long)KeyValueStoreUtil.count(keys));
    }

    @Test
    public void testGetKeysColumnSlicesSimple() throws BackendException {
        if (this.manager.getFeatures().hasScan()) {
            int shiftEveryNthRows = 10;
            int expectedKeyCount = this.numKeys / 10 * 9;
            Preconditions.checkArgument((0 == this.numKeys % 10 ? 1 : 0) != 0);
            Preconditions.checkArgument((10 < this.numKeys / 10 ? 1 : 0) != 0);
            String[][] values = this.generateValues();
            this.loadValues(values, 10, 4);
            KeyIterator i = KCVSUtil.getKeys((KeyColumnValueStore)this.store, (StoreFeatures)this.storeFeatures(), (int)8, (int)4, (StoreTransaction)this.tx);
            Assert.assertEquals((long)expectedKeyCount, (long)KeyValueStoreUtil.count(i));
            this.clopen();
            i = KCVSUtil.getKeys((KeyColumnValueStore)this.store, (StoreFeatures)this.storeFeatures(), (int)8, (int)4, (StoreTransaction)this.tx);
            Assert.assertEquals((long)expectedKeyCount, (long)KeyValueStoreUtil.count(i));
        }
    }

    @Test
    public void testGetKeysColumnSlicesOnLowerTriangular() throws BackendException, IOException {
        if (this.manager.getFeatures().hasScan()) {
            int offset = 10;
            int size = 10;
            int midpoint = 15;
            int upper = 20;
            boolean step = true;
            Preconditions.checkArgument((boolean)true);
            Preconditions.checkArgument((boolean)true);
            Preconditions.checkArgument((boolean)true);
            Preconditions.checkArgument((boolean)true);
            this.loadLowerTriangularValues(10, 10);
            boolean executed = false;
            if (this.manager.getFeatures().hasUnorderedScan()) {
                HashSet<StaticBuffer> expected = new HashSet<StaticBuffer>(10);
                for (int start = 15; start >= 9; --start) {
                    for (int end = 16; end <= 21; ++end) {
                        Preconditions.checkArgument((start < end ? 1 : 0) != 0);
                        StaticBuffer startCol = BufferUtil.getIntBuffer((int)start);
                        StaticBuffer endCol = BufferUtil.getIntBuffer((int)end);
                        SliceQuery sq = new SliceQuery(startCol, endCol);
                        expected.clear();
                        for (long l = (long)Math.max(start, 10); l < 20L; ++l) {
                            expected.add(BufferUtil.getLongBuffer((long)l));
                        }
                        KeyIterator i = this.store.getKeys(sq, this.tx);
                        HashSet actual = Sets.newHashSet((Iterator)i);
                        this.log.debug("Checking bounds [{}, {}) (expect {} keys)", new Object[]{startCol, endCol, expected.size()});
                        Assert.assertEquals(expected, (Object)actual);
                        i.close();
                        executed = true;
                    }
                }
            } else if (this.manager.getFeatures().hasOrderedScan()) {
                ArrayList<StaticBuffer> expected = new ArrayList<StaticBuffer>(10);
                for (int start = 15; start >= 9; --start) {
                    for (int end = 16; end <= 21; ++end) {
                        Preconditions.checkArgument((start < end ? 1 : 0) != 0);
                        StaticBuffer startCol = BufferUtil.getIntBuffer((int)start);
                        StaticBuffer endCol = BufferUtil.getIntBuffer((int)end);
                        SliceQuery sq = new SliceQuery(startCol, endCol);
                        StaticBuffer keyStart = BufferUtil.getLongBuffer((long)start);
                        StaticBuffer keyEnd = BufferUtil.getLongBuffer((long)end);
                        KeyRangeQuery krq = new KeyRangeQuery(keyStart, keyEnd, sq);
                        expected.clear();
                        for (long l = (long)Math.max(start, 10); l < (long)Math.min(20, end); ++l) {
                            expected.add(BufferUtil.getLongBuffer((long)l));
                        }
                        KeyIterator i = this.store.getKeys(krq, this.tx);
                        ArrayList actual = Lists.newArrayList((Iterator)i);
                        this.log.debug("Checking bounds key:[{}, {}) & col:[{}, {}) (expect {} keys)", new Object[]{keyStart, keyEnd, startCol, endCol, expected.size()});
                        Assert.assertEquals(expected, (Object)actual);
                        i.close();
                        executed = true;
                    }
                }
            } else {
                throw new UnsupportedOperationException("Illegal store configuration: supportsScan()=true but supportsOrderedScan()=supportsUnorderedScan()=false");
            }
            Preconditions.checkArgument((boolean)executed);
        }
    }

    public void checkSlice(String[][] values, Set<KeyColumn> removed, int key, int start, int end, int limit) throws BackendException {
        this.tx.rollback();
        this.tx = this.startTx();
        EntryList entries = limit <= 0 ? this.store.getSlice(new KeySliceQuery(KeyValueStoreUtil.getBuffer(key), KeyValueStoreUtil.getBuffer(start), KeyValueStoreUtil.getBuffer(end)), this.tx) : this.store.getSlice(new KeySliceQuery(KeyValueStoreUtil.getBuffer(key), KeyValueStoreUtil.getBuffer(start), KeyValueStoreUtil.getBuffer(end)).setLimit(limit), this.tx);
        int pos = 0;
        for (int i = start; i < end; ++i) {
            if (removed.contains(new KeyColumn(key, i))) {
                this.log.debug("Skipping deleted ({},{})", (Object)key, (Object)i);
                continue;
            }
            if (limit <= 0 || pos < limit) {
                this.log.debug("Checking k={}[c_start={},c_end={}](limit={}): column index={}/pos={}", new Object[]{key, start, end, limit, i, pos});
                Assert.assertTrue((entries.size() > pos ? 1 : 0) != 0);
                Entry entry = (Entry)entries.get(pos);
                int col = KeyValueStoreUtil.getID(entry.getColumn());
                String str = KeyValueStoreUtil.getString((StaticBuffer)entry.getValueAs(StaticBuffer.STATIC_FACTORY));
                Assert.assertEquals((long)i, (long)col);
                Assert.assertEquals((Object)values[key][i], (Object)str);
            }
            ++pos;
        }
        Assert.assertNotNull((Object)entries);
        if (limit > 0 && pos > limit) {
            Assert.assertEquals((long)limit, (long)entries.size());
        } else {
            Assert.assertEquals((long)pos, (long)entries.size());
        }
    }

    @Test
    public void intervalTest1() throws BackendException {
        String[][] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        HashSet deleted = Sets.newHashSet();
        this.clopen();
        int trails = 5000;
        for (int t = 0; t < trails; ++t) {
            int key = RandomGenerator.randomInt(0, this.numKeys);
            int start = RandomGenerator.randomInt(0, this.numColumns);
            int end = RandomGenerator.randomInt(start, this.numColumns);
            int limit = RandomGenerator.randomInt(1, 30);
            this.checkSlice(values, deleted, key, start, end, limit);
            this.checkSlice(values, deleted, key, start, end, -1);
        }
    }

    @Test
    public void intervalTest2() throws BackendException {
        String[][] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        this.newTx();
        Set<KeyColumn> deleted = this.deleteValues(7);
        this.clopen();
        int trails = 5000;
        for (int t = 0; t < trails; ++t) {
            int key = RandomGenerator.randomInt(0, this.numKeys);
            int start = RandomGenerator.randomInt(0, this.numColumns);
            int end = RandomGenerator.randomInt(start, this.numColumns);
            int limit = RandomGenerator.randomInt(1, 30);
            this.checkSlice(values, deleted, key, start, end, limit);
            this.checkSlice(values, deleted, key, start, end, -1);
        }
    }

    @Test
    public void testConcurrentGetSlice() throws ExecutionException, InterruptedException, BackendException {
        this.testConcurrentStoreOps(false);
    }

    @Test
    public void testConcurrentGetSliceAndMutate() throws BackendException, ExecutionException, InterruptedException {
        this.testConcurrentStoreOps(true);
    }

    private void testConcurrentStoreOps(boolean deletionEnabled) throws BackendException, ExecutionException, InterruptedException {
        String[][] values = this.generateValues();
        this.loadValues(values);
        this.tx.commit();
        this.tx = this.startTx();
        int NUM_THREADS = 64;
        ExecutorService es = Executors.newFixedThreadPool(64);
        ArrayList<ConcurrentRandomSliceReader> tasks = new ArrayList<ConcurrentRandomSliceReader>(64);
        for (int i = 0; i < 64; ++i) {
            HashSet deleted = Sets.newHashSet();
            if (!deletionEnabled) {
                tasks.add(new ConcurrentRandomSliceReader(values, deleted));
                continue;
            }
            tasks.add(new ConcurrentRandomSliceReader(values, deleted, i));
        }
        ArrayList futures = new ArrayList(64);
        for (Runnable runnable : tasks) {
            futures.add(es.submit(runnable));
        }
        int collected = 0;
        for (Future future : futures) {
            future.get();
            ++collected;
        }
        Assert.assertEquals((long)64L, (long)collected);
    }

    @Test
    public void getNonExistentKeyReturnsNull() throws Exception {
        Assert.assertEquals(null, (Object)KeyColumnValueStoreUtil.get(this.store, this.tx, 0L, "col0"));
        Assert.assertEquals(null, (Object)KeyColumnValueStoreUtil.get(this.store, this.tx, 0L, "col1"));
    }

    @Test
    public void insertingGettingAndDeletingSimpleDataWorks() throws Exception {
        KeyColumnValueStoreUtil.insert(this.store, this.tx, 0L, "col0", "val0");
        KeyColumnValueStoreUtil.insert(this.store, this.tx, 0L, "col1", "val1");
        this.tx.commit();
        this.tx = this.startTx();
        Assert.assertEquals((Object)"val0", (Object)KeyColumnValueStoreUtil.get(this.store, this.tx, 0L, "col0"));
        Assert.assertEquals((Object)"val1", (Object)KeyColumnValueStoreUtil.get(this.store, this.tx, 0L, "col1"));
        KeyColumnValueStoreUtil.delete(this.store, this.tx, 0L, "col0");
        KeyColumnValueStoreUtil.delete(this.store, this.tx, 0L, "col1");
        this.tx.commit();
        this.tx = this.startTx();
        Assert.assertEquals(null, (Object)KeyColumnValueStoreUtil.get(this.store, this.tx, 0L, "col0"));
        Assert.assertEquals(null, (Object)KeyColumnValueStoreUtil.get(this.store, this.tx, 0L, "col1"));
    }

    @Test
    public void getSliceRespectsColumnLimit() throws Exception {
        StaticBuffer key = KeyColumnValueStoreUtil.longToByteBuffer(0L);
        int cols = 1024;
        LinkedList<Entry> entries = new LinkedList<Entry>();
        for (int i = 0; i < 1024; ++i) {
            StaticBuffer col = KeyColumnValueStoreUtil.longToByteBuffer(i);
            entries.add(StaticArrayEntry.of((StaticBuffer)col, (StaticBuffer)col));
        }
        this.store.mutate(key, entries, KeyColumnValueStore.NO_DELETIONS, this.tx);
        this.tx.commit();
        this.tx = this.startTx();
        StaticBuffer columnStart = KeyColumnValueStoreUtil.longToByteBuffer(0L);
        StaticBuffer columnEnd = KeyColumnValueStoreUtil.longToByteBuffer(1024L);
        EntryList result = this.store.getSlice(new KeySliceQuery(key, columnStart, columnEnd).setLimit(1024), this.tx);
        Assert.assertEquals((long)1024L, (long)result.size());
        for (int i = 0; i < result.size(); ++i) {
            Entry dst;
            Entry src = (Entry)entries.get(i);
            if (src.equals(dst = (Entry)result.get(i))) continue;
            boolean bl = true;
        }
        Assert.assertEquals(entries, (Object)result);
        result = this.store.getSlice(new KeySliceQuery(key, columnStart, columnEnd).setLimit(1034), this.tx);
        Assert.assertEquals((long)1024L, (long)result.size());
        Assert.assertEquals(entries, (Object)result);
        result = this.store.getSlice(new KeySliceQuery(key, columnStart, columnEnd).setLimit(1023), this.tx);
        Assert.assertEquals((long)1023L, (long)result.size());
        entries.remove(entries.size() - 1);
        Assert.assertEquals(entries, (Object)result);
        result = this.store.getSlice(new KeySliceQuery(key, columnStart, columnEnd).setLimit(1), this.tx);
        Assert.assertEquals((long)1L, (long)result.size());
        List<Entry> firstEntrySingleton = Arrays.asList((Entry)entries.get(0));
        Assert.assertEquals(firstEntrySingleton, (Object)result);
    }

    @Test
    public void getSliceRespectsAllBoundsInclusionArguments() throws Exception {
        StaticBuffer key = KeyColumnValueStoreUtil.longToByteBuffer(0L);
        StaticBuffer columnBeforeStart = KeyColumnValueStoreUtil.longToByteBuffer(776L);
        StaticBuffer columnStart = KeyColumnValueStoreUtil.longToByteBuffer(777L);
        StaticBuffer columnEnd = KeyColumnValueStoreUtil.longToByteBuffer(778L);
        StaticBuffer columnAfterEnd = KeyColumnValueStoreUtil.longToByteBuffer(779L);
        List<Entry> entries = Arrays.asList(StaticArrayEntry.of((StaticBuffer)columnBeforeStart, (StaticBuffer)columnBeforeStart), StaticArrayEntry.of((StaticBuffer)columnStart, (StaticBuffer)columnStart), StaticArrayEntry.of((StaticBuffer)columnEnd, (StaticBuffer)columnEnd), StaticArrayEntry.of((StaticBuffer)columnAfterEnd, (StaticBuffer)columnAfterEnd));
        this.store.mutate(key, entries, KeyColumnValueStore.NO_DELETIONS, this.tx);
        this.tx.commit();
        this.tx = this.startTx();
        EntryList result = this.store.getSlice(new KeySliceQuery(key, columnStart, columnEnd), this.tx);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)777L, (long)KeyColumnValueStoreUtil.bufferToLong(((Entry)result.get(0)).getColumn()));
    }

    @Test
    public void containsKeyReturnsTrueOnExtantKey() throws Exception {
        StaticBuffer key1 = KeyColumnValueStoreUtil.longToByteBuffer(1L);
        Assert.assertFalse((boolean)KCVSUtil.containsKey((KeyColumnValueStore)this.store, (StaticBuffer)key1, (StoreTransaction)this.tx));
        KeyColumnValueStoreUtil.insert(this.store, this.tx, 1L, "c", "v");
        this.tx.commit();
        this.tx = this.startTx();
        Assert.assertTrue((boolean)KCVSUtil.containsKey((KeyColumnValueStore)this.store, (StaticBuffer)key1, (StoreTransaction)this.tx));
    }

    @Test
    public void containsKeyReturnsFalseOnNonexistentKey() throws Exception {
        StaticBuffer key1 = KeyColumnValueStoreUtil.longToByteBuffer(1L);
        Assert.assertFalse((boolean)KCVSUtil.containsKey((KeyColumnValueStore)this.store, (StaticBuffer)key1, (StoreTransaction)this.tx));
    }

    @Test
    public void containsKeyColumnReturnsFalseOnNonexistentInput() throws Exception {
        StaticBuffer key1 = KeyColumnValueStoreUtil.longToByteBuffer(1L);
        StaticBuffer c = KeyColumnValueStoreUtil.stringToByteBuffer("c");
        Assert.assertFalse((boolean)KCVSUtil.containsKeyColumn((KeyColumnValueStore)this.store, (StaticBuffer)key1, (StaticBuffer)c, (StoreTransaction)this.tx));
    }

    @Test
    public void containsKeyColumnReturnsTrueOnExtantInput() throws Exception {
        KeyColumnValueStoreUtil.insert(this.store, this.tx, 1L, "c", "v");
        this.tx.commit();
        this.tx = this.startTx();
        StaticBuffer key1 = KeyColumnValueStoreUtil.longToByteBuffer(1L);
        StaticBuffer c = KeyColumnValueStoreUtil.stringToByteBuffer("c");
        Assert.assertTrue((boolean)KCVSUtil.containsKeyColumn((KeyColumnValueStore)this.store, (StaticBuffer)key1, (StaticBuffer)c, (StoreTransaction)this.tx));
    }

    @Test
    public void testGetSlices() throws Exception {
        if (!this.manager.getFeatures().hasMultiQuery()) {
            return;
        }
        this.populateDBWith100Keys();
        this.tx.commit();
        this.tx = this.startTx();
        ArrayList<StaticBuffer> keys = new ArrayList<StaticBuffer>(100);
        for (int i = 1; i <= 100; ++i) {
            keys.add(KeyColumnValueStoreUtil.longToByteBuffer(i));
        }
        StaticBuffer start = KeyColumnValueStoreUtil.stringToByteBuffer("a");
        StaticBuffer end = KeyColumnValueStoreUtil.stringToByteBuffer("d");
        Map results = this.store.getSlice(keys, new SliceQuery(start, end), this.tx);
        Assert.assertEquals((long)100L, (long)results.size());
        for (List entries : results.values()) {
            Assert.assertEquals((long)3L, (long)entries.size());
        }
    }

    @Test
    @Category(value={UnorderedKeyStoreTests.class})
    public void testGetKeysWithSliceQuery() throws Exception {
        if (!this.manager.getFeatures().hasUnorderedScan()) {
            this.log.warn("Can't test key-unordered features on incompatible store.  This warning could indicate reduced test coverage and a broken JUnit configuration.  Skipping test {}.", (Object)this.name.getMethodName());
            return;
        }
        this.populateDBWith100Keys();
        this.tx.commit();
        this.tx = this.startTx();
        KeyIterator keyIterator = this.store.getKeys(new SliceQuery((StaticBuffer)new ReadArrayBuffer("b".getBytes()), (StaticBuffer)new ReadArrayBuffer("c".getBytes())), this.tx);
        this.examineGetKeysResults(keyIterator, 0L, 100L, 1);
    }

    @Test
    @Category(value={OrderedKeyStoreTests.class})
    public void testGetKeysWithKeyRange() throws Exception {
        if (!this.manager.getFeatures().hasOrderedScan()) {
            this.log.warn("Can't test ordered scans on incompatible store.  This warning could indicate reduced test coverage and shouldn't happen in an ideal JUnit configuration.  Skipping test {}.", (Object)this.name.getMethodName());
            return;
        }
        this.populateDBWith100Keys();
        this.tx.commit();
        this.tx = this.startTx();
        KeyIterator keyIterator = this.store.getKeys(new KeyRangeQuery(KeyColumnValueStoreUtil.longToByteBuffer(10L), KeyColumnValueStoreUtil.longToByteBuffer(40L), (StaticBuffer)new ReadArrayBuffer("b".getBytes()), (StaticBuffer)new ReadArrayBuffer("c".getBytes())), this.tx);
        this.examineGetKeysResults(keyIterator, 10L, 40L, 1);
    }

    @Category(value={BrittleTests.class})
    @Test
    public void testTtl() throws Exception {
        if (!this.manager.getFeatures().hasCellTTL()) {
            return;
        }
        StaticBuffer key = KeyColumnValueStoreUtil.longToByteBuffer(0L);
        int[] ttls = new int[]{0, 1, 2};
        LinkedList<StaticArrayEntry> additions = new LinkedList<StaticArrayEntry>();
        for (int i = 0; i < ttls.length; ++i) {
            StaticBuffer col = KeyColumnValueStoreUtil.longToByteBuffer(i);
            StaticArrayEntry entry = (StaticArrayEntry)StaticArrayEntry.of((StaticBuffer)col, (StaticBuffer)col);
            entry.setMetaData(EntryMetaData.TTL, (Object)ttls[i]);
            additions.add(entry);
        }
        this.store.mutate(key, additions, KeyColumnValueStore.NO_DELETIONS, this.tx);
        this.tx.commit();
        long commitTime = System.currentTimeMillis();
        this.tx = this.startTx();
        StaticBuffer columnStart = KeyColumnValueStoreUtil.longToByteBuffer(0L);
        StaticBuffer columnEnd = KeyColumnValueStoreUtil.longToByteBuffer(ttls.length);
        EntryList result = this.store.getSlice(new KeySliceQuery(key, columnStart, columnEnd).setLimit(ttls.length), this.tx);
        Assert.assertEquals((long)ttls.length, (long)result.size());
        Thread.sleep(commitTime + 1001L - System.currentTimeMillis());
        result = this.store.getSlice(new KeySliceQuery(key, columnStart, columnEnd).setLimit(ttls.length), this.tx);
        Assert.assertEquals((long)(ttls.length - 1), (long)result.size());
        this.tx.rollback();
        result = this.store.getSlice(new KeySliceQuery(key, columnStart, columnEnd).setLimit(ttls.length), this.tx);
        Assert.assertEquals((long)(ttls.length - 1), (long)result.size());
        Thread.sleep(commitTime + 2001L - System.currentTimeMillis());
        this.tx.rollback();
        result = this.store.getSlice(new KeySliceQuery(key, columnStart, columnEnd).setLimit(ttls.length), this.tx);
        Assert.assertEquals((long)(ttls.length - 2), (long)result.size());
        Thread.sleep(commitTime + 4001L - System.currentTimeMillis());
        this.tx.rollback();
        result = this.store.getSlice(new KeySliceQuery(key, columnStart, columnEnd).setLimit(ttls.length), this.tx);
        Assert.assertEquals((long)(ttls.length - 2), (long)result.size());
    }

    @Test
    public void testStoreTTL() throws Exception {
        KeyColumnValueStoreManager storeManager = this.manager;
        if (storeManager.getFeatures().hasCellTTL()) {
            storeManager = new TTLKVCSManager(storeManager, 101);
        } else if (!storeManager.getFeatures().hasStoreTTL()) {
            return;
        }
        Assert.assertTrue((boolean)storeManager.getFeatures().hasStoreTTL());
        Assert.assertTrue((boolean)(storeManager instanceof CustomizeStoreKCVSManager));
        TimeUnit sec = TimeUnit.SECONDS;
        int storeTTLSeconds = (int)TestGraphConfigs.getTTL(sec);
        KeyColumnValueStore storeWithTTL = ((CustomizeStoreKCVSManager)storeManager).openDatabase("testStore_with_TTL", storeTTLSeconds);
        this.populateDBWith100Keys(storeWithTTL);
        this.tx.commit();
        this.tx = this.startTx();
        StaticBuffer key = KeyColumnValueStoreUtil.longToByteBuffer(2L);
        StaticBuffer start = KeyColumnValueStoreUtil.stringToByteBuffer("a");
        StaticBuffer end = KeyColumnValueStoreUtil.stringToByteBuffer("d");
        EntryList results = storeWithTTL.getSlice(new KeySliceQuery(key, new SliceQuery(start, end)), this.tx);
        Assert.assertEquals((long)3L, (long)results.size());
        Thread.sleep(TimeUnit.MILLISECONDS.convert((long)Math.ceil((double)storeTTLSeconds * 1.25), sec));
        this.tx.commit();
        this.tx = this.startTx();
        results = storeWithTTL.getSlice(new KeySliceQuery(key, new SliceQuery(start, end)), this.tx);
        Assert.assertEquals((long)0L, (long)results.size());
        storeWithTTL.close();
    }

    protected void populateDBWith100Keys() throws Exception {
        this.populateDBWith100Keys(this.store);
    }

    protected void populateDBWith100Keys(KeyColumnValueStore store) throws Exception {
        Random random = new Random();
        for (int i = 1; i <= 100; ++i) {
            KeyColumnValueStoreUtil.insert(store, this.tx, i, "a", "v" + random.nextLong());
            KeyColumnValueStoreUtil.insert(store, this.tx, i, "b", "v" + random.nextLong());
            KeyColumnValueStoreUtil.insert(store, this.tx, i, "c", "v" + random.nextLong());
        }
    }

    protected void examineGetKeysResults(KeyIterator keyIterator, long startKey, long endKey, int expectedColumns) throws BackendException {
        Assert.assertNotNull((Object)keyIterator);
        int count = 0;
        int expectedNumKeys = (int)(endKey - startKey);
        ArrayList<StaticBuffer> existingKeys = new ArrayList<StaticBuffer>(expectedNumKeys);
        int i = (int)(startKey == 0L ? 1L : startKey);
        while ((long)i <= endKey) {
            existingKeys.add(KeyColumnValueStoreUtil.longToByteBuffer(i));
            ++i;
        }
        while (keyIterator.hasNext()) {
            StaticBuffer key = (StaticBuffer)keyIterator.next();
            Assert.assertNotNull((Object)key);
            Assert.assertTrue((boolean)existingKeys.contains(key));
            RecordIterator entries = keyIterator.getEntries();
            Assert.assertNotNull((Object)entries);
            int entryCount = 0;
            while (entries.hasNext()) {
                Assert.assertNotNull((Object)entries.next());
                ++entryCount;
            }
            Assert.assertEquals((long)expectedColumns, (long)entryCount);
            ++count;
        }
        Assert.assertEquals((long)expectedNumKeys, (long)count);
    }

    private class ConcurrentRandomSliceReader
    implements Runnable {
        private final String[][] values;
        private final Set<KeyColumn> d;
        private final int startKey;
        private final int endKey;
        private final boolean deletionEnabled;

        public ConcurrentRandomSliceReader(String[][] values, Set<KeyColumn> deleted) {
            this.values = values;
            this.d = deleted;
            this.startKey = 0;
            this.endKey = values.length;
            this.deletionEnabled = false;
        }

        public ConcurrentRandomSliceReader(String[][] values, Set<KeyColumn> deleted, int key) {
            this.values = values;
            this.d = deleted;
            this.startKey = key % values.length;
            this.endKey = this.startKey + 1;
            this.deletionEnabled = true;
        }

        @Override
        public void run() {
            int trials = 5000;
            for (int t = 0; t < trials; ++t) {
                int key = RandomGenerator.randomInt(this.startKey, this.endKey);
                KeyColumnValueStoreTest.this.log.debug("Random key chosen: {} (start={}, end={})", new Object[]{key, this.startKey, this.endKey});
                int start = RandomGenerator.randomInt(0, KeyColumnValueStoreTest.this.numColumns);
                if (start == KeyColumnValueStoreTest.this.numColumns - 1) {
                    start = KeyColumnValueStoreTest.this.numColumns - 2;
                }
                int end = RandomGenerator.randomInt(start + 1, KeyColumnValueStoreTest.this.numColumns);
                int limit = RandomGenerator.randomInt(1, 30);
                try {
                    if (this.deletionEnabled) {
                        int delCol = RandomGenerator.randomInt(start, end);
                        ImmutableList deletions = ImmutableList.of((Object)KeyValueStoreUtil.getBuffer(delCol));
                        KeyColumnValueStoreTest.this.store.mutate(KeyValueStoreUtil.getBuffer(key), KeyColumnValueStore.NO_ADDITIONS, (List)deletions, KeyColumnValueStoreTest.this.tx);
                        KeyColumnValueStoreTest.this.log.debug("Deleting ({},{})", (Object)key, (Object)delCol);
                        this.d.add(new KeyColumn(key, delCol));
                        KeyColumnValueStoreTest.this.tx.commit();
                        KeyColumnValueStoreTest.this.tx = KeyColumnValueStoreTest.this.startTx();
                    }
                    KeyColumnValueStoreTest.this.checkSlice(this.values, this.d, key, start, end, limit);
                    KeyColumnValueStoreTest.this.checkSlice(this.values, this.d, key, start, end, -1);
                    continue;
                }
                catch (BackendException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

