/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage;

import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVSUtil;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntry;
import com.thinkaurelius.titan.diskstorage.util.WriteByteBuffer;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class KeyColumnValueStoreUtil {
    public static void delete(KeyColumnValueStore store, StoreTransaction txn, long key, String col) throws BackendException {
        StaticBuffer k = KeyColumnValueStoreUtil.longToByteBuffer(key);
        StaticBuffer c = KeyColumnValueStoreUtil.stringToByteBuffer(col);
        store.mutate(k, KeyColumnValueStore.NO_ADDITIONS, Arrays.asList(c), txn);
    }

    public static String get(KeyColumnValueStore store, StoreTransaction txn, long key, String col) throws BackendException {
        StaticBuffer c;
        StaticBuffer k = KeyColumnValueStoreUtil.longToByteBuffer(key);
        StaticBuffer valBytes = KCVSUtil.get((KeyColumnValueStore)store, (StaticBuffer)k, (StaticBuffer)(c = KeyColumnValueStoreUtil.stringToByteBuffer(col)), (StoreTransaction)txn);
        if (null == valBytes) {
            return null;
        }
        return KeyColumnValueStoreUtil.byteBufferToString(valBytes);
    }

    public static void insert(KeyColumnValueStore store, StoreTransaction txn, long key, String col, String val) throws BackendException {
        StaticBuffer k = KeyColumnValueStoreUtil.longToByteBuffer(key);
        StaticBuffer c = KeyColumnValueStoreUtil.stringToByteBuffer(col);
        StaticBuffer v = KeyColumnValueStoreUtil.stringToByteBuffer(val);
        store.mutate(k, Arrays.asList(StaticArrayEntry.of((StaticBuffer)c, (StaticBuffer)v)), KeyColumnValueStore.NO_DELETIONS, txn);
    }

    public static String byteBufferToString(StaticBuffer b) {
        try {
            ByteBuffer bb = b.asByteBuffer();
            return new String(bb.array(), bb.position() + bb.arrayOffset(), bb.remaining(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static StaticBuffer stringToByteBuffer(String s) {
        byte[] b;
        try {
            b = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        ByteBuffer bb = ByteBuffer.allocate(b.length);
        bb.put(b);
        bb.flip();
        return StaticArrayBuffer.of((ByteBuffer)bb);
    }

    public static StaticBuffer longToByteBuffer(long l) {
        return new WriteByteBuffer(8).putLong(l).getStaticBuffer();
    }

    public static long bufferToLong(StaticBuffer b) {
        return b.getLong(0);
    }
}

