/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage;

import com.google.common.collect.Lists;
import com.thinkaurelius.titan.diskstorage.AbstractKCVSTest;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BackendTransaction;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.KeyValueStoreUtil;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KVQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KVUtil;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KeyValueEntry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStoreManager;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import com.thinkaurelius.titan.diskstorage.util.RecordIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KeyValueStoreTest
extends AbstractKCVSTest {
    private Logger log = LoggerFactory.getLogger(KeyValueStoreTest.class);
    private int numKeys = 2000;
    private String storeName = "testStore1";
    protected OrderedKeyValueStoreManager manager;
    protected StoreTransaction tx;
    protected OrderedKeyValueStore store;

    @Before
    public void setUp() throws Exception {
        OrderedKeyValueStoreManager m = this.openStorageManager();
        m.clearStorage();
        m.close();
        this.open();
    }

    public void open() throws BackendException {
        this.manager = this.openStorageManager();
        this.store = this.manager.openDatabase(this.storeName);
        this.tx = this.manager.beginTransaction((BaseTransactionConfig)this.getTxConfig());
    }

    public abstract OrderedKeyValueStoreManager openStorageManager() throws BackendException;

    @After
    public void tearDown() throws Exception {
        this.close();
    }

    public void close() throws BackendException {
        if (this.tx != null) {
            this.tx.commit();
        }
        this.store.close();
        this.manager.close();
    }

    public void clopen() throws BackendException {
        this.close();
        this.open();
    }

    @Test
    public void createDatabase() {
    }

    public String[] generateValues() {
        return KeyValueStoreUtil.generateData(this.numKeys);
    }

    public void loadValues(String[] values) throws BackendException {
        for (int i = 0; i < this.numKeys; ++i) {
            this.store.insert(KeyValueStoreUtil.getBuffer(i), KeyValueStoreUtil.getBuffer(values[i]), this.tx);
        }
    }

    public Set<Integer> deleteValues(int start, int every) throws BackendException {
        HashSet<Integer> removed = new HashSet<Integer>();
        for (int i = start; i < this.numKeys; i += every) {
            removed.add(i);
            this.store.delete(KeyValueStoreUtil.getBuffer(i), this.tx);
        }
        return removed;
    }

    public void checkValueExistence(String[] values) throws BackendException {
        this.checkValueExistence(values, new HashSet<Integer>());
    }

    public void checkValueExistence(String[] values, Set<Integer> removed) throws BackendException {
        for (int i = 0; i < this.numKeys; ++i) {
            boolean result = this.store.containsKey(KeyValueStoreUtil.getBuffer(i), this.tx);
            if (removed.contains(i)) {
                Assert.assertFalse((boolean)result);
                continue;
            }
            Assert.assertTrue((boolean)result);
        }
    }

    public void checkValues(String[] values) throws BackendException {
        this.checkValues(values, new HashSet<Integer>());
    }

    public void checkValues(String[] values, Set<Integer> removed) throws BackendException {
        for (int i = 0; i < this.numKeys; ++i) {
            StaticBuffer result = this.store.get(KeyValueStoreUtil.getBuffer(i), this.tx);
            if (removed.contains(i)) {
                Assert.assertNull((Object)result);
                continue;
            }
            Assert.assertEquals((Object)values[i], (Object)KeyValueStoreUtil.getString(result));
        }
        if (this.manager.getFeatures().hasMultiQuery()) {
            ArrayList queries = Lists.newArrayList();
            for (int i = 0; i < this.numKeys; ++i) {
                StaticBuffer key = KeyValueStoreUtil.getBuffer(i);
                queries.add(new KVQuery(key, BufferUtil.nextBiggerBuffer((StaticBuffer)key), 2));
            }
            Map results = this.store.getSlices((List)queries, this.tx);
            for (int i = 0; i < this.numKeys; ++i) {
                StaticBuffer value;
                RecordIterator result = (RecordIterator)results.get(queries.get(i));
                Assert.assertNotNull((Object)result);
                if (result.hasNext()) {
                    value = ((KeyValueEntry)result.next()).getValue();
                    Assert.assertFalse((boolean)result.hasNext());
                } else {
                    value = null;
                }
                if (removed.contains(i)) {
                    Assert.assertNull((Object)value);
                    continue;
                }
                Assert.assertEquals((Object)values[i], (Object)KeyValueStoreUtil.getString(value));
            }
        }
    }

    @Test
    public void storeAndRetrieve() throws BackendException {
        String[] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        this.log.debug("Checking values...");
        this.checkValueExistence(values);
        this.checkValues(values);
    }

    @Test
    public void storeAndRetrieveWithClosing() throws BackendException {
        String[] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        this.clopen();
        this.log.debug("Checking values...");
        this.checkValueExistence(values);
        this.checkValues(values);
    }

    @Test
    public void deletionTest1() throws BackendException {
        String[] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        this.clopen();
        Set<Integer> deleted = this.deleteValues(0, 10);
        this.log.debug("Checking values...");
        this.checkValueExistence(values, deleted);
        this.checkValues(values, deleted);
    }

    @Test
    public void deletionTest2() throws BackendException {
        String[] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        Set<Integer> deleted = this.deleteValues(0, 10);
        this.clopen();
        this.log.debug("Checking values...");
        this.checkValueExistence(values, deleted);
        this.checkValues(values, deleted);
    }

    @Test
    public void scanTest() throws BackendException {
        if (this.manager.getFeatures().hasScan()) {
            String[] values = this.generateValues();
            this.loadValues(values);
            RecordIterator<KeyValueEntry> iterator0 = this.getAllData(this.tx);
            Assert.assertEquals((long)this.numKeys, (long)KeyValueStoreUtil.count(iterator0));
            this.clopen();
            RecordIterator<KeyValueEntry> iterator1 = this.getAllData(this.tx);
            RecordIterator<KeyValueEntry> iterator2 = this.getAllData(this.tx);
            RecordIterator<KeyValueEntry> iterator3 = this.getAllData(this.tx);
            Assert.assertEquals((long)this.numKeys, (long)KeyValueStoreUtil.count(iterator1));
            Assert.assertEquals((long)this.numKeys, (long)KeyValueStoreUtil.count(iterator2));
        }
    }

    private RecordIterator<KeyValueEntry> getAllData(StoreTransaction tx) throws BackendException {
        return this.store.getSlice(new KVQuery(BackendTransaction.EDGESTORE_MIN_KEY, BackendTransaction.EDGESTORE_MAX_KEY), tx);
    }

    public void checkSlice(String[] values, Set<Integer> removed, int start, int end, int limit) throws BackendException {
        EntryList entries = limit <= 0 ? KVUtil.getSlice((OrderedKeyValueStore)this.store, (StaticBuffer)KeyValueStoreUtil.getBuffer(start), (StaticBuffer)KeyValueStoreUtil.getBuffer(end), (StoreTransaction)this.tx) : KVUtil.getSlice((OrderedKeyValueStore)this.store, (StaticBuffer)KeyValueStoreUtil.getBuffer(start), (StaticBuffer)KeyValueStoreUtil.getBuffer(end), (int)limit, (StoreTransaction)this.tx);
        int pos = 0;
        for (int i = start; i < end; ++i) {
            if (removed.contains(i)) continue;
            if (pos < limit) {
                Entry entry = (Entry)entries.get(pos);
                int id = KeyValueStoreUtil.getID(entry.getColumn());
                String str = KeyValueStoreUtil.getString((StaticBuffer)entry.getValueAs(StaticBuffer.STATIC_FACTORY));
                Assert.assertEquals((long)i, (long)id);
                Assert.assertEquals((Object)values[i], (Object)str);
            }
            ++pos;
        }
        if (limit > 0 && pos >= limit) {
            Assert.assertEquals((long)limit, (long)entries.size());
        } else {
            Assert.assertNotNull((Object)entries);
            Assert.assertEquals((long)pos, (long)entries.size());
        }
    }

    @Test
    public void intervalTest1() throws BackendException {
        String[] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        Set<Integer> deleted = this.deleteValues(0, 10);
        this.clopen();
        this.checkSlice(values, deleted, 5, 25, -1);
        this.checkSlice(values, deleted, 5, 250, 10);
        this.checkSlice(values, deleted, 500, 1250, -1);
        this.checkSlice(values, deleted, 500, 1250, 1000);
        this.checkSlice(values, deleted, 500, 1250, 100);
        this.checkSlice(values, deleted, 50, 20, 10);
        this.checkSlice(values, deleted, 50, 20, -1);
    }
}

