/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.indexing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.core.attribute.Geo;
import com.thinkaurelius.titan.core.attribute.Geoshape;
import com.thinkaurelius.titan.core.attribute.Text;
import com.thinkaurelius.titan.core.schema.Mapping;
import com.thinkaurelius.titan.core.schema.Parameter;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BaseTransaction;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.EntryMetaData;
import com.thinkaurelius.titan.diskstorage.indexing.IndexEntry;
import com.thinkaurelius.titan.diskstorage.indexing.IndexFeatures;
import com.thinkaurelius.titan.diskstorage.indexing.IndexProvider;
import com.thinkaurelius.titan.diskstorage.indexing.IndexQuery;
import com.thinkaurelius.titan.diskstorage.indexing.IndexTransaction;
import com.thinkaurelius.titan.diskstorage.indexing.KeyInformation;
import com.thinkaurelius.titan.diskstorage.indexing.RawQuery;
import com.thinkaurelius.titan.diskstorage.indexing.StandardKeyInformation;
import com.thinkaurelius.titan.diskstorage.util.StandardBaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.util.time.StandardDuration;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.diskstorage.util.time.Timestamps;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.condition.And;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.Not;
import com.thinkaurelius.titan.graphdb.query.condition.Or;
import com.thinkaurelius.titan.graphdb.query.condition.PredicateCondition;
import com.thinkaurelius.titan.testutil.RandomGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IndexProviderTest {
    private Logger log = LoggerFactory.getLogger(IndexProviderTest.class);
    private static final Random random = new Random();
    private static final Parameter[] NO_PARAS = new Parameter[0];
    protected IndexProvider index;
    protected IndexFeatures indexFeatures;
    protected IndexTransaction tx;
    protected Map<String, KeyInformation> allKeys;
    protected KeyInformation.IndexRetriever indexRetriever;
    public static final String TEXT = "text";
    public static final String TIME = "time";
    public static final String WEIGHT = "weight";
    public static final String LOCATION = "location";
    public static final String NAME = "name";
    private final String defStore = "store1";
    private final String defDoc = "docx1";
    private final String defTextValue = "the quick brown fox jumps over the lazy dog";

    public static StandardKeyInformation of(Class<?> clazz, Parameter ... paras) {
        return new StandardKeyInformation(clazz, paras);
    }

    public static final KeyInformation.IndexRetriever getIndexRetriever(final Map<String, KeyInformation> mappings) {
        return new KeyInformation.IndexRetriever(){

            public KeyInformation get(String store, String key) {
                return (KeyInformation)mappings.get(key);
            }

            public KeyInformation.StoreRetriever get(String store) {
                return new KeyInformation.StoreRetriever(){

                    public KeyInformation get(String key) {
                        return (KeyInformation)mappings.get(key);
                    }
                };
            }
        };
    }

    public static final Map<String, KeyInformation> getMapping(final IndexFeatures indexFeatures) {
        Preconditions.checkArgument((indexFeatures.supportsStringMapping(Mapping.TEXTSTRING) || indexFeatures.supportsStringMapping(Mapping.TEXT) && indexFeatures.supportsStringMapping(Mapping.STRING) ? 1 : 0) != 0, (Object)"Index must support string and text mapping");
        return new HashMap<String, KeyInformation>(){
            {
                this.put(IndexProviderTest.TEXT, new StandardKeyInformation(String.class, new Parameter[]{new Parameter("mapping", (Object)(indexFeatures.supportsStringMapping(Mapping.TEXT) ? Mapping.TEXT : Mapping.TEXTSTRING))}));
                this.put(IndexProviderTest.TIME, new StandardKeyInformation(Long.class));
                this.put(IndexProviderTest.WEIGHT, new StandardKeyInformation(Double.class, new Parameter[]{new Parameter("mapping", (Object)Mapping.DEFAULT)}));
                this.put(IndexProviderTest.LOCATION, new StandardKeyInformation(Geoshape.class));
                this.put(IndexProviderTest.NAME, new StandardKeyInformation(String.class, new Parameter[]{new Parameter("mapping", (Object)(indexFeatures.supportsStringMapping(Mapping.STRING) ? Mapping.STRING : Mapping.TEXTSTRING))}));
            }
        };
    }

    public abstract IndexProvider openIndex() throws BackendException;

    public abstract boolean supportsLuceneStyleQueries();

    @Before
    public void setUp() throws Exception {
        this.index = this.openIndex();
        this.index.clearStorage();
        this.index.close();
        this.open();
    }

    public void open() throws BackendException {
        this.index = this.openIndex();
        this.indexFeatures = this.index.getFeatures();
        this.allKeys = IndexProviderTest.getMapping(this.indexFeatures);
        this.indexRetriever = IndexProviderTest.getIndexRetriever(this.allKeys);
        this.newTx();
    }

    public void newTx() throws BackendException {
        if (this.tx != null) {
            this.tx.commit();
        }
        this.tx = this.openTx();
    }

    public IndexTransaction openTx() throws BackendException {
        StandardBaseTransactionConfig config = StandardBaseTransactionConfig.of((TimestampProvider)Timestamps.MILLI);
        return new IndexTransaction(this.index, this.indexRetriever, (BaseTransactionConfig)config, (Duration)new StandardDuration(2000L, TimeUnit.MILLISECONDS));
    }

    @After
    public void tearDown() throws Exception {
        this.close();
    }

    public void close() throws BackendException {
        if (this.tx != null) {
            this.tx.commit();
        }
        this.index.close();
    }

    public void clopen() throws BackendException {
        this.close();
        this.open();
    }

    @Test
    public void openClose() {
    }

    @Test
    public void singleStore() throws Exception {
        this.storeTest("vertex");
    }

    @Test
    public void multipleStores() throws Exception {
        this.storeTest("vertex", "edge");
    }

    private void storeTest(String ... stores) throws Exception {
        List result;
        Map<String, Object> doc1 = IndexProviderTest.getDocument("Hello world", 1001L, 5.2, Geoshape.point((double)48.0, (double)0.0));
        Map<String, Object> doc2 = IndexProviderTest.getDocument("Tomorrow is the world", 1010L, 8.5, Geoshape.point((double)49.0, (double)1.0));
        Map<String, Object> doc3 = IndexProviderTest.getDocument("Hello Bob, are you there?", -500L, 10.1, Geoshape.point((double)47.0, (double)10.0));
        for (String store : stores) {
            this.initialize(store);
            this.add(store, "doc1", doc1, true);
            this.add(store, "doc2", doc2, true);
            this.add(store, "doc3", doc3, false);
        }
        ImmutableList orderTimeAsc = ImmutableList.of((Object)new IndexQuery.OrderEntry(TIME, Order.ASC, Integer.class));
        ImmutableList orderWeightAsc = ImmutableList.of((Object)new IndexQuery.OrderEntry(WEIGHT, Order.ASC, Double.class));
        ImmutableList orderTimeDesc = ImmutableList.of((Object)new IndexQuery.OrderEntry(TIME, Order.DESC, Integer.class));
        ImmutableList orderWeightDesc = ImmutableList.of((Object)new IndexQuery.OrderEntry(WEIGHT, Order.DESC, Double.class));
        ImmutableList jointOrder = ImmutableList.of((Object)new IndexQuery.OrderEntry(WEIGHT, Order.DESC, Double.class), (Object)new IndexQuery.OrderEntry(TIME, Order.DESC, Integer.class));
        this.clopen();
        for (String store : stores) {
            result = this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"world")));
            Assert.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc2"), (Object)ImmutableSet.copyOf((Collection)result));
            Assert.assertEquals((Object)ImmutableSet.copyOf((Collection)result), (Object)ImmutableSet.copyOf((Collection)this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"wOrLD")))));
            Assert.assertEquals((long)1L, (long)this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"bob"))).size());
            Assert.assertEquals((long)0L, (long)this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"worl"))).size());
            Assert.assertEquals((long)1L, (long)this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"Tomorrow world"))).size());
            Assert.assertEquals((long)1L, (long)this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"WorLD HELLO"))).size());
            result = this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"world"), orderTimeDesc));
            Assert.assertEquals((Object)ImmutableList.of((Object)"doc2", (Object)"doc1"), (Object)result);
            result = this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"world"), orderWeightDesc));
            Assert.assertEquals((Object)ImmutableList.of((Object)"doc2", (Object)"doc1"), (Object)result);
            result = this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"world"), orderTimeAsc));
            Assert.assertEquals((Object)ImmutableList.of((Object)"doc1", (Object)"doc2"), (Object)result);
            result = this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"world"), orderWeightAsc));
            Assert.assertEquals((Object)ImmutableList.of((Object)"doc1", (Object)"doc2"), (Object)result);
            result = this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"world"), jointOrder));
            Assert.assertEquals((Object)ImmutableList.of((Object)"doc2", (Object)"doc1"), (Object)result);
            result = this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS_PREFIX, (Object)"w")));
            Assert.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc2"), (Object)ImmutableSet.copyOf((Collection)result));
            result = this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS_PREFIX, (Object)"wOr")));
            Assert.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc2"), (Object)ImmutableSet.copyOf((Collection)result));
            Assert.assertEquals((long)0L, (long)this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS_PREFIX, (Object)"bobi"))).size());
            if (this.index.supports((KeyInformation)new StandardKeyInformation(String.class), (TitanPredicate)Text.CONTAINS_REGEX)) {
                result = this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS_REGEX, (Object)"he[l]+(.*)")));
                Assert.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc3"), (Object)ImmutableSet.copyOf((Collection)result));
                result = this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS_REGEX, (Object)"[h]+e[l]+(.*)")));
                Assert.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc3"), (Object)ImmutableSet.copyOf((Collection)result));
                result = this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS_REGEX, (Object)"he[l]+")));
                Assert.assertTrue((boolean)result.isEmpty());
                result = this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS_REGEX, (Object)"e[l]+(.*)")));
                Assert.assertTrue((boolean)result.isEmpty());
            }
            for (Text tp : new Text[]{Text.PREFIX, Text.REGEX}) {
                try {
                    Assert.assertEquals((long)0L, (long)this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)tp, (Object)"tzubull"))).size());
                    if (!this.indexFeatures.supportsStringMapping(Mapping.TEXT)) continue;
                    Assert.fail();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            Assert.assertEquals((long)1L, (long)this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (TitanPredicate)Cmp.EQUAL, (Object)"Tomorrow is the world"))).size());
            Assert.assertEquals((long)0L, (long)this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (TitanPredicate)Cmp.EQUAL, (Object)"world"))).size());
            Assert.assertEquals((long)3L, (long)this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (TitanPredicate)Cmp.NOT_EQUAL, (Object)"bob"))).size());
            Assert.assertEquals((long)1L, (long)this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (TitanPredicate)Text.PREFIX, (Object)"Tomorrow"))).size());
            Assert.assertEquals((long)0L, (long)this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (TitanPredicate)Text.PREFIX, (Object)"wor"))).size());
            for (Text tp : new Text[]{Text.CONTAINS, Text.CONTAINS_PREFIX, Text.CONTAINS_REGEX}) {
                try {
                    Assert.assertEquals((long)0L, (long)this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (TitanPredicate)tp, (Object)"tzubull"))).size());
                    if (!this.indexFeatures.supportsStringMapping(Mapping.STRING)) continue;
                    Assert.fail();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.index.supports((KeyInformation)new StandardKeyInformation(String.class), (TitanPredicate)Text.REGEX)) {
                Assert.assertEquals((long)1L, (long)this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (TitanPredicate)Text.REGEX, (Object)"Tomo[r]+ow is.*world"))).size());
                Assert.assertEquals((long)0L, (long)this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (TitanPredicate)Text.REGEX, (Object)"Tomorrow"))).size());
            }
            if (this.index.supports((KeyInformation)new StandardKeyInformation(String.class, new Parameter[]{new Parameter("mapping", (Object)Mapping.STRING)}), (TitanPredicate)Text.REGEX)) {
                Assert.assertEquals((long)1L, (long)this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (TitanPredicate)Text.REGEX, (Object)"Tomo[r]+ow is.*world"))).size());
                Assert.assertEquals((long)0L, (long)this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (TitanPredicate)Text.REGEX, (Object)"Tomorrow"))).size());
            }
            result = this.tx.query(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"world"), PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"hello")})));
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)"doc1", result.get(0));
            result = this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TIME, (TitanPredicate)Cmp.EQUAL, (Object)-500)));
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)"doc3", result.get(0));
            result = this.tx.query(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{Or.of((Condition[])new Condition[]{PredicateCondition.of((Object)TIME, (TitanPredicate)Cmp.EQUAL, (Object)1001), PredicateCondition.of((Object)TIME, (TitanPredicate)Cmp.EQUAL, (Object)-500)})})));
            Assert.assertEquals((long)2L, (long)result.size());
            result = this.tx.query(new IndexQuery(store, (Condition)Not.of((Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"world"))));
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)"doc3", result.get(0));
            result = this.tx.query(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)TIME, (TitanPredicate)Cmp.EQUAL, (Object)-500), Not.of((Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"world"))})));
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)"doc3", result.get(0));
            result = this.tx.query(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{Or.of((Condition[])new Condition[]{PredicateCondition.of((Object)TIME, (TitanPredicate)Cmp.EQUAL, (Object)1001), PredicateCondition.of((Object)TIME, (TitanPredicate)Cmp.EQUAL, (Object)-500)}), PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"world")})));
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)"doc1", result.get(0));
            result = this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"Bob")));
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)"doc3", result.get(0));
            result = this.tx.query(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"Bob")})));
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)"doc3", result.get(0));
            result = this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"bob")));
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)"doc3", result.get(0));
            result = this.tx.query(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"world"), PredicateCondition.of((Object)WEIGHT, (TitanPredicate)Cmp.GREATER_THAN, (Object)6.0)})));
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)"doc2", result.get(0));
            result = this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)LOCATION, (TitanPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)48.5, (double)0.5, (double)200.0))));
            Assert.assertEquals((long)2L, (long)result.size());
            Assert.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc2"), (Object)ImmutableSet.copyOf((Collection)result));
            result = this.tx.query(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"tomorrow"), PredicateCondition.of((Object)LOCATION, (TitanPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)48.5, (double)0.5, (double)200.0))})));
            Assert.assertEquals((Object)ImmutableSet.of((Object)"doc2"), (Object)ImmutableSet.copyOf((Collection)result));
            result = this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)LOCATION, (TitanPredicate)Geo.WITHIN, (Object)Geoshape.box((double)46.5, (double)-0.5, (double)50.5, (double)10.5))));
            Assert.assertEquals((long)3L, (long)result.size());
            Assert.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc2", (Object)"doc3"), (Object)ImmutableSet.copyOf((Collection)result));
            result = this.tx.query(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)TIME, (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)-1000), PredicateCondition.of((Object)TIME, (TitanPredicate)Cmp.LESS_THAN, (Object)1010), PredicateCondition.of((Object)LOCATION, (TitanPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)48.5, (double)0.5, (double)1000.0))})));
            Assert.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc3"), (Object)ImmutableSet.copyOf((Collection)result));
            result = this.tx.query(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (TitanPredicate)Cmp.GREATER_THAN, (Object)10.0)})));
            Assert.assertEquals((Object)ImmutableSet.of((Object)"doc3"), (Object)ImmutableSet.copyOf((Collection)result));
            result = this.tx.query(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)"blah", (TitanPredicate)Cmp.GREATER_THAN, (Object)10.0)})));
            Assert.assertEquals((long)0L, (long)result.size());
            if (this.supportsLuceneStyleQueries()) {
                Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query(new RawQuery(store, "text:\"Hello Bob\"", NO_PARAS))));
                Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.tx.query(new RawQuery(store, "text:\"Hello Bob\"", NO_PARAS).setOffset(1))));
                Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query(new RawQuery(store, "text:(world AND tomorrow)", NO_PARAS))));
                Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)this.tx.query(new RawQuery(store, "text:(you there Hello Bob)", NO_PARAS))));
                Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query(new RawQuery(store, "text:(you there Hello Bob)", NO_PARAS).setLimit(1))));
                Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query(new RawQuery(store, "text:(you there Hello Bob)", NO_PARAS).setLimit(1).setOffset(1))));
                Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.tx.query(new RawQuery(store, "text:(you there Hello Bob)", NO_PARAS).setLimit(1).setOffset(2))));
                Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)this.tx.query(new RawQuery(store, "text:\"world\"", NO_PARAS))));
                Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)this.tx.query(new RawQuery(store, "time:[1000 TO 1020]", NO_PARAS))));
                Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query(new RawQuery(store, "text:world AND time:1001", NO_PARAS))));
                Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query(new RawQuery(store, "name:\"Hello world\"", NO_PARAS))));
            }
            this.add(store, "doc4", IndexProviderTest.getDocument("I'ts all a big Bob", -100L, 11.2, Geoshape.point((double)48.0, (double)8.0)), true);
            this.remove(store, "doc2", doc2, true);
            this.remove(store, "doc3", (Map<String, Object>)ImmutableMap.of((Object)WEIGHT, (Object)10.1), false);
            this.add(store, "doc3", (Map<String, Object>)ImmutableMap.of((Object)TIME, (Object)2000, (Object)TEXT, (Object)"Bob owns the world"), false);
            this.remove(store, "doc1", (Map<String, Object>)ImmutableMap.of((Object)TIME, (Object)1001), false);
            this.add(store, "doc1", (Map<String, Object>)ImmutableMap.of((Object)TIME, (Object)1005, (Object)WEIGHT, (Object)11.1), false);
        }
        this.clopen();
        for (String store : stores) {
            result = this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"world")));
            Assert.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc3"), (Object)ImmutableSet.copyOf((Collection)result));
            result = this.tx.query(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"world"), PredicateCondition.of((Object)WEIGHT, (TitanPredicate)Cmp.GREATER_THAN, (Object)6.0)})));
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)"doc1", result.get(0));
            result = this.tx.query(new IndexQuery(store, (Condition)PredicateCondition.of((Object)LOCATION, (TitanPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)48.5, (double)0.5, (double)200.0))));
            Assert.assertEquals((Object)ImmutableSet.of((Object)"doc1"), (Object)ImmutableSet.copyOf((Collection)result));
            result = this.tx.query(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"tomorrow"), PredicateCondition.of((Object)LOCATION, (TitanPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)48.5, (double)0.5, (double)200.0))})));
            Assert.assertEquals((Object)ImmutableSet.of(), (Object)ImmutableSet.copyOf((Collection)result));
            result = this.tx.query(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)TIME, (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)-1000), PredicateCondition.of((Object)TIME, (TitanPredicate)Cmp.LESS_THAN, (Object)1010), PredicateCondition.of((Object)LOCATION, (TitanPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)48.5, (double)0.5, (double)1000.0))})));
            Assert.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc4"), (Object)ImmutableSet.copyOf((Collection)result));
            result = this.tx.query(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (TitanPredicate)Cmp.GREATER_THAN, (Object)10.0)})));
            Assert.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc4"), (Object)ImmutableSet.copyOf((Collection)result));
            result = this.tx.query(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)"blah", (TitanPredicate)Cmp.GREATER_THAN, (Object)10.0)})));
            Assert.assertEquals((long)0L, (long)result.size());
        }
    }

    private static String padNumber(long number) {
        String s = Long.toString(number);
        while (s.length() < 18) {
            s = "0" + s;
        }
        return s;
    }

    @Test
    public void testCommonSupport() {
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(String.class, new Parameter[0])));
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(String.class, new Parameter("mapping", (Object)Mapping.TEXT))));
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(String.class, new Parameter("mapping", (Object)Mapping.STRING))));
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Double.class, new Parameter[0])));
        Assert.assertFalse((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Double.class, new Parameter("mapping", (Object)Mapping.TEXT))));
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Long.class, new Parameter[0])));
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Long.class, new Parameter("mapping", (Object)Mapping.DEFAULT))));
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Integer.class, new Parameter[0])));
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Short.class, new Parameter[0])));
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Byte.class, new Parameter[0])));
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Float.class, new Parameter[0])));
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Geoshape.class, new Parameter[0])));
        Assert.assertFalse((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Object.class, new Parameter[0])));
        Assert.assertFalse((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Exception.class, new Parameter[0])));
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Double.class, new Parameter[0]), (TitanPredicate)Cmp.EQUAL));
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Double.class, new Parameter[0]), (TitanPredicate)Cmp.GREATER_THAN_EQUAL));
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Double.class, new Parameter[0]), (TitanPredicate)Cmp.LESS_THAN));
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Double.class, new Parameter("mapping", (Object)Mapping.DEFAULT)), (TitanPredicate)Cmp.LESS_THAN));
        Assert.assertFalse((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Double.class, new Parameter("mapping", (Object)Mapping.TEXT)), (TitanPredicate)Cmp.LESS_THAN));
        Assert.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Geoshape.class, new Parameter[0]), (TitanPredicate)Geo.WITHIN));
        Assert.assertFalse((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Double.class, new Parameter[0]), (TitanPredicate)Geo.INTERSECT));
        Assert.assertFalse((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Long.class, new Parameter[0]), (TitanPredicate)Text.CONTAINS));
        Assert.assertFalse((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Geoshape.class, new Parameter[0]), (TitanPredicate)Geo.DISJOINT));
    }

    @Test
    public void largeTest() throws Exception {
        int numDoc = 30000;
        String store = "vertex";
        this.initialize(store);
        for (int i = 1; i <= numDoc; ++i) {
            this.add(store, "doc" + i, IndexProviderTest.getRandomDocument(), true);
        }
        this.clopen();
        long time = System.currentTimeMillis();
        List result = this.tx.query(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)0.2), PredicateCondition.of((Object)WEIGHT, (TitanPredicate)Cmp.LESS_THAN, (Object)0.6), PredicateCondition.of((Object)LOCATION, (TitanPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)48.5, (double)0.5, (double)1000.0))})));
        int oldresultSize = result.size();
        System.out.println(result.size() + " vs " + (double)(numDoc / 1000) * 2.4622623015);
        System.out.println("Query time on " + numDoc + " docs (ms): " + (System.currentTimeMillis() - time));
        result = this.tx.query(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)0.2), PredicateCondition.of((Object)WEIGHT, (TitanPredicate)Cmp.LESS_THAN, (Object)0.6), PredicateCondition.of((Object)LOCATION, (TitanPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)48.5, (double)0.5, (double)1000.0))}), numDoc / 1000));
        Assert.assertEquals((long)(numDoc / 1000), (long)result.size());
        result = this.tx.query(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)0.2), PredicateCondition.of((Object)WEIGHT, (TitanPredicate)Cmp.LESS_THAN, (Object)0.6), PredicateCondition.of((Object)LOCATION, (TitanPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)48.5, (double)0.5, (double)1000.0))}), numDoc / 1000 * 100));
        Assert.assertEquals((long)oldresultSize, (long)result.size());
    }

    @Test
    public void testRestore() throws Exception {
        String store1 = "store1";
        String store2 = "store2";
        this.initialize("store1");
        this.initialize("store2");
        this.add("store1", "restore-doc1", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(IndexProviderTest.NAME, "first");
                this.put(IndexProviderTest.TIME, 1L);
                this.put(IndexProviderTest.WEIGHT, 10.2);
            }
        }, true);
        this.add("store1", "restore-doc2", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(IndexProviderTest.NAME, "second");
                this.put(IndexProviderTest.TIME, 2L);
                this.put(IndexProviderTest.WEIGHT, 4.7);
            }
        }, true);
        this.clopen();
        HashSet results = Sets.newHashSet((Iterable)this.tx.query(new IndexQuery("store1", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)4.0)}))));
        Assert.assertEquals((long)2L, (long)results.size());
        this.index.restore((Map)new HashMap<String, Map<String, List<IndexEntry>>>(){
            {
                this.put("store1", new HashMap<String, List<IndexEntry>>(){
                    {
                        this.put("restore-doc1", Collections.emptyList());
                        this.put("restore-doc2", new ArrayList<IndexEntry>(){
                            {
                                this.add(new IndexEntry(IndexProviderTest.NAME, (Object)"not-second"));
                                this.add(new IndexEntry(IndexProviderTest.WEIGHT, (Object)2.1));
                                this.add(new IndexEntry(IndexProviderTest.TIME, (Object)0L));
                            }
                        });
                        this.put("restore-doc3", new ArrayList<IndexEntry>(){
                            {
                                this.add(new IndexEntry(IndexProviderTest.NAME, (Object)"third"));
                                this.add(new IndexEntry(IndexProviderTest.WEIGHT, (Object)11.5));
                                this.add(new IndexEntry(IndexProviderTest.TIME, (Object)3L));
                            }
                        });
                    }
                });
            }
        }, this.indexRetriever, (BaseTransaction)this.tx);
        this.clopen();
        results = Sets.newHashSet((Iterable)this.tx.query(new IndexQuery("store1", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)4.0)}))));
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("restore-doc3"));
        results = Sets.newHashSet((Iterable)this.tx.query(new IndexQuery("store1", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)NAME, (TitanPredicate)Cmp.EQUAL, (Object)"third"), PredicateCondition.of((Object)TIME, (TitanPredicate)Cmp.EQUAL, (Object)3L)}))));
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("restore-doc3"));
        results = Sets.newHashSet((Iterable)this.tx.query(new IndexQuery("store1", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)NAME, (TitanPredicate)Cmp.EQUAL, (Object)"not-second"), PredicateCondition.of((Object)TIME, (TitanPredicate)Cmp.EQUAL, (Object)0L)}))));
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("restore-doc2"));
        this.index.restore((Map)new HashMap<String, Map<String, List<IndexEntry>>>(){
            {
                this.put("store1", new HashMap<String, List<IndexEntry>>(){
                    {
                        this.put("restore-doc1", new ArrayList<IndexEntry>(){
                            {
                                this.add(new IndexEntry(IndexProviderTest.NAME, (Object)"first-restored"));
                                this.add(new IndexEntry(IndexProviderTest.WEIGHT, (Object)7.0));
                                this.add(new IndexEntry(IndexProviderTest.TIME, (Object)4L));
                            }
                        });
                    }
                });
                this.put("store2", new HashMap<String, List<IndexEntry>>(){
                    {
                        this.put("restore-doc1", new ArrayList<IndexEntry>(){
                            {
                                this.add(new IndexEntry(IndexProviderTest.NAME, (Object)"first-in-second-store"));
                                this.add(new IndexEntry(IndexProviderTest.WEIGHT, (Object)4.0));
                                this.add(new IndexEntry(IndexProviderTest.TIME, (Object)5L));
                            }
                        });
                    }
                });
            }
        }, this.indexRetriever, (BaseTransaction)this.tx);
        this.clopen();
        results = Sets.newHashSet((Iterable)this.tx.query(new IndexQuery("store1", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)4.0)}))));
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("restore-doc1"));
        Assert.assertTrue((boolean)results.contains("restore-doc3"));
        results = Sets.newHashSet((Iterable)this.tx.query(new IndexQuery("store1", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)NAME, (TitanPredicate)Cmp.EQUAL, (Object)"first-restored"), PredicateCondition.of((Object)TIME, (TitanPredicate)Cmp.EQUAL, (Object)4L)}))));
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("restore-doc1"));
        results = Sets.newHashSet((Iterable)this.tx.query(new IndexQuery("store2", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)4.0)}))));
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("restore-doc1"));
        results = Sets.newHashSet((Iterable)this.tx.query(new IndexQuery("store2", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)NAME, (TitanPredicate)Cmp.EQUAL, (Object)"first-in-second-store"), PredicateCondition.of((Object)TIME, (TitanPredicate)Cmp.EQUAL, (Object)5L)}))));
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("restore-doc1"));
    }

    @Test
    public void testTTL() throws Exception {
        if (!this.index.getFeatures().supportsDocumentTTL()) {
            return;
        }
        String store = "store1";
        this.initialize("store1");
        this.add("store1", "expiring-doc1", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(IndexProviderTest.NAME, "first");
                this.put(IndexProviderTest.TIME, 1L);
                this.put(IndexProviderTest.WEIGHT, 10.2);
            }
        }, true, 2);
        this.add("store1", "expiring-doc2", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(IndexProviderTest.NAME, "second");
                this.put(IndexProviderTest.TIME, 2L);
                this.put(IndexProviderTest.WEIGHT, 4.7);
            }
        }, true);
        this.add("store1", "expiring-doc3", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(IndexProviderTest.NAME, "third");
                this.put(IndexProviderTest.TIME, 3L);
                this.put(IndexProviderTest.WEIGHT, 5.2);
            }
        }, true, 2);
        this.add("store1", "expiring-doc4", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(IndexProviderTest.NAME, "fourth");
                this.put(IndexProviderTest.TIME, 3L);
                this.put(IndexProviderTest.WEIGHT, 7.7);
            }
        }, true, 7);
        this.clopen();
        HashSet results = Sets.newHashSet((Iterable)this.tx.query(new IndexQuery("store1", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)4.0)}))));
        Assert.assertEquals((long)4L, (long)results.size());
        Thread.sleep(6000L);
        results = Sets.newHashSet((Iterable)this.tx.query(new IndexQuery("store1", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)4.0)}))));
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("expiring-doc2"));
        Assert.assertTrue((boolean)results.contains("expiring-doc4"));
        Thread.sleep(5000L);
        results = Sets.newHashSet((Iterable)this.tx.query(new IndexQuery("store1", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (TitanPredicate)Cmp.GREATER_THAN_EQUAL, (Object)4.0)}))));
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.contains("expiring-doc2"));
    }

    private void runConflictingTx(TxJob job1, TxJob job2) throws Exception {
        this.initialize("store1");
        ImmutableMap initialProps = ImmutableMap.of((Object)TEXT, (Object)"the quick brown fox jumps over the lazy dog");
        this.add("store1", "docx1", (Map<String, Object>)initialProps, true);
        this.clopen();
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"brown")), "docx1");
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"periwinkle")), null);
        IndexTransaction tx1 = this.openTx();
        IndexTransaction tx2 = this.openTx();
        job1.run(tx1);
        tx1.commit();
        job2.run(tx2);
        tx2.commit();
        this.clopen();
    }

    private void checkResult(IndexQuery query, String containedDoc) throws Exception {
        List result = this.tx.query(query);
        if (containedDoc != null) {
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)containedDoc, result.get(0));
        } else {
            Assert.assertEquals((long)0L, (long)result.size());
        }
    }

    @Test
    public void testDeleteDocumentThenDeleteField() throws Exception {
        this.runConflictingTx(new TxJob(){

            @Override
            public void run(IndexTransaction tx) {
                tx.delete("store1", "docx1", IndexProviderTest.TEXT, (Object)ImmutableMap.of(), true);
            }
        }, new TxJob(){

            @Override
            public void run(IndexTransaction tx) {
                tx.delete("store1", "docx1", IndexProviderTest.TEXT, (Object)"the quick brown fox jumps over the lazy dog", false);
            }
        });
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"brown")), null);
    }

    @Test
    public void testDeleteDocumentThenModifyField() throws Exception {
        this.runConflictingTx(new TxJob(){

            @Override
            public void run(IndexTransaction tx) {
                tx.delete("store1", "docx1", IndexProviderTest.TEXT, (Object)ImmutableMap.of(), true);
            }
        }, new TxJob(){

            @Override
            public void run(IndexTransaction tx) {
                tx.add("store1", "docx1", IndexProviderTest.TEXT, (Object)"the slow brown fox jumps over the lazy dog", false);
            }
        });
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"brown")), "docx1");
    }

    @Test
    public void testDeleteDocumentThenAddField() throws Exception {
        String nameValue = "jm keynes";
        this.runConflictingTx(new TxJob(){

            @Override
            public void run(IndexTransaction tx) {
                tx.delete("store1", "docx1", IndexProviderTest.TEXT, (Object)ImmutableMap.of(), true);
            }
        }, new TxJob(){

            @Override
            public void run(IndexTransaction tx) {
                tx.add("store1", "docx1", IndexProviderTest.NAME, (Object)"jm keynes", false);
            }
        });
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"brown")), null);
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)NAME, (TitanPredicate)Cmp.EQUAL, (Object)"jm keynes")), "docx1");
    }

    @Test
    public void testAddFieldThenDeleteDoc() throws Exception {
        String nameValue = "jm keynes";
        this.runConflictingTx(new TxJob(){

            @Override
            public void run(IndexTransaction tx) {
                tx.add("store1", "docx1", IndexProviderTest.NAME, (Object)"jm keynes", false);
            }
        }, new TxJob(){

            @Override
            public void run(IndexTransaction tx) {
                tx.delete("store1", "docx1", IndexProviderTest.TEXT, (Object)ImmutableMap.of(), true);
            }
        });
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"brown")), null);
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)NAME, (TitanPredicate)Cmp.EQUAL, (Object)"jm keynes")), null);
    }

    @Test
    public void testConflictingAdd() throws Exception {
        String doc2 = "docy2";
        this.runConflictingTx(new TxJob(){

            @Override
            public void run(IndexTransaction tx) {
                ImmutableMap initialProps = ImmutableMap.of((Object)IndexProviderTest.TEXT, (Object)"sugar sugar");
                IndexProviderTest.this.add("store1", "docy2", (Map<String, Object>)initialProps, true);
            }
        }, new TxJob(){

            @Override
            public void run(IndexTransaction tx) {
                ImmutableMap initialProps = ImmutableMap.of((Object)IndexProviderTest.TEXT, (Object)"honey honey");
                IndexProviderTest.this.add("store1", "docy2", (Map<String, Object>)initialProps, true);
            }
        });
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"brown")), "docx1");
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"sugar")), null);
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"honey")), "docy2");
    }

    @Test
    public void testLastWriteWins() throws Exception {
        this.runConflictingTx(new TxJob(){

            @Override
            public void run(IndexTransaction tx) {
                tx.delete("store1", "docx1", IndexProviderTest.TEXT, (Object)"the quick brown fox jumps over the lazy dog", false);
                tx.add("store1", "docx1", IndexProviderTest.TEXT, (Object)"sugar sugar", false);
            }
        }, new TxJob(){

            @Override
            public void run(IndexTransaction tx) {
                tx.delete("store1", "docx1", IndexProviderTest.TEXT, (Object)"the quick brown fox jumps over the lazy dog", false);
                tx.add("store1", "docx1", IndexProviderTest.TEXT, (Object)"honey honey", false);
            }
        });
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"brown")), null);
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"sugar")), null);
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"honey")), "docx1");
    }

    @Test
    public void testUpdateAddition() throws Exception {
        String revisedText = "its a sunny day";
        this.runConflictingTx(new TxJob(){

            @Override
            public void run(IndexTransaction tx) {
                tx.add("store1", "docx1", IndexProviderTest.TEXT, (Object)"its a sunny day", false);
            }
        }, new TxJob(){

            @Override
            public void run(IndexTransaction tx) {
            }
        });
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"brown")), null);
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"sunny")), "docx1");
    }

    @Test
    public void testUpdateDeletion() throws Exception {
        this.runConflictingTx(new TxJob(){

            @Override
            public void run(IndexTransaction tx) {
                tx.delete("store1", "docx1", IndexProviderTest.TEXT, (Object)ImmutableMap.of(), false);
            }
        }, new TxJob(){

            @Override
            public void run(IndexTransaction tx) {
            }
        });
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (TitanPredicate)Text.CONTAINS, (Object)"brown")), null);
    }

    protected void initialize(String store) throws BackendException {
        for (Map.Entry<String, KeyInformation> info : this.allKeys.entrySet()) {
            KeyInformation keyInfo = info.getValue();
            if (!this.index.supports(keyInfo)) continue;
            this.index.register(store, info.getKey(), keyInfo, (BaseTransaction)this.tx);
        }
    }

    protected void add(String store, String docid, Map<String, Object> doc, boolean isNew) {
        this.add(store, docid, doc, isNew, 0);
    }

    private void add(String store, String docid, Map<String, Object> doc, boolean isNew, int ttlInSeconds) {
        for (Map.Entry<String, Object> kv : doc.entrySet()) {
            if (!this.index.supports(this.allKeys.get(kv.getKey()))) continue;
            IndexEntry idx = new IndexEntry(kv.getKey(), kv.getValue());
            if (ttlInSeconds > 0) {
                idx.setMetaData(EntryMetaData.TTL, (Object)ttlInSeconds);
            }
            this.tx.add(store, docid, idx, isNew);
        }
    }

    private void remove(String store, String docid, Map<String, Object> doc, boolean deleteAll) {
        for (Map.Entry<String, Object> kv : doc.entrySet()) {
            if (!this.index.supports(this.allKeys.get(kv.getKey()))) continue;
            this.tx.delete(store, docid, kv.getKey(), kv.getValue(), deleteAll);
        }
    }

    public static Map<String, Object> getDocument(final String txt, final long time, final double weight, final Geoshape geo) {
        return new HashMap<String, Object>(){
            {
                this.put(IndexProviderTest.TEXT, txt);
                this.put(IndexProviderTest.NAME, txt);
                this.put(IndexProviderTest.TIME, time);
                this.put(IndexProviderTest.WEIGHT, weight);
                this.put(IndexProviderTest.LOCATION, geo);
            }
        };
    }

    public static Map<String, Object> getRandomDocument() {
        final StringBuilder s = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            s.append(RandomGenerator.randomString(5, 8)).append(" ");
        }
        return new HashMap<String, Object>(){
            {
                this.put(IndexProviderTest.TEXT, s.toString());
                this.put(IndexProviderTest.NAME, s.toString());
                this.put(IndexProviderTest.TIME, Math.abs(random.nextLong()));
                this.put(IndexProviderTest.WEIGHT, random.nextDouble());
                this.put(IndexProviderTest.LOCATION, Geoshape.point((double)(random.nextDouble() * 180.0 - 90.0), (double)(random.nextDouble() * 360.0 - 180.0)));
            }
        };
    }

    public static void printResult(Iterable<RawQuery.Result<String>> result) {
        for (RawQuery.Result<String> r : result) {
            System.out.println((String)r.getResult() + ":" + r.getScore());
        }
    }

    private static interface TxJob {
        public void run(IndexTransaction var1);
    }
}

