/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.log;

import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.log.LogManager;
import com.thinkaurelius.titan.diskstorage.log.LogTest;
import com.thinkaurelius.titan.diskstorage.log.kcvs.KCVSLogManager;
import com.thinkaurelius.titan.diskstorage.util.time.StandardDuration;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import java.util.concurrent.TimeUnit;

public abstract class KCVSLogTest
extends LogTest {
    public static final String LOG_NAME = "testlog";
    private KeyColumnValueStoreManager storeManager;

    public abstract KeyColumnValueStoreManager openStorageManager() throws BackendException;

    @Override
    public LogManager openLogManager(String senderId) throws BackendException {
        this.storeManager = this.openStorageManager();
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildConfiguration();
        config.set(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, (Object)senderId, new String[0]);
        config.set(GraphDatabaseConfiguration.LOG_READ_INTERVAL, (Object)new StandardDuration(500L, TimeUnit.MILLISECONDS), new String[]{LOG_NAME});
        return new KCVSLogManager(this.storeManager, config.restrictTo(new String[]{LOG_NAME}));
    }

    @Override
    public void setup() throws Exception {
        KeyColumnValueStoreManager m = this.openStorageManager();
        m.clearStorage();
        m.close();
        super.setup();
    }

    @Override
    public void shutdown() throws Exception {
        super.shutdown();
        this.storeManager.close();
    }
}

